/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.maven.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.oomph.maven.Coordinate;
import org.eclipse.oomph.maven.DOMElement;
import org.eclipse.oomph.maven.Dependency;
import org.eclipse.oomph.maven.MavenFactory;
import org.eclipse.oomph.maven.MavenPackage;
import org.eclipse.oomph.maven.Parent;
import org.eclipse.oomph.maven.Project;
import org.eclipse.oomph.maven.Property;
import org.eclipse.oomph.maven.PropertyReference;
import org.eclipse.oomph.maven.Realm;
import org.eclipse.oomph.maven.impl.CoordinateImpl;
import org.w3c.dom.Element;

public class ProjectImpl
extends CoordinateImpl
implements Project {
    protected static final String LOCATION_EDEFAULT = null;
    protected String location = LOCATION_EDEFAULT;
    protected Parent parent;
    protected EList<Dependency> dependencies;
    protected EList<Dependency> managedDependencies;
    protected EList<Property> properties;
    protected EList<Parent> incomingParentReferences;
    protected EList<Dependency> incomingDependencyReferences;
    private final Map<String, Property> propertiesByName = new LinkedHashMap<String, Property>();
    private boolean recursive;
    private final Map<Coordinate, Dependency> managedDependenciesByGroupArtifact = new TreeMap<Coordinate, Dependency>(Coordinate.COMPARATOR_IGNORE_VERSION);
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("\\$\\{([^}]+)\\}");
    private final Set<String> keys = new LinkedHashSet<String>();

    protected ProjectImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return MavenPackage.Literals.PROJECT;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(String newLocation) {
        String oldLocation = this.location;
        this.location = newLocation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldLocation, (Object)this.location));
        }
    }

    @Override
    public Realm getRealm() {
        if (this.eContainerFeatureID() != 9) {
            return null;
        }
        return (Realm)this.eInternalContainer();
    }

    @Override
    public Parent getParent() {
        return this.parent;
    }

    public NotificationChain basicSetParent(Parent newParent, NotificationChain msgs) {
        Parent oldParent = this.parent;
        this.parent = newParent;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldParent, (Object)newParent);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setParent(Parent newParent) {
        if (newParent != this.parent) {
            NotificationChain msgs = null;
            if (this.parent != null) {
                msgs = ((InternalEObject)this.parent).eInverseRemove((InternalEObject)this, 8, Parent.class, msgs);
            }
            if (newParent != null) {
                msgs = ((InternalEObject)newParent).eInverseAdd((InternalEObject)this, 8, Parent.class, msgs);
            }
            if ((msgs = this.basicSetParent(newParent, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)newParent, (Object)newParent));
        }
    }

    @Override
    public EList<Dependency> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = new EObjectContainmentEList(Dependency.class, (InternalEObject)this, 11);
        }
        return this.dependencies;
    }

    @Override
    public EList<Dependency> getManagedDependencies() {
        if (this.managedDependencies == null) {
            this.managedDependencies = new EObjectContainmentEList(Dependency.class, (InternalEObject)this, 12);
        }
        return this.managedDependencies;
    }

    @Override
    public EList<Property> getProperties() {
        if (this.properties == null) {
            this.properties = new EObjectContainmentEList(Property.class, (InternalEObject)this, 13);
        }
        return this.properties;
    }

    @Override
    public EList<Parent> getIncomingParentReferences() {
        if (this.incomingParentReferences == null) {
            this.incomingParentReferences = new EObjectWithInverseResolvingEList(Parent.class, (InternalEObject)this, 14, 10);
        }
        return this.incomingParentReferences;
    }

    @Override
    public EList<Dependency> getIncomingDependencyReferences() {
        if (this.incomingDependencyReferences == null) {
            this.incomingDependencyReferences = new EObjectWithInverseResolvingEList(Dependency.class, (InternalEObject)this, 15, 8);
        }
        return this.incomingDependencyReferences;
    }

    @Override
    public Property getProperty(String key) {
        Project parentProject;
        Parent parent;
        Property property2;
        if (this.recursive) {
            return null;
        }
        EList<Property> properties = this.getProperties();
        if (!properties.isEmpty() && this.propertiesByName.isEmpty()) {
            for (Property property2 : properties) {
                this.propertiesByName.put(property2.getKey(), property2);
            }
        }
        if ((property2 = this.propertiesByName.get(key)) == null && (parent = this.getParent()) != null && (parentProject = parent.getResolvedProject()) != null) {
            try {
                this.recursive = true;
                property2 = parentProject.getProperty(key);
            }
            finally {
                this.recursive = false;
            }
        }
        return property2;
    }

    @Override
    public Dependency getManagedDependency(Dependency dependency) {
        Project parentProject;
        Parent parent;
        Dependency managedDependency2;
        if (this.recursive) {
            return null;
        }
        EList<Dependency> managedDependencies = this.getManagedDependencies();
        if (!managedDependencies.isEmpty() && this.managedDependenciesByGroupArtifact.isEmpty()) {
            for (Dependency managedDependency2 : managedDependencies) {
                this.managedDependenciesByGroupArtifact.put(managedDependency2, managedDependency2);
            }
        }
        if ((managedDependency2 = this.managedDependenciesByGroupArtifact.get(dependency)) == null && (parent = this.getParent()) != null && (parentProject = parent.getResolvedProject()) != null) {
            try {
                this.recursive = true;
                managedDependency2 = parentProject.getManagedDependency(dependency);
            }
            finally {
                this.recursive = false;
            }
        }
        return managedDependency2;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 9: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.eBasicSetContainer(otherEnd, 9, msgs);
            }
            case 10: {
                if (this.parent != null) {
                    msgs = ((InternalEObject)this.parent).eInverseRemove((InternalEObject)this, -11, null, msgs);
                }
                return this.basicSetParent((Parent)otherEnd, msgs);
            }
            case 14: {
                return ((InternalEList)this.getIncomingParentReferences()).basicAdd((Object)otherEnd, msgs);
            }
            case 15: {
                return ((InternalEList)this.getIncomingDependencyReferences()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 9: {
                return this.eBasicSetContainer(null, 9, msgs);
            }
            case 10: {
                return this.basicSetParent(null, msgs);
            }
            case 11: {
                return ((InternalEList)this.getDependencies()).basicRemove((Object)otherEnd, msgs);
            }
            case 12: {
                return ((InternalEList)this.getManagedDependencies()).basicRemove((Object)otherEnd, msgs);
            }
            case 13: {
                return ((InternalEList)this.getProperties()).basicRemove((Object)otherEnd, msgs);
            }
            case 14: {
                return ((InternalEList)this.getIncomingParentReferences()).basicRemove((Object)otherEnd, msgs);
            }
            case 15: {
                return ((InternalEList)this.getIncomingDependencyReferences()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 9: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 2, Realm.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 8: {
                return this.getLocation();
            }
            case 9: {
                return this.getRealm();
            }
            case 10: {
                return this.getParent();
            }
            case 11: {
                return this.getDependencies();
            }
            case 12: {
                return this.getManagedDependencies();
            }
            case 13: {
                return this.getProperties();
            }
            case 14: {
                return this.getIncomingParentReferences();
            }
            case 15: {
                return this.getIncomingDependencyReferences();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 8: {
                this.setLocation((String)newValue);
                return;
            }
            case 10: {
                this.setParent((Parent)newValue);
                return;
            }
            case 11: {
                this.getDependencies().clear();
                this.getDependencies().addAll((Collection)newValue);
                return;
            }
            case 12: {
                this.getManagedDependencies().clear();
                this.getManagedDependencies().addAll((Collection)newValue);
                return;
            }
            case 13: {
                this.getProperties().clear();
                this.getProperties().addAll((Collection)newValue);
                return;
            }
            case 14: {
                this.getIncomingParentReferences().clear();
                this.getIncomingParentReferences().addAll((Collection)newValue);
                return;
            }
            case 15: {
                this.getIncomingDependencyReferences().clear();
                this.getIncomingDependencyReferences().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 8: {
                this.setLocation(LOCATION_EDEFAULT);
                return;
            }
            case 10: {
                this.setParent(null);
                return;
            }
            case 11: {
                this.getDependencies().clear();
                return;
            }
            case 12: {
                this.getManagedDependencies().clear();
                return;
            }
            case 13: {
                this.getProperties().clear();
                return;
            }
            case 14: {
                this.getIncomingParentReferences().clear();
                return;
            }
            case 15: {
                this.getIncomingDependencyReferences().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return LOCATION_EDEFAULT == null ? this.location != null : !LOCATION_EDEFAULT.equals(this.location);
            }
            case 9: {
                return this.getRealm() != null;
            }
            case 10: {
                return this.parent != null;
            }
            case 11: {
                return this.dependencies != null && !this.dependencies.isEmpty();
            }
            case 12: {
                return this.managedDependencies != null && !this.managedDependencies.isEmpty();
            }
            case 13: {
                return this.properties != null && !this.properties.isEmpty();
            }
            case 14: {
                return this.incomingParentReferences != null && !this.incomingParentReferences.isEmpty();
            }
            case 15: {
                return this.incomingDependencyReferences != null && !this.incomingDependencyReferences.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 3: {
                return this.getProperty((String)arguments.get(0));
            }
            case 4: {
                return this.getManagedDependency((Dependency)arguments.get(0));
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (location: ");
        result.append(this.location);
        result.append(')');
        return result.toString();
    }

    protected String expandProperties(DOMElement host, Element hostElement, String value) {
        Matcher matcher = PROPERTY_PATTERN.matcher(value);
        if (matcher.find()) {
            StringBuilder builder = new StringBuilder();
            do {
                String replacement = null;
                String key = matcher.group(1);
                try {
                    if (this.keys.add(key)) {
                        Property property = this.getProperty(key);
                        if (property != null) {
                            replacement = property.getExpandedValue();
                        }
                        this.createPropertyReference(host, hostElement, key, property);
                    }
                }
                finally {
                    this.keys.remove(key);
                }
                matcher.appendReplacement(builder, Matcher.quoteReplacement(replacement == null ? matcher.group() : replacement));
            } while (matcher.find());
            matcher.appendTail(builder);
            return builder.toString();
        }
        return value;
    }

    private void createPropertyReference(DOMElement host, Element hostElement, String key, Property property) {
        PropertyReference propertyReference = MavenFactory.eINSTANCE.createPropertyReference();
        propertyReference.setElement(hostElement);
        propertyReference.setName(key);
        propertyReference.setResolvedProperty(property);
        host.getPropertyReferences().add((Object)propertyReference);
    }
}

