/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeIds;
import org.eclipse.jdt.internal.compiler.util.Util;

public class StringTemplate
extends Expression {
    private StringLiteral[] fragments;
    private Expression[] values;
    public boolean isMultiline;

    public StringTemplate(StringLiteral[] fragments, Expression[] values, int start, int end, boolean isMultiline) {
        this.fragments = fragments;
        this.values = values;
        this.sourceStart = start;
        this.sourceEnd = end;
        this.isMultiline = isMultiline;
    }

    public StringLiteral[] fragments() {
        return this.fragments;
    }

    public Expression[] values() {
        return this.values;
    }

    @Override
    public void resolve(BlockScope scope) {
        Expression[] expressionArray = this.fragments;
        int n = this.fragments.length;
        int n2 = 0;
        while (n2 < n) {
            StringLiteral frag = expressionArray[n2];
            frag.resolveType(scope);
            ++n2;
        }
        expressionArray = this.values;
        n = this.values.length;
        n2 = 0;
        while (n2 < n) {
            Expression exp = expressionArray[n2];
            if (exp != null) {
                exp.resolveType(scope);
                exp.computeConversion(scope, exp.resolvedType, exp.resolvedType);
            }
            ++n2;
        }
    }

    @Override
    public TypeBinding resolveType(BlockScope scope) {
        this.constant = Constant.NotAConstant;
        this.resolvedType = scope.getJavaLangStringTemplate();
        return this.resolvedType;
    }

    private void generateNewTemplateBootstrap(CodeStream codeStream) {
        int index = codeStream.classFile.recordBootstrapMethod(this);
        StringBuilder signature = new StringBuilder("(");
        int argsSize = 0;
        Expression[] expressionArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            Expression exp = expressionArray[n2];
            TypeBinding type = exp.resolvedType;
            if (type == TypeBinding.NULL) {
                signature.append(ConstantPool.JavaLangObjectSignature);
            } else {
                signature.append(type.signature());
            }
            argsSize += TypeIds.getCategory(type.id);
            ++n2;
        }
        signature.append(")Ljava/lang/StringTemplate;");
        codeStream.invokeDynamic(index, argsSize, 1, ConstantPool.PROCESS, signature.toString().toCharArray(), 10, TypeBinding.INT);
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        Expression[] expressionArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            Expression exp = expressionArray[n2];
            flowInfo = exp.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
            ++n2;
        }
        return flowInfo;
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        Expression[] expressionArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            Expression exp = expressionArray[n2];
            exp.generateCode(currentScope, codeStream, valueRequired);
            ++n2;
        }
        this.generateNewTemplateBootstrap(codeStream);
        int pc = codeStream.position;
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    @Override
    public StringBuilder printExpression(int indent, StringBuilder output) {
        int length = this.fragments.length;
        output.append('\"');
        if (this.isMultiline) {
            output.append("\"\"\n");
        }
        int i = 0;
        while (i < length) {
            char[] source;
            char[] cArray = source = this.fragments[i].source();
            int n = source.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                Util.appendEscapedChar(output, c, true);
                ++n2;
            }
            if (i + 1 < length) {
                output.append("\\{");
                if (this.values[i] != null) {
                    this.values[i].printExpression(0, output);
                }
                output.append("}");
            }
            ++i;
        }
        output.append('\"');
        if (this.isMultiline) {
            output.append("\"\"");
        }
        return output;
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            int n;
            int n2;
            Expression[] expressionArray;
            if (this.fragments != null) {
                expressionArray = this.fragments;
                n2 = this.fragments.length;
                n = 0;
                while (n < n2) {
                    Expression frag = expressionArray[n];
                    ((StringLiteral)frag).traverse(visitor, scope);
                    ++n;
                }
            }
            if (this.values != null) {
                expressionArray = this.values;
                n2 = this.values.length;
                n = 0;
                while (n < n2) {
                    Expression exp = expressionArray[n];
                    exp.traverse(visitor, scope);
                    ++n;
                }
            }
        }
    }
}

