/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.MarkerItem;

class MarkerComparator
implements Comparator<MarkerItem> {
    private MarkerField category;
    private MarkerField[] fields;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = -1;
    private static final String PRIMARY_SORT_FIELD_TAG = "PRIMARY_SORT_FIELD";
    private static final String DESCENDING_FIELDS = "DESCENDING_FIELDS";
    HashSet<MarkerField> descendingFields = new HashSet();

    public MarkerComparator(MarkerField categoryField, MarkerField[] mainFields) {
        this.category = categoryField;
        this.fields = mainFields;
    }

    public int compareCategory(MarkerItem object1, MarkerItem object2) {
        if (this.category == null) {
            return 0;
        }
        return this.category.compare(object1, object2);
    }

    Comparator<MarkerItem> getCategoryComparator() {
        return this::compareCategory;
    }

    @Override
    public int compare(MarkerItem item1, MarkerItem item2) {
        int value = this.compareCategory(item1, item2);
        if (value != 0) {
            return value;
        }
        return this.compareFields(item1, item2);
    }

    public int compareFields(MarkerItem item0, MarkerItem item1) {
        int value = 0;
        MarkerField[] markerFieldArray = this.fields;
        int n = this.fields.length;
        int n2 = 0;
        while (n2 < n) {
            MarkerField field = markerFieldArray[n2];
            value = field.compare(item0, item1);
            if (value != 0) {
                if (!this.descendingFields.contains(field)) break;
                value = -value;
                break;
            }
            ++n2;
        }
        return value;
    }

    Comparator<MarkerItem> getFieldsComparator() {
        return this::compareFields;
    }

    public void reversePriority(MarkerField field) {
        if (this.descendingFields.remove(field)) {
            return;
        }
        this.descendingFields.add(field);
    }

    void setPrimarySortField(MarkerField field) {
        if (this.fields[0] == field) {
            this.reversePriority(field);
            return;
        }
        int insertionIndex = 1;
        MarkerField[] newFields = new MarkerField[this.fields.length];
        newFields[0] = field;
        int i = 0;
        while (i < newFields.length) {
            if (this.fields[i] != field) {
                newFields[insertionIndex] = this.fields[i];
                ++insertionIndex;
            }
            ++i;
        }
        this.fields = newFields;
    }

    void restore(IMemento memento) {
        if (memento == null) {
            return;
        }
        String primaryField = memento.getString(PRIMARY_SORT_FIELD_TAG);
        if (primaryField == null || primaryField.equals(MarkerSupportInternalUtilities.getId(this.fields[0]))) {
            return;
        }
        int i = 1;
        while (i < this.fields.length) {
            if (MarkerSupportInternalUtilities.getId(this.fields[i]).equals(primaryField)) {
                this.setPrimarySortField(this.fields[i]);
                break;
            }
            ++i;
        }
        IMemento[] descending = memento.getChildren(DESCENDING_FIELDS);
        MarkerField[] markerFieldArray = this.fields;
        int n = this.fields.length;
        int n2 = 0;
        while (n2 < n) {
            MarkerField field = markerFieldArray[n2];
            IMemento[] iMementoArray = descending;
            int n3 = descending.length;
            int n4 = 0;
            while (n4 < n3) {
                IMemento currentMemento = iMementoArray[n4];
                if (currentMemento.getID().equals(MarkerSupportInternalUtilities.getId(field))) {
                    this.descendingFields.add(field);
                }
                ++n4;
            }
            ++n2;
        }
    }

    void saveState(IMemento memento) {
        memento.putString(PRIMARY_SORT_FIELD_TAG, MarkerSupportInternalUtilities.getId(this.fields[0]));
        Iterator<MarkerField> descendingIterator = this.descendingFields.iterator();
        while (descendingIterator.hasNext()) {
            memento.createChild(DESCENDING_FIELDS, MarkerSupportInternalUtilities.getId(descendingIterator.next()));
        }
    }

    MarkerField getPrimarySortField() {
        return this.fields[0];
    }

    void setCategory(MarkerField category) {
        this.category = category;
    }

    public MarkerField[] getFields() {
        return this.fields;
    }

    public MarkerField getCategory() {
        return this.category;
    }
}

