/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.ui;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedFontRegistry;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.oomph.internal.ui.GeneralDragAdapter;
import org.eclipse.oomph.internal.ui.OomphTransferDelegate;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.AgentManager;
import org.eclipse.oomph.p2.core.AgentManagerElement;
import org.eclipse.oomph.p2.core.BundlePool;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.p2.internal.core.AgentAnalyzer;
import org.eclipse.oomph.p2.internal.core.AgentManagerElementImpl;
import org.eclipse.oomph.p2.internal.ui.AgentAnalyzerDialog;
import org.eclipse.oomph.p2.internal.ui.AgentManagerDialog;
import org.eclipse.oomph.p2.internal.ui.Messages;
import org.eclipse.oomph.p2.internal.ui.P2ContentProvider;
import org.eclipse.oomph.p2.internal.ui.P2LabelProvider;
import org.eclipse.oomph.p2.internal.ui.P2UIPlugin;
import org.eclipse.oomph.p2.internal.ui.P2ViewerSorter;
import org.eclipse.oomph.p2.internal.ui.ProfileDetailsDialog;
import org.eclipse.oomph.ui.ErrorDialog;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.OomphPlugin;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentManagerComposite
extends Composite {
    private static final OomphPlugin.Preference PREF_SHOW_PROFILES = P2UIPlugin.INSTANCE.getConfigurationPreference("showProfiles");
    private static final int DND_OPERATIONS = 7;
    private static final List<? extends OomphTransferDelegate> DND_DELEGATES = Collections.singletonList(new OomphTransferDelegate.TextTransferDelegate());
    private static final Transfer[] DND_TRANSFERS = new Transfer[]{DND_DELEGATES.get(0).getTransfer()};
    private TreeViewer treeViewer;
    private BundlePool selectedPool;
    private Object selectedElement;
    private Button clearButton;
    private Button refreshButton;
    private Button newAgentButton;
    private Button newPoolButton;
    private Button selectPoolButton;
    private Button deleteButton;
    private Button cleanupButton;
    private Button analyzeButton;
    private Button showProfilesButton;
    private Button profileDetailsButton;

    public AgentManagerComposite(Composite parent, int style) {
        this(parent, style, false, null);
    }

    public AgentManagerComposite(Composite parent, int style, BundlePool selection) {
        this(parent, style, true, selection);
    }

    private AgentManagerComposite(Composite parent, int style, boolean poolSelection, final BundlePool selection) {
        super(parent, style);
        UIUtil.setTransparentBackgroundColor((Control)this);
        this.setLayout((Layout)UIUtil.createGridLayout((int)2));
        this.selectedPool = selection;
        final P2ContentProvider contentProvider = new P2ContentProvider();
        this.treeViewer = new TreeViewer((Composite)this, 2048);
        this.treeViewer.setContentProvider((IContentProvider)contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new P2LabelProvider(poolSelection ? new IFontProvider(){

            public Font getFont(Object element) {
                if (element == AgentManagerComposite.this.selectedPool) {
                    return ExtendedFontRegistry.INSTANCE.getFont(AgentManagerComposite.this.treeViewer.getTree().getFont(), (Object)IItemFontProvider.BOLD_FONT);
                }
                return null;
            }
        } : null));
        this.treeViewer.setComparator((ViewerComparator)new P2ViewerSorter());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AgentManagerComposite.this.selectedElement = ((IStructuredSelection)AgentManagerComposite.this.treeViewer.getSelection()).getFirstElement();
                AgentManagerComposite.this.elementChanged(AgentManagerComposite.this.selectedElement);
            }
        });
        Tree tree = this.treeViewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (AgentManagerComposite.this.selectedElement instanceof Profile) {
                    AgentManagerComposite.this.showProfileDetails();
                } else if (AgentManagerComposite.this.selectPoolButton != null && AgentManagerComposite.this.selectPoolButton.isEnabled()) {
                    AgentManagerComposite.this.selectPoolButton.notifyListeners(13, new Event());
                } else {
                    AgentManagerComposite.this.treeViewer.setExpandedState(AgentManagerComposite.this.selectedElement, !AgentManagerComposite.this.treeViewer.getExpandedState(AgentManagerComposite.this.selectedElement));
                }
            }
        });
        AgentManagerComposite.addDragSupport((StructuredViewer)this.treeViewer);
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127 && AgentManagerComposite.this.deleteButton.isEnabled()) {
                    AgentManagerComposite.this.deletePressed();
                }
            }
        });
        GridLayout buttonLayout = new GridLayout(1, false);
        buttonLayout.marginWidth = 0;
        buttonLayout.marginHeight = 0;
        Composite buttonComposite = new Composite((Composite)this, 0);
        buttonComposite.setLayout((Layout)buttonLayout);
        buttonComposite.setLayoutData((Object)new GridData(4, 4, false, true));
        buttonComposite.setBounds(0, 0, 64, 64);
        this.newAgentButton = new Button(buttonComposite, 0);
        this.newAgentButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.newAgentButton.setText(Messages.AgentManagerComposite_newAgent_button_text);
        this.newAgentButton.setToolTipText(Messages.AgentManagerComposite_newAgent_button_tooltip);
        this.newAgentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String path = AgentManagerComposite.this.openDirectoryDialog(Messages.AgentManagerComposite_newAgent_selectLocation, PropertiesUtil.getUserHome());
                if (path != null) {
                    Agent agent = P2Util.getAgentManager().addAgent(new File(path));
                    BundlePool bundlePool = agent.addBundlePool(new File(path, "pool"));
                    AgentManagerComposite.this.refreshFor(bundlePool);
                }
            }
        });
        this.clearButton = new Button(buttonComposite, 0);
        this.clearButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.clearButton.setText(Messages.AgentManagerComposite_clearCache_text);
        this.clearButton.setToolTipText(Messages.AgentManagerComposite_clearCache_tooltip);
        this.clearButton.setEnabled(false);
        this.clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final Agent agent = AgentManagerComposite.getAgent(AgentManagerComposite.this.selectedElement);
                if (agent != null) {
                    try {
                        UIUtil.runInProgressDialog((Shell)AgentManagerComposite.this.getShell(), (IRunnableWithProgress)new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                agent.clearRepositoryCaches(monitor);
                            }
                        });
                    }
                    catch (InvocationTargetException ex) {
                        ErrorDialog.open((Throwable)ex);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        });
        this.cleanupButton = new Button(buttonComposite, 0);
        this.cleanupButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.cleanupButton.setText(Messages.AgentManagerComposite_cleanupAgent_text);
        this.cleanupButton.setToolTipText(Messages.AgentManagerComposite_cleanupAgent_tooltip);
        this.cleanupButton.setEnabled(false);
        this.cleanupButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Agent agent = AgentManagerComposite.getAgent(AgentManagerComposite.this.selectedElement);
                if (agent != null) {
                    AgentManagerComposite.this.cleanup(agent);
                    AgentManagerComposite.this.treeViewer.refresh();
                }
            }
        });
        this.analyzeButton = new Button(buttonComposite, 0);
        this.analyzeButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.analyzeButton.setText(Messages.AgentManagerComposite_analyzeAgent_text);
        this.analyzeButton.setToolTipText(Messages.AgentManagerComposite_analyzeAgent_tooltip);
        this.analyzeButton.setEnabled(false);
        this.analyzeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Agent agent = AgentManagerComposite.getAgent(AgentManagerComposite.this.selectedElement);
                if (agent != null) {
                    AgentManagerComposite.this.analyze(agent);
                    AgentManagerComposite.this.treeViewer.refresh();
                }
            }
        });
        this.newPoolButton = new Button(buttonComposite, 0);
        this.newPoolButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.newPoolButton.setText(Messages.AgentManagerComposite_newPool_button_text);
        this.newPoolButton.setToolTipText(Messages.AgentManagerComposite_newPool_button_tooltip);
        this.newPoolButton.setEnabled(false);
        this.newPoolButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Agent selectedAgent = (Agent)AgentManagerComposite.this.selectedElement;
                String path = AgentManagerComposite.this.openDirectoryDialog(Messages.AgentManagerComposite_newPool_selectLocation, selectedAgent.getLocation().getAbsolutePath());
                if (path != null) {
                    BundlePool bundlePool = selectedAgent.addBundlePool(new File(path));
                    AgentManagerComposite.this.refreshFor(bundlePool);
                }
            }
        });
        if (poolSelection) {
            this.selectPoolButton = new Button(buttonComposite, 0);
            this.selectPoolButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.selectPoolButton.setText(Messages.AgentManagerComposite_selectPool_text);
            this.selectPoolButton.setToolTipText(Messages.AgentManagerComposite_selectPool_tooltip);
            this.selectPoolButton.setEnabled(false);
            this.selectPoolButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AgentManagerComposite.this.selectedPool = (BundlePool)((IStructuredSelection)AgentManagerComposite.this.treeViewer.getSelection()).getFirstElement();
                    AgentManagerComposite.this.elementChanged(AgentManagerComposite.this.selectedPool);
                    AgentManagerComposite.this.treeViewer.refresh();
                }
            });
        }
        this.deleteButton = new Button(buttonComposite, 0);
        this.deleteButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.deleteButton.setText(Messages.AgentManagerComposite_delete_text);
        this.deleteButton.setToolTipText(Messages.AgentManagerComposite_delete_tooltip);
        this.deleteButton.setEnabled(false);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AgentManagerComposite.this.deletePressed();
            }
        });
        this.refreshButton = new Button(buttonComposite, 0);
        this.refreshButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.refreshButton.setText(Messages.AgentManagerComposite_refresh_text);
        this.refreshButton.setToolTipText(Messages.AgentManagerComposite_refresh_tooltip);
        this.refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ProgressMonitorDialog dialog = new ProgressMonitorDialog(AgentManagerComposite.this.getShell());
                    dialog.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            P2Util.getAgentManager().refreshAgents(monitor);
                        }
                    });
                }
                catch (InvocationTargetException ex) {
                    P2UIPlugin.INSTANCE.log(ex);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                AgentManagerComposite.this.treeViewer.refresh();
            }
        });
        new Label(buttonComposite, 0);
        this.showProfilesButton = new Button(buttonComposite, 32);
        this.showProfilesButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.showProfilesButton.setText(Messages.AgentManagerComposite_showProfiles_text);
        this.showProfilesButton.setToolTipText(Messages.AgentManagerComposite_showProfiles_tooltip);
        this.showProfilesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean showProfiles = AgentManagerComposite.this.showProfilesButton.getSelection();
                PREF_SHOW_PROFILES.set(showProfiles);
                AgentManagerComposite.this.profileDetailsButton.setVisible(showProfiles);
                contentProvider.setShowProfiles(showProfiles);
                AgentManagerComposite.this.treeViewer.refresh();
                if (AgentManagerComposite.this.selectedElement instanceof BundlePool) {
                    AgentManagerComposite.this.treeViewer.setExpandedState(AgentManagerComposite.this.selectedElement, true);
                }
                AgentManagerComposite.this.profilesShown(showProfiles);
            }
        });
        this.profileDetailsButton = new Button(buttonComposite, 0);
        this.profileDetailsButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.profileDetailsButton.setText(Messages.AgentManagerComposite_profileDetails_text);
        this.profileDetailsButton.setToolTipText(Messages.AgentManagerComposite_profilesDetails_tooltip);
        this.profileDetailsButton.setVisible(false);
        this.profileDetailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AgentManagerComposite.this.showProfileDetails();
            }
        });
        if (PREF_SHOW_PROFILES.get(false)) {
            this.showProfilesButton.setSelection(true);
            this.profileDetailsButton.setVisible(true);
            contentProvider.setShowProfiles(true);
            this.profilesShown(true);
        }
        UIUtil.asyncExec((Runnable)new Runnable(){

            public void run() {
                final AgentManager agentManager = P2Util.getAgentManager();
                BusyIndicator.showWhile((Display)AgentManagerComposite.this.getShell().getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        AgentManagerComposite.this.treeViewer.setInput((Object)agentManager);
                        AgentManagerComposite.this.treeViewer.expandAll();
                    }
                });
                if (selection == null) {
                    Collection agents;
                    if (AgentManagerComposite.this.treeViewer.getTree().isEnabled() && !(agents = agentManager.getAgents()).isEmpty()) {
                        AgentManagerComposite.this.treeViewer.setSelection((ISelection)new StructuredSelection(agents.iterator().next()));
                    }
                } else {
                    AgentManagerComposite.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)selection));
                }
            }
        });
    }

    public boolean setFocus() {
        return this.treeViewer.getTree().setFocus();
    }

    public BundlePool getSelectedBundlePool() {
        return this.selectedPool;
    }

    public void setEnabled(boolean enabled) {
        this.treeViewer.getTree().setEnabled(enabled);
        this.refreshButton.setEnabled(enabled);
        this.newAgentButton.setEnabled(enabled);
        this.showProfilesButton.setEnabled(enabled);
        this.selectedElement = enabled ? ((IStructuredSelection)this.treeViewer.getSelection()).getFirstElement() : null;
        this.elementChanged(this.selectedElement);
        super.setEnabled(enabled);
    }

    private void deletePressed() {
        AgentManagerElementImpl agentManagerElement = (AgentManagerElementImpl)this.selectedElement;
        String message = this.getDeleteConfirmationMessage(agentManagerElement);
        if (MessageDialog.openQuestion((Shell)this.getShell(), (String)AgentManagerDialog.TITLE, (String)message)) {
            try {
                ITreeContentProvider contentProvider;
                Object parent;
                Object newSelection = null;
                IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
                Object element = selection.getFirstElement();
                if (element != null && (parent = (contentProvider = (ITreeContentProvider)this.treeViewer.getContentProvider()).getParent(element)) != null) {
                    newSelection = parent;
                    Object[] elements = contentProvider.getChildren(parent);
                    this.treeViewer.getComparator().sort((Viewer)this.treeViewer, elements);
                    List<Object> children = Arrays.asList(elements);
                    int index = children.indexOf(element);
                    if (index != -1) {
                        if (index + 1 < children.size()) {
                            newSelection = children.get(index + 1);
                        } else if (index > 0) {
                            newSelection = children.get(index - 1);
                        }
                    }
                }
                agentManagerElement.delete();
                this.treeViewer.refresh();
                if (newSelection != null) {
                    this.treeViewer.setSelection((ISelection)new StructuredSelection(newSelection));
                }
            }
            catch (Exception ex) {
                P2UIPlugin.INSTANCE.log(ex);
            }
        }
    }

    private String getDeleteConfirmationMessage(AgentManagerElementImpl agentManagerElement) {
        if (agentManagerElement instanceof Agent) {
            return String.valueOf(NLS.bind((String)Messages.AgentManagerComposite_deleteAgent_confirmation, (Object)agentManagerElement)) + "\n\n" + Messages.AgentManagerComposite_deleteAgent_filesWillRemainOnDisk;
        }
        if (agentManagerElement instanceof BundlePool) {
            return String.valueOf(NLS.bind((String)Messages.AgentManagerComposite_deleteBundlePool_confirmation, (Object)agentManagerElement)) + "\n\n" + Messages.AgentManagerComposite_deleteBundlePool_filesWillRemainOnDisk;
        }
        return NLS.bind((String)Messages.AgentManagerComposite_deleteProfile_confirmation, (Object)agentManagerElement);
    }

    private void cleanup(final Agent agent) {
        String title = Messages.AgentManagerComposite_cleanup_title;
        final AgentAnalyzer[] analyzer = new AgentAnalyzer[1];
        try {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
            dialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.AgentManagerComposite_cleanup_analyzing, (int)100).detectCancelation();
                    analyzer[0] = new AgentAnalyzer(agent, false, null, (IProgressMonitor)progress.newChild(90));
                    analyzer[0].awaitAnalyzing((IProgressMonitor)progress.newChild(10));
                }
            });
        }
        catch (Exception ex) {
            ErrorDialog.open((Throwable)ex);
            return;
        }
        final IdentityHashMap<AgentAnalyzer.AnalyzedProfile, AgentAnalyzer.AnalyzedProfile> unusedProfiles = new IdentityHashMap<AgentAnalyzer.AnalyzedProfile, AgentAnalyzer.AnalyzedProfile>();
        final IdentityHashMap<AgentAnalyzer.AnalyzedProfile, AgentAnalyzer.AnalyzedProfile> unusedArtifacts = new IdentityHashMap<AgentAnalyzer.AnalyzedProfile, AgentAnalyzer.AnalyzedProfile>();
        for (AgentAnalyzer.AnalyzedBundlePool bundlePool : analyzer[0].getBundlePools().values()) {
            AgentAnalyzer.AnalyzedProfile[] analyzedProfileArray = bundlePool.getUnusedProfiles();
            int n = analyzedProfileArray.length;
            int n2 = 0;
            while (n2 < n) {
                AgentAnalyzer.AnalyzedProfile profile = analyzedProfileArray[n2];
                unusedProfiles.put(profile, profile);
                ++n2;
            }
            analyzedProfileArray = bundlePool.getArtifacts();
            n = analyzedProfileArray.length;
            n2 = 0;
            while (n2 < n) {
                AgentAnalyzer.AnalyzedProfile artifact = analyzedProfileArray[n2];
                if (AgentManagerComposite.isUnused((AgentAnalyzer.AnalyzedArtifact)artifact, unusedProfiles)) {
                    unusedArtifacts.put(artifact, artifact);
                }
                ++n2;
            }
        }
        if (unusedProfiles.isEmpty() && unusedArtifacts.isEmpty()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)Messages.AgentManagerComposite_cleanup_nothingToCleanUp);
            return;
        }
        final boolean showProfiles = this.showProfilesButton.getSelection();
        final int profiles = unusedProfiles.size();
        final int artifacts = unusedArtifacts.size();
        String message = this.getCleanupConfirmationMessage(profiles, artifacts);
        if (artifacts != 0) {
            message = String.valueOf(message) + "\n\n" + Messages.AgentManagerComposite_cleanup_deleteConfirm_artifactDeleteNote;
        }
        if (MessageDialog.openQuestion((Shell)this.getShell(), (String)title, (String)message)) {
            try {
                UIUtil.runInProgressDialog((Shell)this.getShell(), (IRunnableWithProgress)new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.AgentManagerComposite_cleanup_deleting, (int)(profiles + artifacts)).detectCancelation();
                        if (profiles != 0) {
                            progress.setTaskName(Messages.AgentManagerComposite_cleanup_deletingUnusedProfiles);
                            for (AgentAnalyzer.AnalyzedProfile profile : unusedProfiles.keySet()) {
                                profile.delete((IProgressMonitor)progress.newChild());
                                if (!showProfiles) continue;
                                UIUtil.syncExec((Runnable)new Runnable(){

                                    public void run() {
                                        AgentManagerComposite.this.treeViewer.refresh();
                                    }
                                });
                            }
                        }
                        if (artifacts != 0) {
                            progress.setTaskName(Messages.AgentManagerComposite_cleanup_deletingUnusedArtifacts);
                            for (AgentAnalyzer.AnalyzedArtifact artifact : unusedArtifacts.keySet()) {
                                artifact.delete((IProgressMonitor)progress.newChild());
                            }
                        }
                    }
                });
            }
            catch (InvocationTargetException ex) {
                ErrorDialog.open((Throwable)ex);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private String getCleanupConfirmationMessage(int profiles, int artifacts) {
        switch (artifacts) {
            case 0: {
                switch (profiles) {
                    case 0: {
                        return "";
                    }
                    case 1: {
                        return Messages.AgentManagerComposite_cleanup_deleteConfirm_profile;
                    }
                }
                return NLS.bind((String)Messages.AgentManagerComposite_cleanup_deleteConfirm_profiles, (Object)profiles);
            }
            case 1: {
                switch (profiles) {
                    case 0: {
                        return Messages.AgentManagerComposite_cleanup_deleteConfirm_artifact;
                    }
                    case 1: {
                        return Messages.AgentManagerComposite_cleanup_deleteConfirm_profileAndArtifact;
                    }
                }
                return NLS.bind((String)Messages.AgentManagerComposite_cleanup_deleteConfirm_profilesAndArtifact, (Object)profiles);
            }
        }
        switch (profiles) {
            case 0: {
                return NLS.bind((String)Messages.AgentManagerComposite_cleanup_deleteConfirm_artifacts, (Object)artifacts);
            }
            case 1: {
                return NLS.bind((String)Messages.AgentManagerComposite_cleanup_deleteConfirm_profileAndArtifacts, (Object)artifacts);
            }
        }
        return NLS.bind((String)Messages.AgentManagerComposite_cleanup_deleteConfirm_profilesAndArtifacts, (Object)profiles, (Object)artifacts);
    }

    private void analyze(Agent agent) {
        AgentAnalyzerDialog dialog = new AgentAnalyzerDialog(this.getShell(), agent);
        dialog.open();
    }

    protected void elementChanged(Object element) {
        Agent agent;
        this.newPoolButton.setEnabled(element instanceof Agent);
        this.deleteButton.setEnabled(element instanceof AgentManagerElement && !((AgentManagerElement)element).isUsed());
        if (this.selectPoolButton != null) {
            this.selectPoolButton.setEnabled(element instanceof BundlePool);
        }
        this.cleanupButton.setEnabled((agent = AgentManagerComposite.getAgent(element)) != null);
        this.clearButton.setEnabled(agent != null);
        this.analyzeButton.setEnabled(agent != null);
        this.profileDetailsButton.setEnabled(element instanceof Profile);
    }

    protected void profilesShown(boolean profilesShown) {
    }

    private void showProfileDetails() {
        ProfileDetailsDialog dialog = new ProfileDetailsDialog(this.getShell(), (Profile)this.selectedElement);
        dialog.open();
    }

    private String openDirectoryDialog(String message, String path) {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setText(AgentManagerDialog.TITLE);
        dialog.setMessage(message);
        dialog.setFilterPath(path);
        return dialog.open();
    }

    private void refreshFor(BundlePool bundlePool) {
        this.treeViewer.refresh();
        this.treeViewer.setExpandedState((Object)bundlePool.getAgent(), true);
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)bundlePool));
        this.treeViewer.getTree().setFocus();
    }

    private static Agent getAgent(Object element) {
        if (element instanceof Profile) {
            Profile profile = (Profile)element;
            return profile.getAgent();
        }
        if (element instanceof BundlePool) {
            BundlePool bundlePool = (BundlePool)element;
            return bundlePool.getAgent();
        }
        if (element instanceof Agent) {
            return (Agent)element;
        }
        return null;
    }

    private static boolean isUnused(AgentAnalyzer.AnalyzedArtifact artifact, Map<AgentAnalyzer.AnalyzedProfile, AgentAnalyzer.AnalyzedProfile> unusedProfiles) {
        for (AgentAnalyzer.AnalyzedProfile profile : artifact.getProfiles()) {
            if (unusedProfiles.containsKey(profile)) continue;
            return false;
        }
        return true;
    }

    static void addDragSupport(StructuredViewer viewer) {
        viewer.addDragSupport(7, DND_TRANSFERS, (DragSourceListener)new GeneralDragAdapter((Viewer)viewer, new GeneralDragAdapter.DraggedObjectsFactory(){

            public List<Object> createDraggedObjects(ISelection selection) throws Exception {
                ArrayList<Object> result = new ArrayList<Object>();
                Object[] objectArray = ((IStructuredSelection)selection).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    AgentAnalyzer.AnalyzedProfile analyzedProfile;
                    Object object = objectArray[n2];
                    if (object instanceof AgentAnalyzer.AnalyzedProfile) {
                        analyzedProfile = (AgentAnalyzer.AnalyzedProfile)object;
                        object = analyzedProfile.getP2Profile();
                    }
                    if (object instanceof Profile) {
                        Profile profile = (Profile)object;
                        File location = profile.getLocation();
                        if (location != null) {
                            result.add(P2Factory.eINSTANCE.createRepository(URI.createFileURI((String)location.toString()).toString()));
                        }
                    } else if (object instanceof AgentAnalyzer.AnalyzedProfile) {
                        analyzedProfile = (AgentAnalyzer.AnalyzedProfile)object;
                        analyzedProfile.getP2Profile();
                    } else if (object instanceof AgentAnalyzer.AnalyzedArtifact) {
                        AgentAnalyzer.AnalyzedArtifact analyzedArtifact = (AgentAnalyzer.AnalyzedArtifact)object;
                        String id = analyzedArtifact.getID();
                        String version = analyzedArtifact.getVersion();
                        result.add(P2Factory.eINSTANCE.createRequirement(id, new VersionRange(version)));
                    } else if (object instanceof EObject) {
                        result.add(object);
                    }
                    ++n2;
                }
                return result;
            }
        }, DND_DELEGATES));
    }
}

