/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.internal.quickaccess.QuickAccessElement;

public abstract class QuickAccessProvider {
    private QuickAccessElement[] sortedElements;

    public abstract String getId();

    public abstract String getName();

    public abstract ImageDescriptor getImageDescriptor();

    public abstract QuickAccessElement[] getElements();

    public QuickAccessElement[] getElementsSorted() {
        if (this.sortedElements == null) {
            this.sortedElements = this.getElements();
            Arrays.sort(this.sortedElements, new Comparator<QuickAccessElement>(){

                @Override
                public int compare(QuickAccessElement e1, QuickAccessElement e2) {
                    return e1.getSortLabel().compareTo(e2.getSortLabel());
                }
            });
        }
        return this.sortedElements;
    }

    public abstract QuickAccessElement getElementForId(String var1);

    public boolean isAlwaysPresent() {
        return false;
    }

    public void reset() {
        this.sortedElements = null;
        this.doReset();
    }

    protected abstract void doReset();
}

