/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.internal.provisional.action.IToolBarContributionItem;
import org.eclipse.jface.internal.provisional.action.ToolBarContributionItem2;
import org.eclipse.jface.internal.provisional.action.ToolBarManager2;
import org.eclipse.jface.window.Window;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.internal.StartupThreading;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.provisional.application.IActionBarConfigurer2;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.presentations.AbstractPresentationFactory;

public final class WorkbenchWindowConfigurer
implements IWorkbenchWindowConfigurer {
    private WorkbenchWindow window;
    private int shellStyle = 0x4F0 | Window.getDefaultOrientation();
    private String windowTitle;
    private boolean showFastViewBars = false;
    private boolean showPerspectiveBar = false;
    private boolean showStatusLine = true;
    private boolean showToolBar = true;
    private boolean showMenuBar = true;
    private boolean showProgressIndicator = false;
    private Map extraData = new HashMap(1);
    private ArrayList transferTypes = new ArrayList(3);
    private DropTargetListener dropTargetListener = null;
    private WindowActionBarConfigurer actionBarConfigurer = null;
    private Point initialSize = new Point(1024, 768);
    private AbstractPresentationFactory presentationFactory = null;

    WorkbenchWindowConfigurer(WorkbenchWindow window) {
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.window = window;
        this.windowTitle = WorkbenchPlugin.getDefault().getProductName();
        if (this.windowTitle == null) {
            this.windowTitle = "";
        }
    }

    @Override
    public IWorkbenchWindow getWindow() {
        return this.window;
    }

    @Override
    public IWorkbenchConfigurer getWorkbenchConfigurer() {
        return Workbench.getInstance().getWorkbenchConfigurer();
    }

    String basicGetTitle() {
        return this.windowTitle;
    }

    @Override
    public String getTitle() {
        Shell shell = this.window.getShell();
        if (shell != null) {
            this.windowTitle = shell.getText();
        }
        return this.windowTitle;
    }

    @Override
    public void setTitle(String title) {
        if (title == null) {
            throw new IllegalArgumentException();
        }
        this.windowTitle = title;
        Shell shell = this.window.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.setText(TextProcessor.process((String)title, (String)WorkbenchWindow.TEXT_DELIMITERS));
        }
    }

    @Override
    public boolean getShowMenuBar() {
        return this.showMenuBar;
    }

    @Override
    public void setShowMenuBar(boolean show) {
        this.showMenuBar = show;
        WorkbenchWindow win = (WorkbenchWindow)this.getWindow();
        Shell shell = win.getShell();
        if (shell != null) {
            boolean showing;
            boolean bl = showing = shell.getMenuBar() != null;
            if (show != showing) {
                if (show) {
                    shell.setMenuBar(null);
                } else {
                    shell.setMenuBar(null);
                }
            }
        }
    }

    @Override
    public boolean getShowCoolBar() {
        return this.showToolBar;
    }

    @Override
    public void setShowCoolBar(boolean show) {
        this.showToolBar = show;
    }

    @Override
    public boolean getShowFastViewBars() {
        return this.showFastViewBars;
    }

    @Override
    public void setShowFastViewBars(boolean show) {
        this.showFastViewBars = show;
        this.window.setFastViewBarVisible(show);
    }

    @Override
    public boolean getShowPerspectiveBar() {
        return this.showPerspectiveBar;
    }

    @Override
    public void setShowPerspectiveBar(boolean show) {
        this.showPerspectiveBar = show;
    }

    @Override
    public boolean getShowStatusLine() {
        return this.showStatusLine;
    }

    @Override
    public void setShowStatusLine(boolean show) {
        this.showStatusLine = show;
        this.window.setStatusLineVisible(show);
    }

    @Override
    public boolean getShowProgressIndicator() {
        return this.showProgressIndicator;
    }

    @Override
    public void setShowProgressIndicator(boolean show) {
        this.showProgressIndicator = show;
    }

    @Override
    public Object getData(String key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        return this.extraData.get(key);
    }

    @Override
    public void setData(String key, Object data) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (data != null) {
            this.extraData.put(key, data);
        } else {
            this.extraData.remove(key);
        }
    }

    @Override
    public void addEditorAreaTransfer(Transfer tranfer) {
        if (tranfer != null && !this.transferTypes.contains(tranfer)) {
            this.transferTypes.add(tranfer);
        }
    }

    @Override
    public void configureEditorAreaDropListener(DropTargetListener dropTargetListener) {
        this.dropTargetListener = dropTargetListener;
    }

    Transfer[] getTransfers() {
        Transfer[] transfers = new Transfer[this.transferTypes.size()];
        this.transferTypes.toArray(transfers);
        return transfers;
    }

    DropTargetListener getDropTargetListener() {
        return this.dropTargetListener;
    }

    @Override
    public IActionBarConfigurer getActionBarConfigurer() {
        if (this.actionBarConfigurer == null) {
            this.actionBarConfigurer = new WindowActionBarConfigurer();
        }
        return this.actionBarConfigurer;
    }

    boolean containsCoolItem(String id) {
        this.getActionBarConfigurer();
        return this.actionBarConfigurer.containsCoolItem(id);
    }

    @Override
    public int getShellStyle() {
        return this.shellStyle;
    }

    @Override
    public void setShellStyle(int shellStyle) {
        this.shellStyle = shellStyle;
    }

    @Override
    public Point getInitialSize() {
        return this.initialSize;
    }

    @Override
    public void setInitialSize(Point size) {
        this.initialSize = size;
    }

    @Override
    public AbstractPresentationFactory getPresentationFactory() {
        if (this.presentationFactory == null) {
            this.presentationFactory = this.createDefaultPresentationFactory();
        }
        return this.presentationFactory;
    }

    private AbstractPresentationFactory createDefaultPresentationFactory() {
        final String factoryId = ((Workbench)this.window.getWorkbench()).getPresentationId();
        if (factoryId != null && factoryId.length() > 0) {
            final AbstractPresentationFactory[] factory = new AbstractPresentationFactory[1];
            StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                @Override
                public void runWithException() throws Throwable {
                    factory[0] = WorkbenchPlugin.getDefault().getPresentationFactory(factoryId);
                }
            });
            if (factory[0] != null) {
                return factory[0];
            }
        }
        PrefUtil.getAPIPreferenceStore().setValue("presentationFactoryId", "org.eclipse.ui.presentations.default");
        return null;
    }

    @Override
    public void setPresentationFactory(AbstractPresentationFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException();
        }
        this.presentationFactory = factory;
    }

    public void createDefaultContents(Shell shell) {
    }

    @Override
    public Menu createMenuBar() {
        return null;
    }

    @Override
    public Control createCoolBarControl(Composite parent) {
        return null;
    }

    @Override
    public Control createStatusLineControl(Composite parent) {
        return null;
    }

    @Override
    public Control createPageComposite(Composite parent) {
        return null;
    }

    @Override
    public IStatus saveState(IMemento memento) {
        return null;
    }

    class WindowActionBarConfigurer
    implements IActionBarConfigurer2 {
        private IActionBarConfigurer2 proxy;

        WindowActionBarConfigurer() {
        }

        public void setProxy(IActionBarConfigurer2 proxy) {
            this.proxy = proxy;
        }

        @Override
        public IWorkbenchWindowConfigurer getWindowConfigurer() {
            return WorkbenchWindowConfigurer.this.window.getWindowConfigurer();
        }

        boolean containsCoolItem(String id) {
            ICoolBarManager cbManager = this.getCoolBarManager();
            if (cbManager == null) {
                return false;
            }
            IContributionItem cbItem = cbManager.find(id);
            return cbItem != null;
        }

        @Override
        public IStatusLineManager getStatusLineManager() {
            if (this.proxy != null) {
                return this.proxy.getStatusLineManager();
            }
            return WorkbenchWindowConfigurer.this.window.getStatusLineManager();
        }

        @Override
        public IMenuManager getMenuManager() {
            if (this.proxy != null) {
                return this.proxy.getMenuManager();
            }
            return WorkbenchWindowConfigurer.this.window.getMenuManager();
        }

        @Override
        public ICoolBarManager getCoolBarManager() {
            if (this.proxy != null) {
                return this.proxy.getCoolBarManager();
            }
            return WorkbenchWindowConfigurer.this.window.getCoolBarManager2();
        }

        @Override
        public void registerGlobalAction(IAction action) {
            if (this.proxy != null) {
                this.proxy.registerGlobalAction(action);
            }
            WorkbenchWindowConfigurer.this.window.registerGlobalAction(action);
        }

        @Override
        public IToolBarManager createToolBarManager() {
            if (this.proxy != null) {
                return this.proxy.createToolBarManager();
            }
            return new ToolBarManager2(8519744);
        }

        @Override
        public IToolBarContributionItem createToolBarContributionItem(IToolBarManager toolBarManager, String id) {
            if (this.proxy != null) {
                return this.proxy.createToolBarContributionItem(toolBarManager, id);
            }
            return new ToolBarContributionItem2(toolBarManager, id);
        }
    }
}

