/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.presentation.templates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedFontRegistry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.BasePackage;
import org.eclipse.oomph.base.ModelElement;
import org.eclipse.oomph.setup.CompoundTask;
import org.eclipse.oomph.setup.Project;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.VariableChoice;
import org.eclipse.oomph.setup.VariableTask;
import org.eclipse.oomph.setup.editor.ProjectTemplate;
import org.eclipse.oomph.setup.ui.LabelDecorator;
import org.eclipse.oomph.setup.ui.PropertyField;
import org.eclipse.oomph.setup.util.StringExpander;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.CollectionUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericProjectTemplate
extends ProjectTemplate {
    private final URI templateLocation;
    private Composite composite;
    private Project eclipseProject;
    private Map<VariableTask, PropertyField> fields = new LinkedHashMap<VariableTask, PropertyField>();
    private Set<PropertyField> dirtyFields = new HashSet<PropertyField>();
    private Map<String, VariableTask> variables = new LinkedHashMap<String, VariableTask>();
    private Map<VariableTask, Set<EStructuralFeature.Setting>> usages;
    private PropertyField focusField;
    private Map<EObject, Set<EStructuralFeature>> focusUsages = new HashMap<EObject, Set<EStructuralFeature>>();
    private LabelDecorator decorator;

    public GenericProjectTemplate(String label, URI templateLocation) {
        super(label);
        this.templateLocation = templateLocation;
    }

    @Override
    public Control createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 10;
        this.composite.setLayout((Layout)layout);
        return this.composite;
    }

    @Override
    public boolean isValid() {
        for (PropertyField field : this.fields.values()) {
            if (!StringUtil.isEmpty((String)field.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public LabelDecorator getDecorator() {
        if (this.decorator == null) {
            this.decorator = new LabelDecorator(){

                public Font decorateFont(Font font, Object element) {
                    String name;
                    VariableTask focusVariable;
                    if (GenericProjectTemplate.this.focusUsages.containsKey(element)) {
                        return ExtendedFontRegistry.INSTANCE.getFont(font, (Object)IItemFontProvider.BOLD_FONT);
                    }
                    if (element instanceof EStructuralFeature.Setting) {
                        EStructuralFeature.Setting setting = (EStructuralFeature.Setting)element;
                        Set eStructuralFeatures = (Set)GenericProjectTemplate.this.focusUsages.get(setting.getEObject());
                        if (eStructuralFeatures != null && eStructuralFeatures.contains(setting.getEStructuralFeature())) {
                            return ExtendedFontRegistry.INSTANCE.getFont(font, (Object)IItemFontProvider.BOLD_FONT);
                        }
                    } else if (element instanceof Resource && (focusVariable = GenericProjectTemplate.this.getFocusVariable()) != null && ("project.location".equals(name = focusVariable.getName()) || "project.filename".equals(name))) {
                        return ExtendedFontRegistry.INSTANCE.getFont(font, (Object)IItemFontProvider.BOLD_FONT);
                    }
                    return super.decorateFont(font, element);
                }
            };
        }
        return this.decorator;
    }

    private VariableTask getFocusVariable() {
        for (Map.Entry<VariableTask, PropertyField> entry : this.fields.entrySet()) {
            if (entry.getValue() != this.focusField) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public void updatePreview() {
        VariableTask focusVariable = this.getFocusVariable();
        if (focusVariable != null) {
            this.updateSelection(focusVariable);
        }
    }

    protected void updateSelection(VariableTask variable) {
        TreeViewer previewer = this.getContainer().getPreviewer();
        if (previewer != null) {
            this.focusUsages.clear();
            Set<EStructuralFeature.Setting> settings = this.usages.get(variable);
            if (settings != null) {
                for (EStructuralFeature.Setting setting : settings) {
                    CollectionUtil.add(this.focusUsages, (Object)setting.getEObject(), (Object)setting.getEStructuralFeature());
                }
            }
            previewer.refresh(true);
            if (this.focusUsages.isEmpty()) {
                String name = variable.getName();
                if ("project.location".equals(name) || "project.filename".equals(name)) {
                    previewer.setSelection((ISelection)new StructuredSelection((Object)this.getResource()), true);
                }
            } else {
                previewer.setSelection((ISelection)new StructuredSelection(this.focusUsages.keySet().toArray()), true);
            }
        }
    }

    @Override
    protected void init() {
        super.init();
        Resource resource = this.getResource();
        ResourceSet resourceSet = resource.getResourceSet();
        this.eclipseProject = (Project)resourceSet.getEObject(this.templateLocation, true);
        final Font normalFont = this.composite.getFont();
        final Font boldFont = ExtendedFontRegistry.INSTANCE.getFont(normalFont, (Object)IItemFontProvider.BOLD_FONT);
        CompoundTask compoundTask = (CompoundTask)this.eclipseProject.eResource().getEObject("template.variables");
        Control firstControl = null;
        VariableTask firstVariable = null;
        for (SetupTask setupTask : compoundTask.getSetupTasks()) {
            final VariableTask variable = (VariableTask)setupTask;
            final PropertyField field = PropertyField.createField((VariableTask)variable);
            field.fill(this.composite);
            field.setValue(variable.getValue(), false);
            field.addValueListener(new PropertyField.ValueListener(){

                public void valueChanged(String oldValue, String newValue) throws Exception {
                    GenericProjectTemplate.this.dirtyFields.add(field);
                    GenericProjectTemplate.this.modelChanged(variable);
                }
            });
            field.getControl().addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    if (GenericProjectTemplate.this.focusField != null && GenericProjectTemplate.this.focusField != field) {
                        GenericProjectTemplate.this.focusField.getLabel().setFont(normalFont);
                    }
                    if (GenericProjectTemplate.this.focusField != field) {
                        GenericProjectTemplate.this.focusField = field;
                        field.getLabel().setFont(boldFont);
                        GenericProjectTemplate.this.updateSelection(variable);
                    }
                }
            });
            field.getLabel().setFont(boldFont);
            if (firstControl == null) {
                firstControl = field.getControl();
                firstVariable = variable;
            }
            this.variables.put(variable.getName(), variable);
            this.fields.put(variable, field);
            if (!"project.location".equals(variable.getName())) continue;
            field.setValue(this.getContainer().getDefaultLocation());
        }
        Composite parent = this.composite.getParent();
        int currentHeight = this.composite.getSize().y;
        int newHeight = this.composite.computeSize((int)-1, (int)-1, (boolean)true).y;
        GridData data = UIUtil.applyGridData((Control)parent);
        data.heightHint = newHeight;
        if (currentHeight < newHeight) {
            Shell shell = parent.getShell();
            Point size = shell.getSize();
            shell.setSize(size.x, size.y + newHeight - currentHeight);
        }
        parent.setRedraw(false);
        parent.pack();
        parent.getParent().layout();
        for (PropertyField field : this.fields.values()) {
            field.getLabel().setFont(normalFont);
        }
        parent.setRedraw(true);
        this.modelChanged(firstVariable);
        if (firstControl instanceof Text) {
            Text text = (Text)firstControl;
            text.selectAll();
        }
        firstControl.setFocus();
    }

    private void modelChanged(final VariableTask triggerVariable) {
        Project copy = (Project)EcoreUtil.copy((EObject)this.eclipseProject);
        HashSet<PropertyField> originalDirtyPropertyFields = new HashSet<PropertyField>(this.dirtyFields);
        for (VariableTask variable : this.variables.values()) {
            PropertyField propertyField = this.fields.get(variable);
            if (this.dirtyFields.contains(propertyField)) continue;
            String value = variable.getValue();
            if (!StringUtil.isEmpty((String)value)) {
                value = this.expandString(value, null);
                propertyField.setValue(value, false);
            }
            this.dirtyFields.add(propertyField);
        }
        this.usages = new HashMap<VariableTask, Set<EStructuralFeature.Setting>>();
        HashSet<Object> eObjectsToDelete = new HashSet<Object>();
        LinkedHashSet<Annotation> featureSubstitutions = new LinkedHashSet<Annotation>();
        TreeIterator treeIterator = EcoreUtil.getAllContents(Collections.singleton(copy));
        while (treeIterator.hasNext()) {
            CompoundTask compoundTask;
            InternalEObject eObject = (InternalEObject)treeIterator.next();
            for (EAttribute eAttribute : eObject.eClass().getEAllAttributes()) {
                String value;
                if (eAttribute.getEType().getInstanceClass() != String.class || eAttribute.isDerived() || eAttribute.isMany() || (value = (String)eObject.eGet((EStructuralFeature)eAttribute)) == null) continue;
                HashSet<VariableTask> usedVariables = new HashSet<VariableTask>();
                String replacement = this.expandString(value, usedVariables);
                CollectionUtil.addAll(this.usages, usedVariables, (Object)eObject.eSetting((EStructuralFeature)eAttribute));
                eObject.eSet((EStructuralFeature)eAttribute, (Object)replacement);
            }
            if (eObject instanceof Annotation) {
                Annotation annotation = (Annotation)eObject;
                if (!"http://www.eclipse.org/oomph/setup/FeatureSubstitution".equals(annotation.getSource())) continue;
                featureSubstitutions.add(annotation);
                eObjectsToDelete.add(annotation);
                continue;
            }
            if (!(eObject instanceof CompoundTask) || !"template.variables".equals((compoundTask = (CompoundTask)eObject).getID())) continue;
            eObjectsToDelete.add(compoundTask);
        }
        for (Annotation annotation : featureSubstitutions) {
            ModelElement modelElement = annotation.getModelElement();
            EClass eClass = modelElement.eClass();
            for (Map.Entry detail : annotation.getDetails()) {
                EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature((String)detail.getKey());
                if (!(eStructuralFeature instanceof EAttribute)) continue;
                try {
                    modelElement.eSet(eStructuralFeature, EcoreUtil.createFromString((EDataType)((EAttribute)eStructuralFeature).getEAttributeType(), (String)((String)detail.getValue())));
                    block7: for (Map.Entry<VariableTask, Set<EStructuralFeature.Setting>> entry : this.usages.entrySet()) {
                        Set<EStructuralFeature.Setting> settings = entry.getValue();
                        for (EStructuralFeature.Setting setting : settings) {
                            if (setting.getEObject() != detail || setting.getEStructuralFeature() != BasePackage.Literals.STRING_TO_STRING_MAP_ENTRY__VALUE) continue;
                            settings.add(((InternalEObject)modelElement).eSetting(eStructuralFeature));
                            continue block7;
                        }
                    }
                }
                catch (RuntimeException runtimeException) {}
            }
        }
        for (EObject eObject : eObjectsToDelete) {
            EcoreUtil.delete((EObject)eObject);
        }
        final Resource resource = this.getResource();
        final ArrayList<String> strings = new ArrayList<String>();
        final TreeViewer previewer = this.getContainer().getPreviewer();
        if (previewer != null) {
            Object[] objectArray = previewer.getExpandedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof EObject) {
                    EObject eObject = (EObject)object;
                    strings.add(resource.getURIFragment(eObject));
                }
                ++n2;
            }
            previewer.getControl().setRedraw(false);
            this.updateResource(copy);
            UIUtil.asyncExec((Runnable)new Runnable(){

                public void run() {
                    if (!previewer.getControl().isDisposed()) {
                        ArrayList<EObject> eObjects = new ArrayList<EObject>();
                        for (String fragment : strings) {
                            EObject eObject = resource.getEObject(fragment);
                            if (eObject == null) continue;
                            eObjects.add(eObject);
                        }
                        previewer.setExpandedElements(eObjects.toArray());
                        GenericProjectTemplate.this.updateSelection(triggerVariable);
                        previewer.getControl().setRedraw(true);
                    }
                }
            });
        } else {
            this.updateResource(copy);
        }
        this.dirtyFields = originalDirtyPropertyFields;
        this.getContainer().validate();
    }

    private void updateResource(Project project) {
        Resource resource = this.getResource();
        EList contents = resource.getContents();
        if (contents.isEmpty()) {
            contents.add((Object)project);
        } else {
            contents.set(0, (Object)project);
        }
        String location = this.expandString("${project.location}", null);
        String fileName = this.expandString("${project.filename}", null);
        resource.setURI(URI.createURI((String)("platform:/resource" + location + "/" + fileName)));
    }

    private String expandString(String string, Set<VariableTask> usedVariables) {
        if (string == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int previous = 0;
        Matcher matcher = StringExpander.STRING_EXPANSION_PATTERN.matcher(string);
        while (matcher.find()) {
            result.append(string.substring(previous, matcher.start()));
            String key = matcher.group(1);
            if ("$".equals(key)) {
                result.append('$');
            } else {
                key = matcher.group(2);
                String suffix = matcher.group(5);
                VariableTask variable = this.variables.get(key);
                if (variable == null) {
                    result.append(matcher.group());
                } else {
                    PropertyField field;
                    String value;
                    if (usedVariables != null) {
                        usedVariables.add(variable);
                    }
                    String string2 = value = this.dirtyFields.contains(field = this.fields.get(variable)) ? field.getValue() : variable.getValue();
                    if (StringUtil.isEmpty((String)value)) {
                        result.append(matcher.group());
                    } else {
                        String filters = matcher.group(4);
                        if (filters != null) {
                            String[] stringArray = filters.split("\\|");
                            int n = stringArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String filterName = stringArray[n2];
                                value = this.filter(variable, value, filterName);
                                ++n2;
                            }
                        }
                        result.append(value);
                        result.append(suffix);
                    }
                }
            }
            previous = matcher.end();
        }
        result.append(string.substring(previous));
        return result.toString();
    }

    private String filter(VariableTask variable, String value, String filter) {
        if (filter.equals("qualifiedName")) {
            return value.trim().replaceAll("[^\\p{Alnum}]+", ".").toLowerCase();
        }
        if (filter.equals("camel")) {
            Matcher matcher = Pattern.compile("(?:[^\\p{Alnum}]+|^)(\\p{Lower})?").matcher(value);
            StringBuffer result = new StringBuffer();
            while (matcher.find()) {
                String group = matcher.group(1);
                matcher.appendReplacement(result, group == null ? "" : group.toUpperCase());
            }
            matcher.appendTail(result);
            return result.toString();
        }
        if (filter.equals("label")) {
            for (VariableChoice choice : variable.getChoices()) {
                if (!value.equals(choice.getValue())) continue;
                return choice.getLabel();
            }
        }
        return value;
    }
}

