/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hover;

import org.eclipse.nebula.widgets.nattable.hover.command.ClearHoverStylingCommandHandler;
import org.eclipse.nebula.widgets.nattable.hover.command.HoverStylingByIndexCommandHandler;
import org.eclipse.nebula.widgets.nattable.hover.command.HoverStylingCommandHandler;
import org.eclipse.nebula.widgets.nattable.hover.config.BodyHoverStylingBindings;
import org.eclipse.nebula.widgets.nattable.layer.AbstractIndexLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.event.CellVisualUpdateEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.ColumnVisualUpdateEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowVisualUpdateEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.VisualRefreshEvent;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.swt.graphics.Point;

public class HoverLayer
extends AbstractIndexLayerTransform {
    private Point currentHoveredCellPosition;
    private boolean fireRowUpdates = false;
    private boolean fireColumnUpdates = false;

    public HoverLayer(IUniqueIndexLayer underlyingLayer) {
        this(underlyingLayer, true);
    }

    public HoverLayer(IUniqueIndexLayer underlyingLayer, boolean useDefaultConfiguration) {
        super(underlyingLayer);
        if (useDefaultConfiguration) {
            this.addConfiguration(new BodyHoverStylingBindings(this));
        }
        this.registerCommandHandler(new HoverStylingCommandHandler(this));
        this.registerCommandHandler(new HoverStylingByIndexCommandHandler(this));
        this.registerCommandHandler(new ClearHoverStylingCommandHandler(this));
    }

    @Override
    public DisplayMode getDisplayModeByPosition(int columnPosition, int rowPosition) {
        if (this.isCellPositionHovered(columnPosition, rowPosition)) {
            return DisplayMode.HOVER;
        }
        return super.getDisplayModeByPosition(columnPosition, rowPosition);
    }

    public boolean isCellPositionHovered(Point cellPosition) {
        return this.isCellPositionHovered(cellPosition.x, cellPosition.y);
    }

    public boolean isCellPositionHovered(int columnPosition, int rowPosition) {
        ILayerCell cell;
        if (this.currentHoveredCellPosition != null && (cell = this.getCellByPosition(columnPosition, rowPosition)) != null) {
            return this.currentHoveredCellPosition.x == cell.getOriginColumnPosition() && this.currentHoveredCellPosition.y == cell.getOriginRowPosition();
        }
        return false;
    }

    public boolean isRowPositionHovered(int rowPosition) {
        return this.currentHoveredCellPosition != null && this.currentHoveredCellPosition.y == rowPosition;
    }

    public boolean isColumnPositionHovered(int columnPosition) {
        return this.currentHoveredCellPosition != null && this.currentHoveredCellPosition.x == columnPosition;
    }

    public Point getCurrentHoveredCellPosition() {
        return this.currentHoveredCellPosition;
    }

    public void setCurrentHoveredCellPosition(int columnPosition, int rowPosition) {
        this.setCurrentHoveredCellPosition(new Point(columnPosition, rowPosition));
    }

    public void setCurrentHoveredCellByIndex(int columnIndex, int rowIndex) {
        int columnPosition = this.getColumnPositionByIndex(columnIndex);
        int rowPosition = this.getRowPositionByIndex(rowIndex);
        this.setCurrentHoveredCellPosition(new Point(columnPosition, rowPosition));
    }

    public void setCurrentHoveredCellPosition(Point cellPosition) {
        if (!this.isCellPositionHovered(cellPosition)) {
            Point oldHover = this.currentHoveredCellPosition;
            ILayerCell cell = this.getCellByPosition(cellPosition.x, cellPosition.y);
            if (cell != null) {
                this.currentHoveredCellPosition = new Point(cell.getOriginColumnPosition(), cell.getOriginRowPosition());
            }
            if (oldHover != null) {
                this.fireUpdateEvent(oldHover.x, oldHover.y);
            }
            this.fireUpdateEvent(this.currentHoveredCellPosition.x, this.currentHoveredCellPosition.y);
        }
    }

    public void clearCurrentHoveredCellPosition() {
        if (this.currentHoveredCellPosition != null) {
            Point oldHover = this.currentHoveredCellPosition;
            this.currentHoveredCellPosition = null;
            this.fireUpdateEvent(oldHover.x, oldHover.y);
        }
    }

    public void setFireRowUpdates(boolean fireRowUpdates) {
        this.fireRowUpdates = fireRowUpdates;
    }

    public boolean isFireRowUpdates() {
        return this.fireRowUpdates;
    }

    public void setFireColumnUpdates(boolean fireColumnUpdates) {
        this.fireColumnUpdates = fireColumnUpdates;
    }

    public boolean isFireColumnUpdates() {
        return this.fireColumnUpdates;
    }

    private void fireUpdateEvent(int x, int y) {
        if (this.fireRowUpdates && this.fireColumnUpdates) {
            this.fireLayerEvent(new VisualRefreshEvent(this));
        } else if (this.fireRowUpdates) {
            this.fireLayerEvent(new RowVisualUpdateEvent((ILayer)this, y));
        } else if (this.fireColumnUpdates) {
            this.fireLayerEvent(new ColumnVisualUpdateEvent((ILayer)this, x));
        } else {
            this.fireLayerEvent(new CellVisualUpdateEvent(this, x, y));
        }
    }
}

