/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.viewport.event;

import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEventHandler;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;

public class ViewportEventHandler
implements ILayerEventHandler<IStructuralChangeEvent> {
    private final ViewportLayer viewportLayer;

    public ViewportEventHandler(ViewportLayer viewportLayer) {
        this.viewportLayer = viewportLayer;
    }

    @Override
    public Class<IStructuralChangeEvent> getLayerEventClass() {
        return IStructuralChangeEvent.class;
    }

    @Override
    public void handleLayerEvent(IStructuralChangeEvent event) {
        Range beforePositionRange;
        int i;
        Range afterPositionRange;
        StructuralDiff.DiffTypeEnum diffType;
        IUniqueIndexLayer scrollableLayer = this.viewportLayer.getScrollableLayer();
        if (event.isHorizontalStructureChanged()) {
            int startX;
            this.viewportLayer.invalidateHorizontalStructure();
            int columnOffset = 0;
            int minimumOriginColumnPosition = this.viewportLayer.getMinimumOriginColumnPosition();
            Collection<StructuralDiff> columnDiffs = event.getColumnDiffs();
            if (columnDiffs != null) {
                if (minimumOriginColumnPosition < 0) {
                    minimumOriginColumnPosition = scrollableLayer.getColumnPositionByX(this.viewportLayer.getMinimumOrigin().getX());
                }
                for (StructuralDiff columnDiff : columnDiffs) {
                    diffType = columnDiff.getDiffType();
                    if (diffType == StructuralDiff.DiffTypeEnum.ADD) {
                        afterPositionRange = columnDiff.getAfterPositionRange();
                        if (minimumOriginColumnPosition <= 0) continue;
                        i = afterPositionRange.start;
                        while (i < afterPositionRange.end) {
                            if (i < minimumOriginColumnPosition) {
                                ++minimumOriginColumnPosition;
                            }
                            ++i;
                        }
                        continue;
                    }
                    if (diffType != StructuralDiff.DiffTypeEnum.DELETE) continue;
                    beforePositionRange = columnDiff.getBeforePositionRange();
                    if (minimumOriginColumnPosition <= 0) continue;
                    i = beforePositionRange.start;
                    while (i < beforePositionRange.end) {
                        if (i < minimumOriginColumnPosition) {
                            --columnOffset;
                        }
                        ++i;
                    }
                }
            }
            int minimumOriginColumn = minimumOriginColumnPosition + columnOffset;
            if (this.viewportLayer.getMinColumnPosition() >= 0) {
                minimumOriginColumn = this.viewportLayer.getMinColumnPosition();
            }
            if ((startX = scrollableLayer.getStartXOfColumnPosition(minimumOriginColumn)) < 0 && minimumOriginColumnPosition > 0) {
                int columnCount = scrollableLayer.getColumnCount();
                startX = columnCount == 0 ? 0 : scrollableLayer.getStartXOfColumnPosition(columnCount - 1) + scrollableLayer.getColumnWidthByPosition(columnCount - 1);
            }
            this.viewportLayer.setMinimumOriginX(startX);
        }
        if (event.isVerticalStructureChanged()) {
            int startY;
            this.viewportLayer.invalidateVerticalStructure();
            int rowOffset = 0;
            int minimumOriginRowPosition = this.viewportLayer.getMinimumOriginRowPosition();
            Collection<StructuralDiff> rowDiffs = event.getRowDiffs();
            if (rowDiffs != null) {
                if (minimumOriginRowPosition < 0) {
                    minimumOriginRowPosition = scrollableLayer.getRowPositionByY(this.viewportLayer.getMinimumOrigin().getY());
                }
                for (StructuralDiff rowDiff : rowDiffs) {
                    diffType = rowDiff.getDiffType();
                    if (diffType == StructuralDiff.DiffTypeEnum.ADD) {
                        afterPositionRange = rowDiff.getAfterPositionRange();
                        if (minimumOriginRowPosition <= 0) continue;
                        i = afterPositionRange.start;
                        while (i < afterPositionRange.end) {
                            if (i < minimumOriginRowPosition) {
                                ++minimumOriginRowPosition;
                            }
                            ++i;
                        }
                        continue;
                    }
                    if (diffType != StructuralDiff.DiffTypeEnum.DELETE) continue;
                    beforePositionRange = rowDiff.getBeforePositionRange();
                    if (minimumOriginRowPosition <= 0) continue;
                    i = beforePositionRange.start;
                    while (i < beforePositionRange.end) {
                        if (i < minimumOriginRowPosition) {
                            --rowOffset;
                        }
                        ++i;
                    }
                }
            }
            int minimumOriginRow = minimumOriginRowPosition + rowOffset;
            if (this.viewportLayer.getMinRowPosition() >= 0) {
                minimumOriginRow = this.viewportLayer.getMinRowPosition();
            }
            if ((startY = scrollableLayer.getStartYOfRowPosition(minimumOriginRow)) < 0 && minimumOriginRowPosition > 0) {
                int rowCount = scrollableLayer.getRowCount();
                startY = rowCount == 0 ? 0 : scrollableLayer.getStartYOfRowPosition(rowCount - 1) + scrollableLayer.getRowHeightByPosition(rowCount - 1);
            }
            this.viewportLayer.setMinimumOriginY(startY);
        }
    }
}

