/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.nio;

import ca.odell.glazedlists.impl.nio.BlockingRunnable;
import ca.odell.glazedlists.impl.nio.NIOServer;
import ca.odell.glazedlists.impl.nio.SelectAndHandle;
import ca.odell.glazedlists.impl.nio.Shutdown;
import java.io.IOException;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class NIODaemon
implements Runnable {
    private static Logger logger = Logger.getLogger(NIODaemon.class.toString());
    private List pendingRunnables = new ArrayList();
    private Thread ioThread = null;
    private Selector selector;
    private boolean keepRunning = false;
    private NIOServer server = null;

    public synchronized void start() throws IOException {
        if (this.ioThread != null) {
            throw new IllegalStateException();
        }
        this.selector = Selector.open();
        this.keepRunning = true;
        this.ioThread = new Thread((Runnable)this, "GlazedLists nio");
        this.ioThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        NIODaemon nIODaemon;
        ArrayList<SelectAndHandle> toExecute = new ArrayList<SelectAndHandle>();
        SelectAndHandle selectAndHandle = new SelectAndHandle(this);
        while (this.keepRunning) {
            nIODaemon = this;
            synchronized (nIODaemon) {
                toExecute.addAll(this.pendingRunnables);
                toExecute.add(selectAndHandle);
                this.pendingRunnables.clear();
            }
            Iterator i = toExecute.iterator();
            while (this.keepRunning && i.hasNext()) {
                Runnable runnable = (Runnable)i.next();
                i.remove();
                try {
                    runnable.run();
                }
                catch (RuntimeException e) {
                    logger.log(Level.SEVERE, "Failure processing I/O, continuing", e);
                }
            }
        }
        nIODaemon = this;
        synchronized (nIODaemon) {
            this.pendingRunnables.clear();
            this.selector = null;
            this.ioThread = null;
            this.keepRunning = false;
        }
    }

    public synchronized boolean isRunning() {
        return this.ioThread != null;
    }

    public synchronized boolean isNetworkThread() {
        return Thread.currentThread() == this.ioThread;
    }

    private void wakeUp() {
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAndWait(Runnable runnable) {
        if (!this.isRunning()) {
            throw new IllegalStateException();
        }
        if (this.isNetworkThread()) {
            runnable.run();
        } else {
            BlockingRunnable blockingRunnable;
            BlockingRunnable blockingRunnable2 = blockingRunnable = new BlockingRunnable(runnable);
            synchronized (blockingRunnable2) {
                NIODaemon nIODaemon = this;
                synchronized (nIODaemon) {
                    this.pendingRunnables.add(blockingRunnable);
                }
                this.wakeUp();
                try {
                    blockingRunnable.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Wait interrupted " + e.getMessage());
                }
                RuntimeException problem = blockingRunnable.getInvocationTargetException();
                if (problem != null) {
                    throw problem;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeLater(Runnable runnable) {
        NIODaemon nIODaemon = this;
        synchronized (nIODaemon) {
            if (!this.isRunning()) {
                throw new IllegalStateException();
            }
            this.pendingRunnables.add(runnable);
            this.wakeUp();
        }
    }

    public void stop() {
        this.invokeAndWait(new Shutdown(this));
        this.invokeAndWait(new Stop());
    }

    public Selector getSelector() {
        return this.selector;
    }

    public void setServer(NIOServer server) {
        this.server = server;
    }

    public NIOServer getServer() {
        return this.server;
    }

    private class Stop
    implements Runnable {
        private Stop() {
        }

        @Override
        public void run() {
            if (NIODaemon.this.selector.keys().size() != 0) {
                logger.warning("Server stopping with " + NIODaemon.this.selector.keys().size() + " active connections");
            } else {
                logger.info("Server stopping with " + NIODaemon.this.selector.keys().size() + " active connections");
            }
            NIODaemon.this.keepRunning = false;
        }
    }
}

