/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.performance;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.collections.api.block.function.primitive.IntToIntFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.set.primitive.ImmutableIntSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.persistence.IPersistable;

public class GroupModel
implements IPersistable {
    private static final String PERSISTENCE_KEY_GROUP_MODEL = ".groupModel";
    protected IndexPositionConverter indexPositionConverter;
    private boolean defaultCollapseable = true;
    private boolean defaultUnbreakable = false;
    private final List<Group> groups = new LinkedList<Group>();

    List<Group> getGroups() {
        return Collections.unmodifiableList(this.groups);
    }

    void setIndexPositionConverter(IndexPositionConverter converter) {
        this.indexPositionConverter = converter;
        this.updateVisibleStartPositions();
    }

    int getIndexByPosition(int position) {
        if (this.indexPositionConverter != null) {
            return this.indexPositionConverter.convertPositionToIndex(position);
        }
        return position;
    }

    int getPositionByIndex(int index) {
        if (this.indexPositionConverter != null) {
            return this.indexPositionConverter.convertIndexToPosition(index);
        }
        return index;
    }

    void updateVisibleStartPositions() {
        for (Group group : this.groups) {
            group.updateVisibleStartPosition();
        }
    }

    void performConsistencyCheck(boolean updateStartIndex) {
        for (Group group : this.groups) {
            group.consistencyCheck(updateStartIndex);
        }
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        StringBuilder strBuilder = new StringBuilder();
        for (Group group : this.groups) {
            String groupName = group.getName();
            if (group.getStartIndex() < 0) continue;
            strBuilder.append(groupName);
            strBuilder.append('=');
            strBuilder.append(group.startIndex).append(':');
            strBuilder.append(group.visibleStartIndex).append(':');
            strBuilder.append(group.visibleStartPosition).append(':');
            strBuilder.append(group.originalSpan).append(':');
            strBuilder.append(group.visibleSpan).append(':');
            strBuilder.append(group.collapsed ? "collapsed" : "expanded");
            strBuilder.append(':');
            strBuilder.append(group.collapseable ? "collapseable" : "uncollapseable");
            strBuilder.append(':');
            strBuilder.append(group.unbreakable ? "unbreakable" : "breakable");
            if (!group.staticIndexes.isEmpty()) {
                strBuilder.append(':').append(group.staticIndexes.toSortedList().makeString(","));
            }
            strBuilder.append('|');
        }
        properties.setProperty(String.valueOf(prefix) + PERSISTENCE_KEY_GROUP_MODEL, strBuilder.toString());
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        String property = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_GROUP_MODEL);
        if (property != null) {
            this.clear();
            StringTokenizer groupTokenizer = new StringTokenizer(property, "|");
            while (groupTokenizer.hasMoreTokens()) {
                String groupToken = groupTokenizer.nextToken();
                int separatorIndex = groupToken.indexOf(61);
                String groupName = groupToken.substring(0, separatorIndex);
                String[] groupProperties = groupToken.substring(separatorIndex + 1).split(":");
                String state = groupProperties[0];
                int startIndex = Integer.parseInt(state);
                state = groupProperties[1];
                int visibleStartIndex = Integer.parseInt(state);
                state = groupProperties[2];
                int visibleStartPosition = Integer.parseInt(state);
                state = groupProperties[3];
                int originalSpan = Integer.parseInt(state);
                state = groupProperties[4];
                int visibleSpan = Integer.parseInt(state);
                Group group = new Group(groupName, startIndex, originalSpan);
                this.groups.add(group);
                group.visibleStartIndex = visibleStartIndex;
                group.visibleStartPosition = visibleStartPosition;
                group.visibleSpan = visibleSpan;
                state = groupProperties[5];
                if ("collapsed".equals(state)) {
                    group.collapsed = true;
                } else if ("expanded".equals(state)) {
                    group.collapsed = false;
                } else {
                    throw new IllegalArgumentException(String.valueOf(state) + " not one of 'expanded' or 'collapsed'");
                }
                state = groupProperties[6];
                if ("collapseable".equals(state)) {
                    group.collapseable = true;
                } else if ("uncollapseable".equals(state)) {
                    group.collapseable = false;
                } else {
                    throw new IllegalArgumentException(String.valueOf(state) + " not one of 'uncollapseable' or 'collapseable'");
                }
                state = groupProperties[7];
                if ("breakable".equals(state)) {
                    group.unbreakable = false;
                } else if ("unbreakable".equals(state)) {
                    group.unbreakable = true;
                } else {
                    throw new IllegalArgumentException(String.valueOf(state) + " not one of 'breakable' or 'unbreakable'");
                }
                if (groupProperties.length != 9) continue;
                String statics = groupProperties[8];
                StringTokenizer staticTokenizer = new StringTokenizer(statics, ",");
                while (staticTokenizer.hasMoreTokens()) {
                    int index = Integer.parseInt(staticTokenizer.nextToken());
                    group.staticIndexes.add(index);
                }
            }
        }
    }

    public void addPositionsToGroup(Group group, int ... positions) {
        if (group != null && !group.isUnbreakable()) {
            int pos;
            Arrays.sort(positions);
            MutableIntList beforeStartPosition = IntLists.mutable.empty();
            MutableIntList afterStartPosition = IntLists.mutable.empty();
            int[] nArray = positions;
            int n = positions.length;
            int n2 = 0;
            while (n2 < n) {
                pos = nArray[n2];
                if (pos < group.getVisibleStartPosition()) {
                    beforeStartPosition.add(pos);
                } else {
                    afterStartPosition.add(pos);
                }
                ++n2;
            }
            int i = beforeStartPosition.size() - 1;
            while (i >= 0) {
                int pos2 = beforeStartPosition.get(i);
                if (pos2 != group.getVisibleStartPosition() - 1) break;
                group.setOriginalSpan(group.getOriginalSpan() + 1);
                group.setVisibleSpan(group.getVisibleSpan() + 1);
                int index = this.getIndexByPosition(pos2);
                group.members.add(index);
                group.setStartIndex(index);
                group.setVisibleStartIndex(index);
                group.updateVisibleStartPosition();
                --i;
            }
            nArray = afterStartPosition.toArray();
            n = nArray.length;
            n2 = 0;
            while (n2 < n) {
                pos = nArray[n2];
                int nextPos = group.getVisibleStartPosition() + group.getVisibleSpan();
                if (pos != nextPos) break;
                group.setOriginalSpan(group.getOriginalSpan() + 1);
                group.setVisibleSpan(group.getVisibleSpan() + 1);
                group.members.add(this.getIndexByPosition(nextPos));
                ++n2;
            }
        }
    }

    public void removePositionsFromGroup(Group group, int ... positions) {
        if (group != null && !group.isUnbreakable()) {
            Arrays.sort(positions);
            ImmutableIntSet visiblePositions = IntSets.immutable.of(group.getVisiblePositions());
            int i = positions.length - 1;
            while (i >= 0) {
                int pos = positions[i];
                if (visiblePositions.contains(pos)) {
                    int index = this.getIndexByPosition(pos);
                    if (index == group.getStartIndex()) {
                        group.setStartIndex(this.getIndexByPosition(pos + 1));
                        group.members.remove(index);
                        group.staticIndexes.remove(index);
                    } else {
                        int memberIndex = this.getIndexByPosition(group.getVisibleStartPosition() + group.getVisibleSpan() - 1);
                        group.members.remove(memberIndex);
                        group.staticIndexes.remove(memberIndex);
                    }
                    group.setOriginalSpan(group.getOriginalSpan() - 1);
                    group.setVisibleSpan(group.getVisibleSpan() - 1);
                    if (index == group.getVisibleStartIndex()) {
                        if (group.getOriginalSpan() > 0) {
                            group.setVisibleStartIndex(this.getIndexByPosition(pos + 1));
                        } else {
                            group.setStartIndex(-1);
                            group.setVisibleStartIndex(-1);
                            this.removeGroup(group);
                        }
                    }
                    group.updateVisibleStartPosition();
                }
                --i;
            }
        }
    }

    public Collection<Group> removePositionsFromGroup(int ... positions) {
        HashSet<Group> changed = new HashSet<Group>();
        Group group = null;
        Arrays.sort(positions);
        int i = positions.length - 1;
        while (i >= 0) {
            int pos = positions[i];
            group = this.getGroupByPosition(pos);
            if (group != null && !group.isUnbreakable()) {
                int index = this.getIndexByPosition(pos);
                if (index == group.getStartIndex()) {
                    group.setStartIndex(this.getIndexByPosition(pos + 1));
                    group.members.remove(index);
                    group.staticIndexes.remove(index);
                } else {
                    int memberIndex = this.getIndexByPosition(group.getVisibleStartPosition() + group.getVisibleSpan() - 1);
                    group.members.remove(memberIndex);
                    group.staticIndexes.remove(memberIndex);
                }
                group.setOriginalSpan(group.getOriginalSpan() - 1);
                group.setVisibleSpan(group.getVisibleSpan() - 1);
                if (index == group.getVisibleStartIndex()) {
                    if (group.getOriginalSpan() > 0) {
                        group.setVisibleStartIndex(this.getIndexByPosition(pos + 1));
                    } else {
                        group.setStartIndex(-1);
                        group.setVisibleStartIndex(-1);
                        this.removeGroup(group);
                    }
                }
                group.updateVisibleStartPosition();
                changed.add(group);
            }
            --i;
        }
        return changed;
    }

    public void addStaticIndexesToGroup(String groupName, int ... indexes) {
        Group group = this.getGroupByName(groupName);
        if (group != null) {
            this.addStaticIndexesToGroup(group, indexes);
        }
    }

    public void addStaticIndexesToGroup(int position, int ... indexes) {
        Group group = this.getGroupByPosition(position);
        if (group != null) {
            this.addStaticIndexesToGroup(group, indexes);
        }
    }

    public void addStaticIndexesToGroup(Group group, int ... indexes) {
        int[] staticIndexes = Arrays.stream(indexes).map(this::getPositionByIndex).filter(pos -> pos >= group.getVisibleStartPosition() && pos < group.getVisibleStartPosition() + group.getVisibleSpan()).toArray();
        if (staticIndexes.length > 0) {
            group.staticIndexes.addAll(staticIndexes);
        }
    }

    public Group getGroupByName(String groupName) {
        for (Group group : this.groups) {
            if (!group.getName().equals(groupName)) continue;
            return group;
        }
        return null;
    }

    public Group getGroupByPosition(int position) {
        for (Group group : this.groups) {
            if (position != group.getVisibleStartPosition() && (position < group.getVisibleStartPosition() || position >= group.getVisibleStartPosition() + group.getVisibleSpan())) continue;
            return group;
        }
        return null;
    }

    public Group getGroupByStaticIndex(int staticIndex) {
        for (Group group : this.groups) {
            if (!group.staticIndexes.contains(staticIndex)) continue;
            return group;
        }
        return null;
    }

    public Group findGroupByMemberIndex(int memberIndex) {
        for (Group group : this.groups) {
            if (!group.hasMember(memberIndex)) continue;
            return group;
        }
        return null;
    }

    public boolean isPartOfAGroup(int position) {
        Group group = this.getGroupByPosition(position);
        return group != null;
    }

    public void addGroup(String groupName, int startIndex, int span) {
        Group group = new Group(groupName, startIndex, span);
        group.collapseable = this.defaultCollapseable;
        group.unbreakable = this.defaultUnbreakable;
        this.addGroup(group);
    }

    public void addGroup(Group group) {
        this.groups.add(group);
    }

    public Group removeGroup(String groupName) {
        Group group = this.getGroupByName(groupName);
        if (group != null) {
            this.removeGroup(group);
        }
        return group;
    }

    public Group removeGroup(int position) {
        Group group = this.getGroupByPosition(position);
        if (group != null) {
            this.removeGroup(group);
        }
        return group;
    }

    public void removeGroup(Group group) {
        this.groups.remove(group);
    }

    public void clear() {
        this.groups.clear();
    }

    public int size() {
        return this.groups.size();
    }

    public boolean isEmpty() {
        return this.groups.isEmpty();
    }

    public boolean isStatic(int position) {
        Group group = this.getGroupByPosition(position);
        if (group != null) {
            return group.staticIndexes.contains(this.getIndexByPosition(position));
        }
        return false;
    }

    public boolean isPartOfACollapseableGroup(int position) {
        Group group = this.getGroupByPosition(position);
        if (group != null) {
            return group.isCollapseable();
        }
        return false;
    }

    public void setGroupCollapseable(String groupName, boolean collabseable) {
        Group group = this.getGroupByName(groupName);
        if (group != null) {
            group.setCollapseable(collabseable);
        }
    }

    public void setGroupCollapseable(int position, boolean collabseable) {
        Group group = this.getGroupByPosition(position);
        if (group != null) {
            group.setCollapseable(collabseable);
        }
    }

    public boolean isPartOfAnUnbreakableGroup(int position) {
        Group group = this.getGroupByPosition(position);
        if (group != null) {
            return group.isUnbreakable();
        }
        return false;
    }

    public void setGroupUnbreakable(String groupName, boolean unbreakable) {
        Group group = this.getGroupByName(groupName);
        if (group != null) {
            group.setUnbreakable(unbreakable);
        }
    }

    public void setGroupUnbreakable(int position, boolean unbreakable) {
        Group group = this.getGroupByPosition(position);
        if (group != null) {
            group.setUnbreakable(unbreakable);
        }
    }

    public boolean isDefaultCollapseable() {
        return this.defaultCollapseable;
    }

    public void setDefaultCollapseable(boolean defaultCollapseable) {
        this.defaultCollapseable = defaultCollapseable;
    }

    public boolean isDefaultUnbreakable() {
        return this.defaultUnbreakable;
    }

    public void setDefaultUnbreakable(boolean defaultUnbreakable) {
        this.defaultUnbreakable = defaultUnbreakable;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Group Model:\n");
        for (Group group : this.groups) {
            builder.append(group);
        }
        return builder.toString();
    }

    public class Group {
        private String name;
        private int startIndex;
        private int visibleStartIndex;
        private int visibleStartPosition;
        private int originalSpan;
        private int visibleSpan;
        private final MutableIntSet staticIndexes = IntSets.mutable.empty();
        private boolean collapseable = true;
        private boolean collapsed = false;
        private boolean unbreakable = false;
        private final MutableIntSet members = IntSets.mutable.empty();

        Group(String groupName, int startIndex, int span) {
            this.name = groupName;
            this.startIndex = startIndex;
            this.visibleStartIndex = startIndex;
            this.visibleStartPosition = GroupModel.this.getPositionByIndex(startIndex);
            this.originalSpan = span;
            this.visibleSpan = span;
            int pos = this.visibleStartPosition;
            while (pos < this.visibleStartPosition + this.visibleSpan) {
                this.members.add(GroupModel.this.getIndexByPosition(pos));
                ++pos;
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isCollapsed() {
            return this.collapsed;
        }

        public void setCollapsed(boolean collapsed) {
            if (this.collapseable) {
                this.collapsed = collapsed;
            }
        }

        public void toggleCollapsed() {
            this.setCollapsed(!this.collapsed);
        }

        public boolean isCollapseable() {
            return this.collapseable;
        }

        public void setCollapseable(boolean collapseable) {
            this.collapseable = collapseable;
            if (!this.collapseable && this.isCollapsed()) {
                this.collapsed = false;
            }
        }

        public boolean isUnbreakable() {
            return this.unbreakable;
        }

        public void setUnbreakable(boolean unbreakable) {
            this.unbreakable = unbreakable;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public void setStartIndex(int startIndex) {
            this.startIndex = startIndex;
        }

        public int getVisibleStartIndex() {
            return this.visibleStartIndex;
        }

        public void setVisibleStartIndex(int visibleStartIndex) {
            this.visibleStartIndex = visibleStartIndex;
        }

        public int getVisibleStartPosition() {
            return this.visibleStartPosition;
        }

        void updateVisibleStartPosition() {
            int startPosition = GroupModel.this.getPositionByIndex(this.startIndex);
            if (startPosition >= 0) {
                this.visibleStartIndex = this.startIndex;
            }
            this.visibleStartPosition = GroupModel.this.getPositionByIndex(this.visibleStartIndex);
            if (this.visibleStartPosition == -1) {
                this.consistencyCheck(false);
            }
        }

        void consistencyCheck(boolean updateStartIndex) {
            MutableIntList memberPositions = (MutableIntList)this.members.collectInt((IntToIntFunction & Serializable)member -> GroupModel.this.getPositionByIndex(member), (MutableIntCollection)IntLists.mutable.empty());
            int hidden = memberPositions.count((IntPredicate & Serializable)pos -> pos == -1);
            int smallestPosition = memberPositions.select((IntPredicate & Serializable)pos -> pos >= 0).minIfEmpty(-1);
            this.setVisibleSpan(this.originalSpan - hidden);
            int smallestIndex = GroupModel.this.getIndexByPosition(smallestPosition);
            if (updateStartIndex || this.startIndex < 0 && smallestIndex >= 0) {
                this.setStartIndex(smallestIndex);
            }
            this.setVisibleStartIndex(smallestIndex);
            this.visibleStartPosition = smallestPosition;
        }

        int[] getMembers() {
            return this.members.toSortedArray();
        }

        void addMembers(int ... memberIndexes) {
            this.members.addAll(memberIndexes);
        }

        void removeMembers(int ... memberIndexes) {
            this.members.removeAll(memberIndexes);
        }

        public boolean hasMember(int memberIndex) {
            return this.members.contains(memberIndex);
        }

        public int getOriginalSpan() {
            return this.originalSpan;
        }

        public void setOriginalSpan(int originalSpan) {
            this.originalSpan = originalSpan;
        }

        public int getVisibleSpan() {
            return this.visibleSpan;
        }

        public void setVisibleSpan(int visibleSpan) {
            if (visibleSpan <= this.originalSpan) {
                this.visibleSpan = visibleSpan;
            }
        }

        public boolean isEmpty() {
            return this.originalSpan == 0;
        }

        public void addStaticIndexes(int ... indexes) {
            this.staticIndexes.addAll(indexes);
        }

        public void removeStaticIndexes(int ... indexes) {
            this.staticIndexes.removeAll(indexes);
        }

        public boolean containsStaticIndex(int index) {
            return this.staticIndexes.contains(index);
        }

        public int[] getStaticIndexes() {
            return this.staticIndexes.toSortedArray();
        }

        public int[] getVisiblePositions() {
            int[] groupPositions = new int[this.visibleSpan];
            int i = 0;
            int pos = this.visibleStartPosition;
            while (pos < this.visibleStartPosition + this.visibleSpan) {
                groupPositions[i] = pos++;
                ++i;
            }
            return groupPositions;
        }

        public int[] getVisibleIndexes() {
            int[] groupIndexes = new int[this.visibleSpan];
            int i = 0;
            int pos = this.visibleStartPosition;
            while (pos < this.visibleStartPosition + this.visibleSpan) {
                groupIndexes[i] = GroupModel.this.getIndexByPosition(pos);
                ++i;
                ++pos;
            }
            return groupIndexes;
        }

        public int getGroupEndPosition(IUniqueIndexLayer layer) {
            return ((MutableIntSet)this.members.collectInt(layer::getColumnPositionByIndex, (MutableIntCollection)IntSets.mutable.empty())).maxIfEmpty(-1);
        }

        public boolean isGroupStart(int position) {
            return position == this.visibleStartPosition;
        }

        public boolean isGroupEnd(int position) {
            return this.visibleStartPosition + this.visibleSpan - 1 == position;
        }

        public String toString() {
            return "Group:\n\t name: " + this.name + "\n\t startIndex: " + this.startIndex + "\n\t visibleStartIndex: " + this.visibleStartIndex + "\n\t visibleStartPosition: " + this.visibleStartPosition + "\n\t originalSpan: " + this.originalSpan + "\n\t visibleSpan: " + this.visibleSpan + "\n\t collapseable: " + this.collapseable + "\n\t collapsed: " + this.collapsed + "\n\t unbreakable: " + this.unbreakable + "\n\t staticIndexes: [ " + this.staticIndexes.makeString(", ") + " ]\n";
        }
    }

    public static interface IndexPositionConverter {
        public int convertPositionToIndex(int var1);

        public int convertIndexToPosition(int var1);
    }
}

