/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.filterrow.combobox;

import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.IComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowPainter;
import org.eclipse.nebula.widgets.nattable.filterrow.TextMatchingMode;
import org.eclipse.nebula.widgets.nattable.filterrow.action.ClearFilterAction;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.ComboBoxFilterIconPainter;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.FilterRowComboBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.filterrow.config.FilterRowConfigAttributes;
import org.eclipse.nebula.widgets.nattable.filterrow.event.ClearFilterIconMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.ImagePainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.CellPainterDecorator;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.swt.graphics.GC;

public class ComboBoxFilterRowConfiguration
extends AbstractRegistryConfiguration {
    protected ICellEditor cellEditor;
    protected ImagePainter filterIconPainter;
    private FilterRowPainter filterRowPainter;

    public ComboBoxFilterRowConfiguration() {
    }

    public ComboBoxFilterRowConfiguration(IComboBoxDataProvider comboBoxDataProvider) {
        this.cellEditor = new FilterRowComboBoxCellEditor(comboBoxDataProvider, 10);
        this.filterIconPainter = new ComboBoxFilterIconPainter(comboBoxDataProvider);
    }

    public ComboBoxFilterRowConfiguration(ICellEditor cellEditor, ImagePainter filterIconPainter) {
        this.cellEditor = cellEditor;
        this.filterIconPainter = filterIconPainter;
    }

    @Override
    public void configureRegistry(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, this.cellEditor, DisplayMode.NORMAL, "FILTER_ROW");
        configRegistry.registerConfigAttribute(FilterRowConfigAttributes.TEXT_MATCHING_MODE, TextMatchingMode.REGULAR_EXPRESSION);
        CellPainterDecorator cellPainter = new CellPainterDecorator(new TextPainter(){
            {
                this.paintFg = false;
            }

            @Override
            public int getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
                return 0;
            }

            @Override
            public int getPreferredHeight(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
                return 0;
            }
        }, CellEdgeEnum.RIGHT, this.filterIconPainter);
        this.filterRowPainter = new FilterRowPainter(this.filterIconPainter);
        this.filterRowPainter.setWrappedPainter(cellPainter);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, this.filterRowPainter, DisplayMode.NORMAL, "FILTER_ROW");
    }

    @Override
    public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
        if (this.filterRowPainter != null) {
            uiBindingRegistry.registerFirstSingleClickBinding(new ClearFilterIconMouseEventMatcher(this.filterRowPainter), new ClearFilterAction());
        }
    }
}

