/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit.command;

import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.edit.EditController;
import org.eclipse.nebula.widgets.nattable.edit.command.EditSelectionCommand;
import org.eclipse.nebula.widgets.nattable.edit.command.EditUtils;
import org.eclipse.nebula.widgets.nattable.edit.event.InlineCellEditEvent;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.swt.widgets.Composite;

public class EditSelectionCommandHandler
extends AbstractLayerCommandHandler<EditSelectionCommand> {
    private SelectionLayer selectionLayer;
    private IUniqueIndexLayer upperLayer;

    public EditSelectionCommandHandler(SelectionLayer selectionLayer) {
        this(selectionLayer, null);
    }

    public EditSelectionCommandHandler(SelectionLayer selectionLayer, IUniqueIndexLayer upperLayer) {
        this.selectionLayer = selectionLayer;
        this.upperLayer = upperLayer;
    }

    @Override
    public Class<EditSelectionCommand> getCommandClass() {
        return EditSelectionCommand.class;
    }

    @Override
    public boolean doCommand(EditSelectionCommand command) {
        Composite parent = command.getParent();
        IConfigRegistry configRegistry = command.getConfigRegistry();
        Character initialValue = command.getCharacter();
        if (EditUtils.allCellsEditable(this.selectionLayer, this.upperLayer, configRegistry) && EditUtils.isEditorSame(this.selectionLayer, this.upperLayer, configRegistry) && EditUtils.isConverterSame(this.selectionLayer, this.upperLayer, configRegistry) && EditUtils.activateLastSelectedCellEditor(this.selectionLayer, configRegistry, command.isByTraversal())) {
            Collection<ILayerCell> selectedCells = EditUtils.getSelectedCellsForEditing(this.selectionLayer, this.upperLayer);
            if (selectedCells.size() == 1) {
                ILayerCell cell = selectedCells.iterator().next();
                this.selectionLayer.fireLayerEvent(new InlineCellEditEvent(new PositionCoordinate(this.selectionLayer, cell.getOriginColumnPosition(), cell.getOriginRowPosition()), parent, configRegistry, initialValue != null ? initialValue : cell.getDataValue()));
            } else if (selectedCells.size() > 1) {
                Object initialEditValue = initialValue;
                if (initialValue == null && EditUtils.isValueSame(this.selectionLayer, this.upperLayer)) {
                    ILayerCell cell = selectedCells.iterator().next();
                    initialEditValue = this.selectionLayer.getDataValueByPosition(cell.getColumnPosition(), cell.getRowPosition());
                }
                EditController.editCells(selectedCells, parent, initialEditValue, configRegistry);
            }
        }
        return true;
    }
}

