/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.copy.command;

import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.copy.InternalCellClipboard;
import org.eclipse.nebula.widgets.nattable.copy.command.PasteDataCommand;
import org.eclipse.nebula.widgets.nattable.edit.command.EditUtils;
import org.eclipse.nebula.widgets.nattable.edit.command.UpdateDataCommand;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class InternalPasteDataCommandHandler
extends AbstractLayerCommandHandler<PasteDataCommand> {
    protected SelectionLayer selectionLayer;
    protected InternalCellClipboard clipboard;

    public InternalPasteDataCommandHandler(SelectionLayer selectionLayer, InternalCellClipboard clipboard) {
        this.selectionLayer = selectionLayer;
        this.clipboard = clipboard;
    }

    @Override
    protected boolean doCommand(PasteDataCommand command) {
        if (this.clipboard.getCopiedCells() != null) {
            this.preInternalPaste();
            PositionCoordinate coord = this.selectionLayer.getSelectionAnchor();
            int pasteColumn = coord.getColumnPosition();
            int pasteRow = coord.getRowPosition();
            IUniqueIndexLayer pasteLayer = this.getPasteLayer(this.clipboard.getCopiedCells());
            if (pasteLayer != this.selectionLayer) {
                pasteColumn = LayerUtil.convertColumnPosition(this.selectionLayer, pasteColumn, pasteLayer);
                pasteRow = LayerUtil.convertRowPosition(this.selectionLayer, pasteRow, pasteLayer);
            }
            ILayerCell[][] iLayerCellArray = this.clipboard.getCopiedCells();
            int n = iLayerCellArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILayerCell[] cells;
                ILayerCell[] iLayerCellArray2 = cells = iLayerCellArray[n2];
                int n3 = cells.length;
                int n4 = 0;
                while (n4 < n3) {
                    ILayerCell cell = iLayerCellArray2[n4];
                    ILayerCell targetCell = pasteLayer.getCellByPosition(pasteColumn, pasteRow);
                    if (this.isPasteAllowed(cell, targetCell, command.configRegistry)) {
                        pasteLayer.doCommand(new UpdateDataCommand(pasteLayer, pasteColumn, pasteRow, this.getPasteValue(cell, pasteColumn, pasteRow)));
                    }
                    if (++pasteColumn >= pasteLayer.getColumnCount()) break;
                    ++n4;
                }
                ++pasteRow;
                pasteColumn = coord.getColumnPosition();
                ++n2;
            }
            this.postInternalPaste();
        }
        return true;
    }

    protected boolean isPasteAllowed(ILayerCell sourceCell, ILayerCell targetCell, IConfigRegistry configRegistry) {
        return EditUtils.isCellEditable(new PositionCoordinate(targetCell.getLayer(), targetCell.getColumnPosition(), targetCell.getRowPosition()), configRegistry);
    }

    protected Object getPasteValue(ILayerCell cell, int pasteColumn, int pasteRow) {
        return cell != null ? cell.getDataValue() : null;
    }

    public IUniqueIndexLayer getPasteLayer(ILayerCell[][] copiedCells) {
        if (copiedCells != null && copiedCells.length > 0 && copiedCells[0].length > 0) {
            ILayerCell[][] iLayerCellArray = this.clipboard.getCopiedCells();
            int n = iLayerCellArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILayerCell[] cells;
                ILayerCell[] iLayerCellArray2 = cells = iLayerCellArray[n2];
                int n3 = cells.length;
                int n4 = 0;
                while (n4 < n3) {
                    ILayerCell cell = iLayerCellArray2[n4];
                    if (cell != null && cell.getLayer() instanceof IUniqueIndexLayer) {
                        return (IUniqueIndexLayer)cell.getLayer();
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return this.selectionLayer;
    }

    protected void preInternalPaste() {
    }

    protected void postInternalPaste() {
    }

    @Override
    public Class<PasteDataCommand> getCommandClass() {
        return PasteDataCommand.class;
    }
}

