/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.calculation.Calculation;
import ca.odell.glazedlists.impl.swing.SwingThreadProxyCalculation;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.Format;
import javax.swing.JLabel;

public final class CalculationsSwing {
    private static final Float FLOAT_NAN = new Float(Float.NaN);
    private static final Double DOUBLE_NAN = new Double(Double.NaN);

    private CalculationsSwing() {
    }

    public static <E> Calculation<E> swingThreadProxyCalculation(Calculation<? extends E> source) {
        return new SwingThreadProxyCalculation<E>(source);
    }

    public static boolean isSwingThreadProxyCalculation(Calculation calc) {
        return calc instanceof SwingThreadProxyCalculation;
    }

    public static void bind(JLabel label, Calculation<?> calculation) {
        CalculationsSwing.bind(label, calculation, null);
    }

    public static void bind(JLabel label, Calculation<?> calculation, Format formatter) {
        calculation.addPropertyChangeListener(new CalculationToLabelBinder(label, formatter, calculation.getValue()));
    }

    private static final class CalculationToLabelBinder
    implements PropertyChangeListener {
        private final JLabel label;
        private final Format formatter;

        private CalculationToLabelBinder(JLabel label, Format formatter, Object initialValue) {
            this.label = label;
            this.formatter = formatter;
            this.update(initialValue);
        }

        private void update(Object value) {
            if (null == value || FLOAT_NAN.equals(value) || DOUBLE_NAN.equals(value)) {
                this.label.setText("");
            } else {
                this.label.setText(this.formatter != null ? this.formatter.format(value) : String.valueOf(value));
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.update(evt.getNewValue());
        }
    }
}

