/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.parser.builder.event;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.builder.event.DocumentBuilderEvent;

public class BeginBlockEvent
extends DocumentBuilderEvent {
    private final DocumentBuilder.BlockType type;
    private final Attributes attributes;

    public BeginBlockEvent(DocumentBuilder.BlockType type, Attributes attributes) {
        this.type = (DocumentBuilder.BlockType)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"Must provide a blockType"));
        this.attributes = ((Attributes)Preconditions.checkNotNull((Object)attributes, (Object)"Must provide attributes")).clone();
    }

    @Override
    public void invoke(DocumentBuilder builder) {
        builder.beginBlock(this.type, this.attributes);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BeginBlockEvent)) {
            return false;
        }
        BeginBlockEvent other = (BeginBlockEvent)obj;
        return this.type == other.type;
    }

    public String toString() {
        return String.format("beginBlock(%s)", new Object[]{this.type});
    }
}

