/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.parser.builder.event;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.builder.event.DocumentBuilderEvent;

public class AcronymEvent
extends DocumentBuilderEvent {
    private final String text;
    private final String definition;

    public AcronymEvent(String text, String definition) {
        this.text = (String)Preconditions.checkNotNull((Object)text, (Object)"Must provide text");
        this.definition = (String)Preconditions.checkNotNull((Object)definition, (Object)"Must provide definition");
    }

    @Override
    public void invoke(DocumentBuilder builder) {
        builder.acronym(this.text, this.definition);
    }

    public String toString() {
        return String.format("acronym(%s,%s)", this.text, this.definition);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.text, this.definition});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AcronymEvent)) {
            return false;
        }
        AcronymEvent other = (AcronymEvent)obj;
        return Objects.equal((Object)this.text, (Object)other.text) && Objects.equal((Object)this.definition, (Object)other.definition);
    }
}

