/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.contentassist;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.xbase.imports.RewritableImportSection;
import org.eclipse.xtext.xbase.ui.contentassist.WhitespaceHelper;
import org.eclipse.xtext.xbase.ui.document.DocumentSourceAppender;
import org.eclipse.xtext.xbase.ui.imports.ReplaceConverter;

public class ReplacingAppendable
extends DocumentSourceAppender {
    private ReplaceConverter replaceConverter;

    protected ReplacingAppendable(IXtextDocument document, RewritableImportSection importSection, WhitespaceHelper whitespaceHelper, String indentString, String lineSeparator, int baseIndentationLevel, boolean isJava, ReplaceConverter replaceConverter) {
        super(document, importSection, whitespaceHelper, indentString, lineSeparator, baseIndentationLevel, isJava);
        this.replaceConverter = replaceConverter;
    }

    public int commitChanges() throws BadLocationException {
        ReplaceRegion change = this.getChange();
        return this.commitChanges(change);
    }

    public int commitChanges(int offset, int length) throws BadLocationException {
        ReplaceRegion change = this.getChange(offset, length);
        return this.commitChanges(change);
    }

    protected int commitChanges(ReplaceRegion change) throws BadLocationException {
        this.getDocument().replace(change.getOffset(), change.getLength(), change.getText());
        return this.insertNewImports();
    }

    public int insertNewImports() throws BadLocationException {
        List importChanges = this.getImportSection().rewrite();
        int lengthDelta = 0;
        if (!importChanges.isEmpty()) {
            for (ReplaceRegion change : importChanges) {
                lengthDelta = lengthDelta - change.getLength() + change.getText().length();
            }
            this.replaceConverter.convertToTextEdit(importChanges).apply((IDocument)this.getDocument());
        }
        return lengthDelta;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends DocumentSourceAppender.Factory<ReplacingAppendable> {
        @Inject
        private ReplaceConverter replaceConverter;

        @Override
        protected ReplacingAppendable newInstance(IXtextDocument document, RewritableImportSection importSection, WhitespaceHelper whitespaceHelper, String indentString, String lineSeparator, int baseIndentationLevel, boolean isJava) {
            return new ReplacingAppendable(document, importSection, whitespaceHelper, indentString, lineSeparator, baseIndentationLevel, isJava, this.replaceConverter);
        }
    }
}

