/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.outline;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.jvmmodel.DispatchHelper;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.ide.labeling.XtendImages;
import org.eclipse.xtend.ide.outline.AbstractMultiModeOutlineTreeProvider;
import org.eclipse.xtend.ide.outline.XtendEObjectNode;
import org.eclipse.xtend.ide.outline.XtendFeatureNode;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.DocumentRootNode;
import org.eclipse.xtext.xbase.ui.labeling.XbaseImageAdornments;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendOutlineSourceTreeProvider
extends AbstractMultiModeOutlineTreeProvider {
    @Inject
    private XbaseImageAdornments adornments;
    @Inject
    private DispatchHelper dispatchHelper;
    @Inject
    private XtendImages images;

    @Override
    public void internalCreateChildren(DocumentRootNode parentNode, EObject modelElement) {
        if (modelElement instanceof XtendFile) {
            XtendFile xtendFile = (XtendFile)modelElement;
            this.getOutlineNodeFactory().createPackageAndImporNodes(parentNode, xtendFile);
            for (XtendTypeDeclaration xtendType : xtendFile.getXtendTypes()) {
                HashSet processedFeatures = Sets.newHashSet();
                this.createNodeForType((IOutlineNode)parentNode, xtendType, (Set<JvmMember>)processedFeatures, 0);
            }
        }
    }

    protected void internalCreateChildren(IOutlineNode parentNode, EObject modelElement) {
        if (modelElement instanceof XtendTypeDeclaration) {
            HashSet processedFeatures = Sets.newHashSet();
            JvmDeclaredType inferredType = this.getAssociations().getInferredType((XtendTypeDeclaration)modelElement);
            this.createFeatureNodes(parentNode, (XtendTypeDeclaration)modelElement, inferredType, processedFeatures);
        } else {
            super.internalCreateChildren(parentNode, modelElement);
        }
    }

    private void createNodeForType(IOutlineNode parentNode, XtendTypeDeclaration xtendType, Set<JvmMember> processedFeatures, int inheritanceDepth) {
        XtendEObjectNode classNode = this.createXtendNode(parentNode, (EObject)xtendType, inheritanceDepth);
        JvmDeclaredType inferredType = this.getAssociations().getInferredType(xtendType);
        processedFeatures.add((JvmMember)inferredType);
        this.createFeatureNodes((IOutlineNode)classNode, xtendType, inferredType, processedFeatures);
    }

    private void createFeatureNodes(IOutlineNode parentNode, XtendTypeDeclaration xtendType, JvmDeclaredType inferredType, Set<JvmMember> processedFeatures) {
        if (inferredType != null) {
            this.createFeatureNodesForType(parentNode, xtendType, inferredType, inferredType, processedFeatures, 0);
        } else {
            for (XtendMember member : xtendType.getMembers()) {
                this.createNode(parentNode, (EObject)member);
            }
        }
    }

    private void createFeatureNodesForType(IOutlineNode parentNode, XtendTypeDeclaration xtendType, JvmDeclaredType inferredType, JvmDeclaredType baseType, Set<JvmMember> processedMembers, int inheritanceDepth) {
        if (xtendType != null) {
            for (XtendMember xtendMember : xtendType.getMembers()) {
                EObject jvmElement = this.getAssociations().getPrimaryJvmElement((EObject)xtendMember);
                if (!(jvmElement instanceof JvmMember) || processedMembers.contains(jvmElement)) continue;
                if (xtendMember instanceof XtendTypeDeclaration) {
                    if (this.isShowInherited()) {
                        HashSet forgetProcessed = Sets.newHashSet();
                        this.createNodeForType(parentNode, (EObject)xtendMember, (Set<JvmMember>)forgetProcessed, inheritanceDepth);
                    } else {
                        this.createNodeForType(parentNode, (EObject)xtendMember, processedMembers, inheritanceDepth);
                    }
                } else if (jvmElement instanceof JvmFeature) {
                    JvmFeature jvmFeature = (JvmFeature)jvmElement;
                    if (this.skipFeature(jvmFeature)) continue;
                    if (this.isDispatchRelated(jvmFeature)) {
                        this.createDispatchOperationNodes(parentNode, inferredType, baseType, processedMembers, inheritanceDepth);
                    } else {
                        XtendFeatureNode featureNode = this.createNodeForFeature(parentNode, inferredType, jvmFeature, (EObject)xtendMember, inheritanceDepth);
                        this.handleLocalClasses(jvmFeature, featureNode, inheritanceDepth);
                    }
                }
                this.rememberJvmMember(processedMembers, (JvmMember)jvmElement);
            }
        }
        if (this.isShowInherited()) {
            this.handleInheritedMembers(parentNode, inferredType, baseType, processedMembers, inheritanceDepth);
        }
    }

    private void handleLocalClasses(JvmFeature jvmFeature, XtendEObjectNode featureNode, int inheritanceDepth) {
        if (!jvmFeature.getLocalClasses().isEmpty()) {
            for (JvmGenericType jvmGenericType : jvmFeature.getLocalClasses()) {
                Set sourceElements = this.getAssociations().getSourceElements((EObject)jvmGenericType);
                HashSet forgetProcessed = Sets.newHashSet();
                for (EObject eObject : sourceElements) {
                    if (!(eObject instanceof XtendTypeDeclaration)) continue;
                    this.createNodeForType((IOutlineNode)featureNode, eObject, (Set<JvmMember>)forgetProcessed, inheritanceDepth);
                }
            }
        }
    }

    private boolean isDispatchRelated(JvmFeature jvmFeature) {
        return jvmFeature instanceof JvmOperation && (this.dispatchHelper.isDispatchFunction((JvmOperation)jvmFeature) || this.dispatchHelper.isDispatcherFunction((JvmOperation)jvmFeature));
    }

    private void createDispatchOperationNodes(IOutlineNode parentNode, JvmDeclaredType inferredType, final JvmDeclaredType baseType, Set<JvmMember> processedFeatures, int inheritanceDepth) {
        for (JvmOperation operation : inferredType.getDeclaredOperations()) {
            List dispatchCases;
            JvmOperation dispatcher;
            XtendFeatureNode dispatcherNode;
            if (!this.dispatchHelper.isDispatcherFunction(operation) || (dispatcherNode = this.createNodeForFeature(parentNode, baseType, (JvmFeature)(dispatcher = operation), (EObject)dispatcher, inheritanceDepth)) == null) continue;
            dispatcherNode.setDispatch(true);
            this.rememberJvmMember(processedFeatures, (JvmMember)dispatcher);
            boolean inheritsDispatchCases = false;
            if (this.isShowInherited()) {
                dispatchCases = this.dispatchHelper.getAllDispatchCases(dispatcher);
            } else {
                dispatchCases = Lists.newArrayList((Iterable)this.dispatchHelper.getLocalDispatchCases(dispatcher));
                Collections.sort(dispatchCases, new Comparator<JvmOperation>(){

                    @Override
                    public int compare(JvmOperation o1, JvmOperation o2) {
                        return baseType.getMembers().indexOf((Object)o1) - baseType.getMembers().indexOf((Object)o2);
                    }
                });
            }
            for (JvmOperation dispatchCase : dispatchCases) {
                inheritsDispatchCases |= dispatchCase.getDeclaringType() != baseType;
                XtendFunction xtendFunction = this.getAssociations().getXtendFunction(dispatchCase);
                if (xtendFunction == null) {
                    this.createNodeForFeature((IOutlineNode)dispatcherNode, baseType, (JvmFeature)dispatchCase, (EObject)dispatchCase, inheritanceDepth);
                } else {
                    this.createNodeForFeature((IOutlineNode)dispatcherNode, baseType, (JvmFeature)dispatchCase, (EObject)xtendFunction, inheritanceDepth);
                }
                this.rememberJvmMember(processedFeatures, (JvmMember)dispatchCase);
            }
            if (!inheritsDispatchCases) continue;
            dispatcherNode.setImageDescriptor(this.images.forDispatcherFunction(dispatcher.getVisibility(), this.adornments.get((JvmIdentifiableElement)dispatcher) | 0x80));
        }
    }

    @Override
    protected void createInheritedFeatureNodes(IOutlineNode parentNode, JvmDeclaredType baseType, Set<JvmMember> processedFeatures, int inheritanceDepth, JvmTypeReference superType) {
        if (superType.getType() instanceof JvmDeclaredType) {
            JvmGenericType superClass = (JvmGenericType)superType.getType();
            EObject xtendSuperClass = this.getAssociations().getPrimarySourceElement((EObject)superClass);
            if (xtendSuperClass instanceof XtendTypeDeclaration) {
                this.createFeatureNodesForType(parentNode, (XtendTypeDeclaration)xtendSuperClass, (JvmDeclaredType)superClass, baseType, processedFeatures, inheritanceDepth + 1);
            } else {
                this.createFeatureNodesForType(parentNode, (JvmDeclaredType)superClass, baseType, processedFeatures, inheritanceDepth + 1);
            }
        }
    }

    private void addCreateExtensionJvmFeatures(Set<JvmMember> processedFeatures, JvmMember feature) {
        EObject sourceElement = this.getAssociations().getPrimarySourceElement((EObject)feature);
        if (!(sourceElement instanceof XtendFunction)) {
            return;
        }
        XtendFunction function = (XtendFunction)sourceElement;
        if (function.getCreateExtensionInfo() == null) {
            return;
        }
        for (EObject jvmElement : this.getAssociations().getJvmElements((EObject)function)) {
            if (jvmElement == feature || !(jvmElement instanceof JvmFeature)) continue;
            JvmFeature jvmFeature = (JvmFeature)jvmElement;
            if (jvmFeature.getSimpleName().startsWith("_createCache_")) {
                processedFeatures.add((JvmMember)jvmFeature);
            }
            if (!jvmFeature.getSimpleName().startsWith("_init_")) continue;
            processedFeatures.add((JvmMember)jvmFeature);
        }
    }

    @Override
    protected void rememberJvmMember(Set<JvmMember> processedFeatures, JvmMember feature) {
        super.rememberJvmMember(processedFeatures, feature);
        this.addCreateExtensionJvmFeatures(processedFeatures, feature);
    }

    @Override
    protected void createNodeForType(IOutlineNode parentNode, EObject someType, Set<JvmMember> processedFeatures, int inheritanceDepth) {
        if (someType instanceof XtendTypeDeclaration) {
            XtendTypeDeclaration xtendType = (XtendTypeDeclaration)someType;
            this.createNodeForType(parentNode, xtendType, processedFeatures, inheritanceDepth);
        }
    }
}

