/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.standalone;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.xtext.common.types.descriptions.IStubGenerator;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.generator.IOutputConfigurationProvider;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageAccess {
    private static final Logger LOG = Logger.getLogger(LanguageAccess.class);
    private Set<OutputConfiguration> outputConfigs;
    private IResourceServiceProvider resourceServiceProvider;
    private boolean linksAgainstJava = true;
    private JavaIoFileSystemAccess fsa;
    private File baseDir;

    public LanguageAccess(Set<OutputConfiguration> outputConfigurations, IResourceServiceProvider resourceServiceProvider, File baseDir) {
        this(outputConfigurations, resourceServiceProvider, false, baseDir);
    }

    public LanguageAccess(Set<OutputConfiguration> outputConfigurations, IResourceServiceProvider resourceServiceProvider, boolean linksAgainstJavaTypes, File baseDir) {
        this.outputConfigs = outputConfigurations;
        this.resourceServiceProvider = resourceServiceProvider;
        this.linksAgainstJava = linksAgainstJavaTypes;
        this.baseDir = baseDir;
    }

    public IGenerator getGenerator() {
        return (IGenerator)this.resourceServiceProvider.get(IGenerator.class);
    }

    public IStubGenerator getStubGenerator() {
        return (IStubGenerator)this.resourceServiceProvider.get(IStubGenerator.class);
    }

    public JavaIoFileSystemAccess getFileSystemAccess() {
        if (this.fsa == null) {
            this.fsa = this.configuredFileSystemAccess((JavaIoFileSystemAccess)this.resourceServiceProvider.get(JavaIoFileSystemAccess.class));
        }
        return this.fsa;
    }

    private JavaIoFileSystemAccess configuredFileSystemAccess(JavaIoFileSystemAccess fsaToConfigure) {
        HashSet confsForFsa = Sets.newHashSet();
        Set<OutputConfiguration> pomOutputConfigs = this.getConfiguredOutputConfigs();
        if (pomOutputConfigs != null && !pomOutputConfigs.isEmpty()) {
            for (OutputConfiguration pomConfig : pomOutputConfigs) {
                if (this.getOutputConfigurationProvider().getOutputConfigurations().contains(pomConfig)) {
                    confsForFsa.add(pomConfig);
                    continue;
                }
                LOG.warn((Object)("Output '" + pomConfig.getName() + "' is not configured in OutputConfigurationProvider."));
            }
        }
        confsForFsa.addAll(this.getOutputConfigurationProvider().getOutputConfigurations());
        Map asMap = IterableExtensions.toMap((Iterable)Iterables.transform((Iterable)confsForFsa, (Function)new Function<OutputConfiguration, OutputConfiguration>(){

            public OutputConfiguration apply(OutputConfiguration output) {
                output.setOutputDirectory(LanguageAccess.this.resolveToBaseDir(output.getOutputDirectory()));
                return output;
            }
        }), (Functions.Function1)new Functions.Function1<OutputConfiguration, String>(){

            public String apply(OutputConfiguration it) {
                return it.getName();
            }
        });
        fsaToConfigure.setOutputConfigurations(asMap);
        return fsaToConfigure;
    }

    public Set<OutputConfiguration> getConfiguredOutputConfigs() {
        return this.outputConfigs;
    }

    public IResourceDescription.Manager getResourceDescriptionManager() {
        return this.resourceServiceProvider.getResourceDescriptionManager();
    }

    public IOutputConfigurationProvider getOutputConfigurationProvider() {
        return (IOutputConfigurationProvider)this.resourceServiceProvider.get(IOutputConfigurationProvider.class);
    }

    public IEncodingProvider getEncodingProvider() {
        return (IEncodingProvider)this.resourceServiceProvider.get(IEncodingProvider.Runtime.class);
    }

    public IResourceValidator getResourceValidator() {
        return this.resourceServiceProvider.getResourceValidator();
    }

    public void setLinksAgainstJava(boolean linksAgainstJava) {
        this.linksAgainstJava = linksAgainstJava;
    }

    public boolean isLinksAgainstJava() {
        return this.linksAgainstJava;
    }

    protected String resolveToBaseDir(String directory) {
        File outDir = new File(directory);
        if (!outDir.isAbsolute()) {
            outDir = new File(this.baseDir, directory);
        }
        return outDir.getAbsolutePath();
    }
}

