/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.conversion.impl;

import org.eclipse.emf.ecore.EDataType;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EFactoryValueConverter
implements IValueConverter<Object> {
    private final EDataType dataType;

    public EFactoryValueConverter(EDataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public String toString(Object value) {
        return this.dataType.getEPackage().getEFactoryInstance().convertToString(this.dataType, value);
    }

    @Override
    public Object toValue(String string, INode node) throws ValueConverterException {
        try {
            Object value = this.dataType.getEPackage().getEFactoryInstance().createFromString(this.dataType, string);
            if (value == null && this.dataType.getInstanceClass().isPrimitive()) {
                throw new ValueConverterException("Couldn't convert '" + Strings.notNull((Object)string) + "' to " + this.dataType.getName() + ".", node, null);
            }
            return value;
        }
        catch (Exception exc) {
            throw new ValueConverterException("Error converting string to value", node, exc);
        }
    }
}

