/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4.logging;

import com.google.common.annotations.Beta;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggingEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public class LoggingTester {
    public static void setLoggingLevel(Class<?> clazz, Level level) {
        Logger log = LoggingTester.getLogger(clazz);
        if (log != null) {
            log.setLevel(level);
        }
    }

    public static int countErrorLogging(Class<?> clazz, Runnable executable) {
        Logger original = LoggingTester.getLogger(clazz);
        try {
            final AtomicInteger numberOfLoggings = new AtomicInteger();
            LoggingTester.setLogger(clazz, new DelegatingLogger(original){

                public void error(Object message, Throwable t) {
                    numberOfLoggings.incrementAndGet();
                }

                public void error(Object message) {
                    numberOfLoggings.incrementAndGet();
                }
            });
            executable.run();
            int n = numberOfLoggings.get();
            return n;
        }
        finally {
            LoggingTester.setLogger(clazz, original);
        }
    }

    private static Logger getLogger(Class<?> clazz) {
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (Modifier.isStatic(f.getModifiers()) && f.getType().isAssignableFrom(Logger.class)) {
                try {
                    f.setAccessible(true);
                    return (Logger)f.get(null);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            ++n2;
        }
        throw new IllegalArgumentException("The class " + clazz.getName() + " does not declare a static field of type org.apache.log4j.Logger.");
    }

    private static void setLogger(Class<?> clazz, Logger logger) {
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (Modifier.isStatic(f.getModifiers()) && f.getType().isAssignableFrom(Logger.class)) {
                try {
                    f.setAccessible(true);
                    f.set(null, logger);
                    return;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            ++n2;
        }
        throw new IllegalArgumentException("The class " + clazz.getName() + " does not declare a static field of type org.apache.log4j.Logger.");
    }

    static class DelegatingLogger
    extends Logger {
        private Logger delegate;

        protected DelegatingLogger(Logger delegate) {
            super(delegate.getName());
            this.delegate = delegate;
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public void trace(Object message) {
            this.delegate.trace(message);
        }

        public void addAppender(Appender newAppender) {
            this.delegate.addAppender(newAppender);
        }

        public void trace(Object message, Throwable t) {
            this.delegate.trace(message, t);
        }

        public void assertLog(boolean assertion, String msg) {
            this.delegate.assertLog(assertion, msg);
        }

        public boolean isTraceEnabled() {
            return this.delegate.isTraceEnabled();
        }

        public void callAppenders(LoggingEvent event) {
            this.delegate.callAppenders(event);
        }

        public void debug(Object message) {
            this.delegate.debug(message);
        }

        public void debug(Object message, Throwable t) {
            this.delegate.debug(message, t);
        }

        public String toString() {
            return this.delegate.toString();
        }

        public void error(Object message) {
            this.delegate.error(message);
        }

        public void error(Object message, Throwable t) {
            this.delegate.error(message, t);
        }

        public void fatal(Object message) {
            this.delegate.fatal(message);
        }

        public void fatal(Object message, Throwable t) {
            this.delegate.fatal(message, t);
        }

        public boolean getAdditivity() {
            return this.delegate.getAdditivity();
        }

        public Enumeration getAllAppenders() {
            return this.delegate.getAllAppenders();
        }

        public Appender getAppender(String name) {
            return this.delegate.getAppender(name);
        }

        public Level getEffectiveLevel() {
            return this.delegate.getEffectiveLevel();
        }

        public Priority getChainedPriority() {
            return this.delegate.getChainedPriority();
        }

        public LoggerRepository getHierarchy() {
            return this.delegate.getHierarchy();
        }

        public LoggerRepository getLoggerRepository() {
            return this.delegate.getLoggerRepository();
        }

        public ResourceBundle getResourceBundle() {
            return this.delegate.getResourceBundle();
        }

        public void info(Object message) {
            this.delegate.info(message);
        }

        public void info(Object message, Throwable t) {
            this.delegate.info(message, t);
        }

        public boolean isAttached(Appender appender) {
            return this.delegate.isAttached(appender);
        }

        public boolean isDebugEnabled() {
            return this.delegate.isDebugEnabled();
        }

        public boolean isEnabledFor(Priority level) {
            return this.delegate.isEnabledFor(level);
        }

        public boolean isInfoEnabled() {
            return this.delegate.isInfoEnabled();
        }

        public void l7dlog(Priority priority, String key, Throwable t) {
            this.delegate.l7dlog(priority, key, t);
        }

        public void l7dlog(Priority priority, String key, Object[] params, Throwable t) {
            this.delegate.l7dlog(priority, key, params, t);
        }

        public void log(Priority priority, Object message, Throwable t) {
            this.delegate.log(priority, message, t);
        }

        public void log(Priority priority, Object message) {
            this.delegate.log(priority, message);
        }

        public void log(String callerFQCN, Priority level, Object message, Throwable t) {
            this.delegate.log(callerFQCN, level, message, t);
        }

        public void removeAllAppenders() {
            this.delegate.removeAllAppenders();
        }

        public void removeAppender(Appender appender) {
            this.delegate.removeAppender(appender);
        }

        public void removeAppender(String name) {
            this.delegate.removeAppender(name);
        }

        public void setAdditivity(boolean additive) {
            this.delegate.setAdditivity(additive);
        }

        public void setLevel(Level level) {
            this.delegate.setLevel(level);
        }

        public void setPriority(Priority priority) {
            this.delegate.setPriority(priority);
        }

        public void setResourceBundle(ResourceBundle bundle) {
            this.delegate.setResourceBundle(bundle);
        }

        public void warn(Object message) {
            this.delegate.warn(message);
        }

        public void warn(Object message, Throwable t) {
            this.delegate.warn(message, t);
        }
    }
}

