/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parsetree.reconstr.ITransientValueService;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.refactoring.ElementRenameArguments;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.impl.AbstractReferenceUpdater;
import org.eclipse.xtext.ui.refactoring.impl.CrossReferenceSerializerFacade;
import org.eclipse.xtext.util.ITextRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultReferenceUpdater
extends AbstractReferenceUpdater {
    @Inject
    private ILocationInFileProvider locationInFileProvider;
    @Inject
    private ITransientValueService transientValueService;
    @Inject
    private CrossReferenceSerializerFacade crossReferenceSerializerFacade;

    @Override
    protected void createReferenceUpdates(ElementRenameArguments elementRenameArguments, Multimap<URI, IReferenceDescription> resource2references, ResourceSet resourceSet, IRefactoringUpdateAcceptor updateAcceptor, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Creating reference updates", (int)resource2references.keySet().size());
        for (URI referringResourceURI : resource2references.keySet()) {
            if (progress.isCanceled()) {
                return;
            }
            Resource referringResource = resourceSet.getResource(referringResourceURI, false);
            if (!(referringResource instanceof XtextResource)) {
                updateAcceptor.getRefactoringStatus().add(3, "Resource {0} is not an XtextResource.", referringResource.getURI(), resourceSet);
            } else {
                Collection referenceDescriptions = resource2references.get((Object)referringResourceURI);
                this.processReferringResource(referringResource, referenceDescriptions, elementRenameArguments, updateAcceptor);
            }
            progress.worked(1);
        }
    }

    protected void processReferringResource(Resource referringResource, Iterable<IReferenceDescription> referenceDescriptions, ElementRenameArguments elementRenameArguments, IRefactoringUpdateAcceptor updateAcceptor) {
        ((XtextResource)referringResource).getCache().clear(referringResource);
        for (IReferenceDescription referenceDescription : referenceDescriptions) {
            this.createReferenceUpdate(referenceDescription, referringResource.getURI(), elementRenameArguments, referringResource.getResourceSet(), updateAcceptor);
        }
    }

    protected void createReferenceUpdate(IReferenceDescription referenceDescription, URI referringResourceURI, ElementRenameArguments elementRenameArguments, ResourceSet resourceSet, IRefactoringUpdateAcceptor updateAcceptor) {
        URI referringElementNewURI = elementRenameArguments.getNewElementURI(referenceDescription.getSourceEObjectUri());
        EObject referringElement = resourceSet.getEObject(referringElementNewURI, false);
        URI targetElementNewURI = elementRenameArguments.getNewElementURI(referenceDescription.getTargetEObjectUri());
        EObject newTargetElement = resourceSet.getEObject(targetElementNewURI, false);
        this.createReferenceUpdate(referringElement, referringResourceURI, referenceDescription.getEReference(), referenceDescription.getIndexInList(), newTargetElement, updateAcceptor);
    }

    protected void createReferenceUpdate(EObject referringElement, URI referringResourceURI, EReference reference, int indexInList, EObject newTargetElement, IRefactoringUpdateAcceptor updateAcceptor) {
        ITextRegion referenceTextRegion;
        CrossReference crossReference;
        if (!this.transientValueService.isTransient(referringElement, (EStructuralFeature)reference, indexInList) && (crossReference = this.getCrossReference(referringElement, (referenceTextRegion = this.locationInFileProvider.getFullTextRegion(referringElement, (EStructuralFeature)reference, indexInList)).getOffset())) != null) {
            String newReferenceText = this.crossReferenceSerializerFacade.serializeCrossRef(referringElement, crossReference, newTargetElement, referenceTextRegion, updateAcceptor.getRefactoringStatus());
            this.createTextChange(referenceTextRegion, newReferenceText, referringElement, newTargetElement, reference, referringResourceURI, updateAcceptor);
        }
    }

    protected void createTextChange(ITextRegion referenceTextRegion, String newReferenceText, EObject referringElement, EObject newTargetElement, EReference reference, URI referringResourceURI, IRefactoringUpdateAcceptor updateAcceptor) {
        if (newReferenceText != null) {
            ReplaceEdit referenceEdit = new ReplaceEdit(referenceTextRegion.getOffset(), referenceTextRegion.getLength(), newReferenceText);
            updateAcceptor.accept(referringResourceURI, (TextEdit)referenceEdit);
        }
    }

    protected CrossReference getCrossReference(EObject referringElement, int offset) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)referringElement);
        if (node != null) {
            for (INode childNode : node.getAsTreeIterable()) {
                if (childNode.getOffset() < offset || !(childNode.getGrammarElement() instanceof CrossReference)) continue;
                return (CrossReference)childNode.getGrammarElement();
            }
        }
        return null;
    }

    protected ILocationInFileProvider getLocationInFileProvider() {
        return this.locationInFileProvider;
    }

    protected ITransientValueService getTransientValueService() {
        return this.transientValueService;
    }

    protected CrossReferenceSerializerFacade getCrossReferenceSerializerFacade() {
        return this.crossReferenceSerializerFacade;
    }
}

