/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.scoping.batch.AbstractSessionBasedScope;
import org.eclipse.xtext.xbase.scoping.batch.BucketedEObjectDescription;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.TypeBucket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStaticImportsScope
extends AbstractSessionBasedScope {
    public AbstractStaticImportsScope(IScope parent, IFeatureScopeSession session, XAbstractFeatureCall context) {
        super(parent, session, context);
    }

    protected Iterable<IEObjectDescription> getAllLocalElements() {
        List<TypeBucket> buckets = this.getBuckets();
        if (buckets.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        for (TypeBucket bucket : buckets) {
            for (JvmType type : bucket.getTypes()) {
                if (!(type instanceof JvmDeclaredType)) continue;
                Iterable features = ((JvmDeclaredType)type).getAllFeatures();
                for (JvmFeature feature : features) {
                    this.addDescriptions(feature, bucket, result);
                }
            }
        }
        return result;
    }

    protected void addDescriptions(JvmFeature feature, TypeBucket bucket, List<IEObjectDescription> result) {
        result.add((IEObjectDescription)new BucketedEObjectDescription(QualifiedName.create((String)feature.getSimpleName()), (EObject)feature, bucket.getId()));
    }

    protected abstract List<TypeBucket> getBuckets();

    @Override
    protected Collection<IEObjectDescription> getLocalElementsByName(QualifiedName name) {
        List<TypeBucket> buckets = this.getBuckets();
        if (buckets.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        String simpleName = this.getFeatureName(name);
        for (TypeBucket bucket : buckets) {
            for (JvmType type : bucket.getTypes()) {
                if (!(type instanceof JvmDeclaredType)) continue;
                Iterable features = ((JvmDeclaredType)type).findAllFeaturesByName(simpleName);
                for (JvmFeature feature : features) {
                    result.add(this.createNamedDescription(name, feature, bucket));
                }
            }
        }
        return result;
    }

    protected BucketedEObjectDescription createNamedDescription(QualifiedName name, JvmFeature feature, TypeBucket bucket) {
        return new BucketedEObjectDescription(name, (EObject)feature, bucket.getId());
    }
}

