/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.resource;

import com.google.common.base.Function;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryRegistryImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.ui.resource.UriValidator;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.SimpleCache;
import org.eclipse.xtext.util.Tuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class Storage2UriMapperImpl
implements IStorage2UriMapper,
IResourceChangeListener {
    private ResourceFactoryRegistryImpl resourceFactoryRegistry;
    @Inject
    private UriValidator uriValidator;
    private final SimpleCache<URI, Iterable<Pair<IStorage, IProject>>> cache = new SimpleCache((Function)new Function<URI, Iterable<Pair<IStorage, IProject>>>(){

        public Iterable<Pair<IStorage, IProject>> apply(URI uri) {
            if (uri.isPlatformResource()) {
                Path path = new Path(uri.toPlatformString(true));
                IFile file = Storage2UriMapperImpl.this.getWorkspaceRoot().getFile((IPath)path);
                if (Storage2UriMapperImpl.this.isValidStorageFor(uri, (IStorage)file)) {
                    return Collections.singleton(Tuples.create((Object)file, (Object)file.getProject()));
                }
            }
            return Collections.emptyList();
        }
    });

    public Storage2UriMapperImpl() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        this.resourceFactoryRegistry = new ResourceFactoryRegistryImpl((ResourceSet)resourceSet){
            private final /* synthetic */ ResourceSet val$resourceSet;
            {
                this.val$resourceSet = resourceSet;
            }

            protected URIConverter getURIConverter() {
                return this.val$resourceSet.getURIConverter();
            }

            protected Map<?, ?> getContentDescriptionOptions() {
                return this.val$resourceSet.getLoadOptions();
            }
        };
        this.resourceFactoryRegistry.getProtocolToFactoryMap().putAll(Resource.Factory.Registry.INSTANCE.getProtocolToFactoryMap());
        this.resourceFactoryRegistry.getExtensionToFactoryMap().putAll(Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap());
        this.resourceFactoryRegistry.getContentTypeToFactoryMap().putAll(Resource.Factory.Registry.INSTANCE.getContentTypeToFactoryMap());
        this.resourceFactoryRegistry.getExtensionToFactoryMap().remove("*");
        this.resourceFactoryRegistry.getContentTypeToFactoryMap().remove("*");
        resourceSet.setResourceFactoryRegistry((Resource.Factory.Registry)this.resourceFactoryRegistry);
    }

    @Override
    public Iterable<Pair<IStorage, IProject>> getStorages(URI uri) {
        return (Iterable)this.cache.get((Object)uri);
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    @Override
    public final URI getUri(IStorage storage) {
        URI uri = this.internalGetUri(storage);
        if (uri != null && this.isValidUri(uri, storage)) {
            return uri;
        }
        return null;
    }

    protected URI internalGetUri(IStorage storage) {
        if (storage instanceof IFile) {
            return URI.createPlatformResourceURI((String)storage.getFullPath().toString(), (boolean)true);
        }
        return null;
    }

    public boolean isValidUri(URI uri, IStorage storage) {
        boolean valid = this.uriValidator.isValid(uri, storage);
        return valid;
    }

    protected boolean isValidStorageFor(URI uri, IStorage storage) {
        return true;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.cache.clear();
    }
}

