/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntaxFilteredScope
implements IScope {
    private IScope parent;
    private Set<QualifiedName> values;

    public SyntaxFilteredScope(IScope parent, List<String> values) {
        this.parent = parent;
        this.values = new HashSet<QualifiedName>(){

            @Override
            public boolean contains(Object o) {
                if (o instanceof IEObjectDescription) {
                    return super.contains(((IEObjectDescription)o).getName());
                }
                return super.contains(o);
            }
        };
        for (String value : values) {
            this.values.add(QualifiedName.create((String)value));
        }
    }

    public IEObjectDescription getSingleElement(QualifiedName name) {
        if (this.values.contains(name)) {
            return this.parent.getSingleElement(name);
        }
        return null;
    }

    public Iterable<IEObjectDescription> getElements(QualifiedName name) {
        if (this.values.contains(name)) {
            return this.parent.getElements(name);
        }
        return Collections.emptyList();
    }

    public IEObjectDescription getSingleElement(EObject object) {
        return (IEObjectDescription)Iterables.getFirst(this.getElements(object), null);
    }

    public Iterable<IEObjectDescription> getElements(EObject object) {
        return Iterables.filter((Iterable)this.parent.getElements(object), (Predicate)Predicates.in(this.values));
    }

    public Iterable<IEObjectDescription> getAllElements() {
        return Iterables.concat((Iterable)Iterables.transform(this.values, (Function)new Function<QualifiedName, Iterable<IEObjectDescription>>(){

            public Iterable<IEObjectDescription> apply(QualifiedName input) {
                return SyntaxFilteredScope.this.parent.getElements(input);
            }
        }));
    }
}

