/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.contentassist;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.xtext.ui.TypeAwareReferenceProposalCreator;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.RepeatedContentAssistProcessor;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureNames;
import org.eclipse.xtext.xbase.scoping.batch.IIdentifiableElementDescription;
import org.eclipse.xtext.xbase.scoping.batch.SimpleIdentifiableElementDescription;
import org.eclipse.xtext.xbase.ui.contentassist.MultiNameDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XbaseReferenceProposalCreator
extends TypeAwareReferenceProposalCreator
implements RepeatedContentAssistProcessor.ModeAware {
    private int mode;
    @Inject
    private IQualifiedNameConverter nameConverter;

    public void reset() {
        this.mode = 0;
    }

    public void nextMode() {
        switch (this.mode) {
            case 0: 
            case 7: {
                this.mode = 8;
                return;
            }
            case 1: {
                this.mode = 2;
                return;
            }
            case 2: {
                this.mode = 4;
                return;
            }
            case 4: {
                this.mode = 7;
                return;
            }
            case 8: {
                this.mode = 1;
                return;
            }
        }
        throw new IllegalStateException("mode:" + this.mode);
    }

    public String getNextCategory() {
        switch (this.mode) {
            case 0: 
            case 7: {
                return "smart proposals";
            }
            case 1: {
                return "java-like proposals";
            }
            case 2: {
                return "type proposals";
            }
            case 4: {
                return "all proposals";
            }
            case 8: {
                return "shortest proposals";
            }
        }
        throw new IllegalStateException("mode:" + this.mode);
    }

    public boolean isLastMode() {
        return this.isShowAllProposals();
    }

    public boolean isShowTypeProposals() {
        return (this.mode & 4) != 0;
    }

    protected boolean isShowShortestSugar() {
        return (this.mode & 1) != 0;
    }

    protected boolean isShowJavaLikeProposals() {
        return (this.mode & 2) != 0;
    }

    protected boolean isShowAllProposals() {
        return this.mode == 7;
    }

    public boolean isShowSmartProposals() {
        return this.mode == 8;
    }

    public void lookupCrossReference(IScope scope, EObject model, EReference reference, ICompletionProposalAcceptor acceptor, Predicate<IEObjectDescription> filter, Function<IEObjectDescription, ICompletionProposal> proposalFactory) {
        if (TypesPackage.Literals.JVM_TYPE.isSuperTypeOf(this.getEReferenceType(model, reference)) && !this.isShowTypeProposals() && !this.isShowSmartProposals()) {
            return;
        }
        if (!(reference != XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE || this.isShowShortestSugar() || this.isShowJavaLikeProposals() || this.isShowSmartProposals())) {
            return;
        }
        super.lookupCrossReference(scope, model, reference, acceptor, filter, proposalFactory);
    }

    protected Function<IEObjectDescription, ICompletionProposal> getWrappedFactory(EObject model, EReference reference, final Function<IEObjectDescription, ICompletionProposal> proposalFactory) {
        if (!TypesPackage.Literals.JVM_TYPE.isSuperTypeOf(this.getEReferenceType(model, reference))) {
            return new Function<IEObjectDescription, ICompletionProposal>(){

                public ICompletionProposal apply(IEObjectDescription from) {
                    ICompletionProposal result = (ICompletionProposal)proposalFactory.apply((Object)from);
                    if (EcoreUtil2.isAssignableFrom((EClass)TypesPackage.Literals.JVM_FEATURE, (EClass)from.getEClass())) {
                        if (result instanceof ConfigurableCompletionProposal) {
                            EObject eObjectOrProxy = from.getEObjectOrProxy();
                            if (eObjectOrProxy.eIsProxy()) {
                                Image img = null;
                                if (EcoreUtil2.isAssignableFrom((EClass)TypesPackage.Literals.JVM_CONSTRUCTOR, (EClass)from.getEClass())) {
                                    img = XbaseReferenceProposalCreator.this.computeConstructorImage(false, false, 1, 512);
                                } else if (EcoreUtil2.isAssignableFrom((EClass)TypesPackage.Literals.JVM_OPERATION, (EClass)from.getEClass())) {
                                    img = XbaseReferenceProposalCreator.this.computeMethodImage(false, 1, 0);
                                } else if (EcoreUtil2.isAssignableFrom((EClass)TypesPackage.Literals.JVM_FIELD, (EClass)from.getEClass())) {
                                    img = XbaseReferenceProposalCreator.this.computeFieldImage(false, 1, 0);
                                }
                                if (img != null) {
                                    ((ConfigurableCompletionProposal)result).setImage(img);
                                }
                            } else {
                                ((ConfigurableCompletionProposal)result).setImage(XbaseReferenceProposalCreator.this.computeImage((JvmFeature)eObjectOrProxy));
                            }
                        }
                    } else if (from instanceof SimpleIdentifiableElementDescription && XbaseReferenceProposalCreator.this.isLocalVarOrFormalParameter(from) && result instanceof ConfigurableCompletionProposal) {
                        ((ConfigurableCompletionProposal)result).setImage(JavaPlugin.getImageDescriptorRegistry().get(JavaPluginImages.DESC_OBJS_LOCAL_VARIABLE));
                    }
                    return result;
                }
            };
        }
        return super.getWrappedFactory(model, reference, proposalFactory);
    }

    protected boolean isLocalVarOrFormalParameter(IEObjectDescription desc) {
        QualifiedName name = desc.getQualifiedName();
        return !name.equals((Object)IFeatureNames.THIS) && !name.equals((Object)IFeatureNames.SUPER);
    }

    public Iterable<IEObjectDescription> queryScope(IScope scope, EObject model, EReference reference, Predicate<IEObjectDescription> filter) {
        if (reference == XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE) {
            MultiNameDescriptions.Kind kind = this.isShowAllProposals() ? MultiNameDescriptions.Kind.All : (this.isShowShortestSugar() ? MultiNameDescriptions.Kind.Shortest : (this.isShowSmartProposals() ? MultiNameDescriptions.Kind.Smart : (this.isShowJavaLikeProposals() ? MultiNameDescriptions.Kind.Java : MultiNameDescriptions.Kind.All)));
            MultiNameDescriptions proposals = new MultiNameDescriptions(kind, this.nameConverter);
            Iterable allDescriptions = super.queryScope(scope, model, reference, filter);
            for (IEObjectDescription description : allDescriptions) {
                if (!filter.apply((Object)description)) continue;
                proposals.apply(description);
            }
            return proposals.getResult();
        }
        return super.queryScope(scope, model, reference, filter);
    }

    protected Image computeImage(JvmFeature feature) {
        int flags = 0;
        int decorator = 0;
        switch (feature.getVisibility()) {
            case PUBLIC: {
                flags = 1;
                break;
            }
            case PROTECTED: {
                flags = 4;
                break;
            }
            case PRIVATE: {
                flags = 2;
                break;
            }
            case DEFAULT: {
                flags = 0;
            }
        }
        JvmDeclaredType declaringType = feature.getDeclaringType();
        boolean interfaceOrAnnotation = false;
        if (declaringType instanceof JvmGenericType) {
            interfaceOrAnnotation = ((JvmGenericType)declaringType).isInterface();
        } else if (declaringType instanceof JvmAnnotationType) {
            interfaceOrAnnotation = true;
        }
        if (feature instanceof JvmConstructor) {
            decorator = 512;
            if (declaringType.isAbstract()) {
                flags |= 0x400;
                decorator |= 1;
            }
            return this.computeConstructorImage(declaringType.getDeclaringType() != null, interfaceOrAnnotation, flags, decorator);
        }
        if (feature instanceof JvmOperation) {
            JvmOperation operation = (JvmOperation)feature;
            if (operation.isStatic()) {
                flags |= 8;
                decorator |= 8;
            }
            if (operation.isAbstract()) {
                flags |= 0x400;
                decorator |= 1;
            }
            if (operation.isFinal()) {
                flags |= 0x10;
                decorator |= 2;
            }
            return this.computeMethodImage(interfaceOrAnnotation, flags, decorator);
        }
        if (feature instanceof JvmField) {
            JvmField field = (JvmField)feature;
            if (field.isStatic()) {
                flags |= 8;
                decorator |= 8;
            }
            if (field.isFinal()) {
                flags |= 0x10;
                decorator |= 2;
            }
            if (declaringType instanceof JvmEnumerationType) {
                flags |= 0x4000;
            }
            return this.computeFieldImage(interfaceOrAnnotation, flags, decorator);
        }
        return null;
    }

    protected Image computeMethodImage(boolean interfaceOrAnnotation, int modifiers, int decorator) {
        ImageDescriptor baseImage = JavaElementImageProvider.getMethodImageDescriptor((boolean)interfaceOrAnnotation, (int)modifiers);
        return JavaElementImageProvider.getDecoratedImage((ImageDescriptor)baseImage, (int)decorator, (Point)JavaElementImageProvider.BIG_SIZE);
    }

    protected Image computeConstructorImage(boolean inner, boolean interfaceOrAnnotation, int modifiers, int decorator) {
        ImageDescriptor baseImage = JavaElementImageProvider.getTypeImageDescriptor((boolean)inner, (boolean)interfaceOrAnnotation, (int)modifiers, (boolean)false);
        return JavaElementImageProvider.getDecoratedImage((ImageDescriptor)baseImage, (int)decorator, (Point)JavaElementImageProvider.BIG_SIZE);
    }

    protected Image computeFieldImage(boolean interfaceOrAnnotation, int modifiers, int decorator) {
        ImageDescriptor baseImage = JavaElementImageProvider.getFieldImageDescriptor((boolean)interfaceOrAnnotation, (int)modifiers);
        return JavaElementImageProvider.getDecoratedImage((ImageDescriptor)baseImage, (int)decorator, (Point)JavaElementImageProvider.BIG_SIZE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MultiNameDescriptions {
        private Kind kind;
        List<IEObjectDescription> others;
        Map<EObject, IEObjectDescription> descriptionsByEObject;
        IQualifiedNameConverter nameConverter;

        MultiNameDescriptions(Kind kind, IQualifiedNameConverter nameConverter) {
            this.kind = kind;
            this.nameConverter = nameConverter;
            this.others = Lists.newArrayList();
            this.descriptionsByEObject = Maps.newLinkedHashMap();
        }

        protected boolean isLongerThan(IIdentifiableElementDescription previous, IIdentifiableElementDescription next) {
            String previousName = this.nameConverter.toString(previous.getName());
            String candidateName = this.nameConverter.toString(next.getName());
            if (previousName.length() > candidateName.length()) {
                return true;
            }
            return previousName.length() == candidateName.length() && previous.getNumberOfParameters() >= 1;
        }

        protected void apply(IEObjectDescription description) {
            if (description instanceof IIdentifiableElementDescription) {
                IIdentifiableElementDescription featureDescription = (IIdentifiableElementDescription)description;
                this.kind.apply(featureDescription, this);
            } else {
                this.others.add((IEObjectDescription)new SimpleIdentifiableElementDescription(description));
            }
        }

        protected Iterable<IEObjectDescription> getResult() {
            if (!this.others.isEmpty()) {
                return Iterables.concat(this.others, this.descriptionsByEObject.values());
            }
            return Collections.unmodifiableCollection(this.descriptionsByEObject.values());
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum Kind {
            Shortest{

                protected void apply(IIdentifiableElementDescription featureDescription, MultiNameDescriptions result) {
                    EObject feature = featureDescription.getEObjectOrProxy();
                    IIdentifiableElementDescription previous = (IIdentifiableElementDescription)result.descriptionsByEObject.get(feature);
                    if (previous != null) {
                        String previousName = result.nameConverter.toString(previous.getName());
                        String candidateName = result.nameConverter.toString(featureDescription.getName());
                        if (previousName.length() > candidateName.length() || previousName.length() == candidateName.length() && previous.getNumberOfParameters() >= 1) {
                            result.descriptionsByEObject.put(feature, (IEObjectDescription)featureDescription);
                        }
                    } else {
                        result.descriptionsByEObject.put(feature, (IEObjectDescription)featureDescription);
                    }
                }
            }
            ,
            Smart{

                protected void apply(IIdentifiableElementDescription featureDescription, MultiNameDescriptions result) {
                    EObject feature = featureDescription.getEObjectOrProxy();
                    IEObjectDescription previous = result.descriptionsByEObject.get(feature);
                    if (previous != null) {
                        IIdentifiableElementDescription previousFeatureDescription = null;
                        MultiNameDescription multiNameDescription = null;
                        if (previous instanceof IIdentifiableElementDescription) {
                            previousFeatureDescription = (IIdentifiableElementDescription)previous;
                            multiNameDescription = new MultiNameDescription((IEObjectDescription)previousFeatureDescription);
                            result.descriptionsByEObject.put(feature, (IEObjectDescription)multiNameDescription);
                        } else if (previous instanceof MultiNameDescription) {
                            multiNameDescription = (MultiNameDescription)previous;
                            previousFeatureDescription = (IIdentifiableElementDescription)multiNameDescription.getDelegate();
                        } else {
                            throw new IllegalStateException(String.valueOf(previousFeatureDescription));
                        }
                        if (result.isLongerThan(previousFeatureDescription, featureDescription)) {
                            multiNameDescription.addOtherName(previousFeatureDescription.getName());
                            multiNameDescription.setDelegate((IEObjectDescription)featureDescription);
                        } else {
                            multiNameDescription.addOtherName(featureDescription.getName());
                        }
                    } else {
                        result.descriptionsByEObject.put(featureDescription.getEObjectOrProxy(), (IEObjectDescription)featureDescription);
                    }
                }
            }
            ,
            Java{

                protected void apply(IIdentifiableElementDescription featureDescription, MultiNameDescriptions result) {
                    JvmIdentifiableElement element = featureDescription.getElementOrProxy();
                    String firstSegment = featureDescription.getName().getFirstSegment();
                    if (element.getSimpleName().equals(firstSegment)) {
                        result.others.add((IEObjectDescription)featureDescription);
                    }
                }
            }
            ,
            All{

                protected void apply(IIdentifiableElementDescription featureDescription, MultiNameDescriptions result) {
                    result.others.add((IEObjectDescription)featureDescription);
                }
            };


            protected abstract void apply(IIdentifiableElementDescription var1, MultiNameDescriptions var2);
        }
    }
}

