/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.templates;

import com.google.inject.Inject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.IProposalConflictHelper;
import org.eclipse.xtext.ui.editor.contentassist.ITemplateAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.ITemplateProposalProvider;
import org.eclipse.xtext.ui.editor.templates.XtextTemplateContext;
import org.eclipse.xtext.ui.editor.templates.XtextTemplateProposal;

public abstract class AbstractTemplateProposalProvider
implements ITemplateProposalProvider {
    private IScopeProvider scopeProvider;
    @Inject
    private IProposalConflictHelper proposalConflictHelper;

    @Inject
    public void setScopeProvider(IScopeProvider scopeProvider) {
        this.scopeProvider = scopeProvider;
    }

    protected IScopeProvider getScopeProvider() {
        return this.scopeProvider;
    }

    public void createTemplates(ContentAssistContext context, ITemplateAcceptor acceptor) {
        if (!acceptor.canAcceptMoreTemplates()) {
            return;
        }
        TemplateContext[] templateContexts = this.createTemplateContexts(context);
        if (templateContexts == null || templateContexts.length == 0) {
            return;
        }
        NullSafeTemplateAcceptor nullSafe = new NullSafeTemplateAcceptor(acceptor);
        TemplateContext[] templateContextArray = templateContexts;
        int n = templateContexts.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateContext templateContext = templateContextArray[n2];
            if (!nullSafe.canAcceptMoreTemplates()) {
                return;
            }
            templateContext.setVariable("selection", context.getSelectedText());
            this.createTemplates(templateContext, context, nullSafe);
            ++n2;
        }
    }

    protected abstract void createTemplates(TemplateContext var1, ContentAssistContext var2, ITemplateAcceptor var3);

    protected TemplateProposal createProposal(Template template, TemplateContext templateContext, ContentAssistContext context, Image image, int relevance) {
        if (!this.validate(template, context)) {
            return null;
        }
        return this.doCreateProposal(template, templateContext, context, image, relevance);
    }

    protected TemplateProposal doCreateProposal(Template template, TemplateContext templateContext, ContentAssistContext context, Image image, int relevance) {
        return new XtextTemplateProposal(template, templateContext, (IRegion)context.getReplaceRegion(), image, relevance);
    }

    protected boolean validate(Template template, ContentAssistContext context) {
        boolean result = context.getMatcher().isCandidateMatchingPrefix(template.getName(), context.getPrefix());
        if (result) {
            try {
                String pattern = template.getPattern();
                if (this.proposalConflictHelper.existsConflict(pattern, context)) {
                    result = false;
                }
            }
            catch (Exception e) {
                result = false;
            }
        }
        return result;
    }

    protected boolean validate(Template template, TemplateContext context) {
        try {
            context.getContextType().validate(template.getPattern());
        }
        catch (TemplateException e) {
            return false;
        }
        if (context instanceof XtextTemplateContext) {
            try {
                ((XtextTemplateContext)context).evaluateForDisplay(template);
                return context.canEvaluate(template);
            }
            catch (BadLocationException e) {
                return false;
            }
            catch (TemplateException e) {
                return false;
            }
        }
        return true;
    }

    protected TemplateContext[] createTemplateContexts(ContentAssistContext context) {
        TemplateContextType[] contextTypes = this.getContextTypes(context);
        if (contextTypes != null && contextTypes.length != 0) {
            TemplateContext[] result = new TemplateContext[contextTypes.length];
            int i = 0;
            while (i < contextTypes.length) {
                result[i] = this.doCreateTemplateContext(contextTypes[i], context);
                ++i;
            }
            return result;
        }
        return null;
    }

    protected TemplateContext doCreateTemplateContext(TemplateContextType contextType, ContentAssistContext context) {
        return new XtextTemplateContext(contextType, context.getDocument(), new Position(context.getReplaceRegion().getOffset(), context.getReplaceRegion().getLength()), context, this.getScopeProvider());
    }

    protected abstract TemplateContextType[] getContextTypes(ContentAssistContext var1);

    public static class NullSafeTemplateAcceptor
    extends ITemplateAcceptor.Delegate {
        public NullSafeTemplateAcceptor(ITemplateAcceptor delegate) {
            this.setDelegate(delegate);
        }

        public void accept(TemplateProposal template) {
            if (template != null) {
                super.accept(template);
            }
        }
    }
}

