/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.syntaxcoloring;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightingConfiguration;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightingConfigurationAcceptor;
import org.eclipse.xtext.ui.editor.syntaxcoloring.ITextAttributeProvider;
import org.eclipse.xtext.ui.editor.syntaxcoloring.PreferenceStoreAccessor;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.ui.editor.utils.TextStyle;
import org.eclipse.xtext.util.Strings;

@Singleton
public class TextAttributeProvider
implements ITextAttributeProvider,
IHighlightingConfigurationAcceptor,
IPropertyChangeListener {
    private final PreferenceStoreAccessor preferencesAccessor;
    private final HashMap<String, TextAttribute> attributes;
    private final IHighlightingConfiguration highlightingConfig;

    @Inject
    public TextAttributeProvider(IHighlightingConfiguration highlightingConfig, IPreferenceStoreAccess preferenceStoreAccess, PreferenceStoreAccessor prefStoreAccessor) {
        this.highlightingConfig = highlightingConfig;
        this.preferencesAccessor = prefStoreAccessor;
        this.attributes = new HashMap();
        preferenceStoreAccess.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.initialize();
    }

    private void initialize() {
        this.attributes.clear();
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    TextAttributeProvider.this.highlightingConfig.configure(TextAttributeProvider.this);
                }
            });
        } else {
            this.highlightingConfig.configure(this);
        }
    }

    public TextAttribute getAttribute(String id) {
        return this.attributes.get(id);
    }

    public TextAttribute getMergedAttributes(String[] ids) {
        if (ids.length < 2) {
            throw new IllegalStateException();
        }
        String mergedIds = this.getMergedIds(ids);
        TextAttribute result = this.getAttribute(mergedIds);
        if (result == null) {
            String[] stringArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                result = this.merge(result, this.getAttribute(id));
                ++n2;
            }
            if (result != null) {
                this.attributes.put(mergedIds, result);
            } else {
                this.attributes.remove(mergedIds);
            }
        }
        return result;
    }

    private TextAttribute merge(TextAttribute first, TextAttribute second) {
        Font font;
        Color bgColor;
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        int style = first.getStyle() | second.getStyle();
        Color fgColor = second.getForeground();
        if (fgColor == null) {
            fgColor = first.getForeground();
        }
        if ((bgColor = second.getBackground()) == null) {
            bgColor = first.getBackground();
        }
        if ((font = second.getFont()) == null) {
            font = first.getFont();
        }
        return new TextAttribute(fgColor, bgColor, style, font);
    }

    public String getMergedIds(String[] ids) {
        return "$$$Merged:" + Strings.concat((String)"/", Arrays.asList(ids)) + "$$$";
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.initialize();
    }

    public void acceptDefaultHighlighting(String id, String name, TextStyle style) {
        if (this.attributes.put(id, this.createTextAttribute(id, style)) != null) {
            throw new IllegalStateException("Id '" + id + "' has been used twice.");
        }
    }

    protected TextAttribute createTextAttribute(String id, TextStyle defaultTextStyle) {
        TextStyle textStyle = new TextStyle();
        this.preferencesAccessor.populateTextStyle(id, textStyle, defaultTextStyle);
        int style = textStyle.getStyle();
        Font fontFromFontData = EditorUtils.fontFromFontData(textStyle.getFontData());
        return new TextAttribute(EditorUtils.colorFromRGB(textStyle.getColor()), EditorUtils.colorFromRGB(textStyle.getBackgroundColor()), style, fontFromFontData);
    }
}

