/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.junit.editor.contentassist;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.ISetup;
import org.eclipse.xtext.junit.AbstractXtextTests;
import org.eclipse.xtext.junit.util.ResourceLoadHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.ui.editor.XtextSourceViewerConfiguration;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ReplacementTextApplier;
import org.eclipse.xtext.ui.editor.model.DocumentPartitioner;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.junit.editor.contentassist.MockableSelectionProvider;
import org.eclipse.xtext.ui.junit.editor.contentassist.MockableTextViewer;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentAssistProcessorTestBuilder
implements Cloneable {
    private String model;
    private int cursorPosition;
    private Injector injector;
    private final ResourceLoadHelper loadHelper;

    public ContentAssistProcessorTestBuilder(ISetup setupClazz, AbstractXtextTests tests) throws Exception {
        tests.with(setupClazz);
        this.injector = tests.getInjector();
        this.loadHelper = tests;
    }

    public ContentAssistProcessorTestBuilder(Injector injector, ResourceLoadHelper helper) throws Exception {
        this.injector = injector;
        this.loadHelper = helper;
    }

    public ContentAssistProcessorTestBuilder reset() throws Exception {
        return this.clone("", 0);
    }

    public ContentAssistProcessorTestBuilder append(String model) throws Exception {
        return this.clone(String.valueOf(this.getModel()) + model, this.cursorPosition + model.length());
    }

    public ContentAssistProcessorTestBuilder appendNl(String model) throws Exception {
        return this.append(model).append(Strings.newLine());
    }

    public ContentAssistProcessorTestBuilder insert(String model, int cursorPosition) throws Exception {
        StringBuilder builder = new StringBuilder(this.getModel()).insert(cursorPosition, model);
        return this.clone(builder.toString(), cursorPosition + model.length());
    }

    public ContentAssistProcessorTestBuilder cursorBack(int times) throws Exception {
        return this.clone(this.model, this.cursorPosition -= times);
    }

    public ContentAssistProcessorTestBuilder applyText() throws Exception {
        return this.applyText(0, true);
    }

    public ContentAssistProcessorTestBuilder applyText(boolean appendSpace) throws Exception {
        return this.applyText(0, appendSpace);
    }

    public ContentAssistProcessorTestBuilder applyText(int index, boolean appendSpace) throws Exception {
        ICompletionProposal proposal = this.computeCompletionProposals(this.getModel(), this.cursorPosition)[index];
        String text = proposal.getDisplayString();
        if (proposal instanceof ConfigurableCompletionProposal) {
            text = ((ConfigurableCompletionProposal)proposal).getReplacementString();
        }
        ContentAssistProcessorTestBuilder ret = this.append(text);
        if (appendSpace) {
            return ret.append(" ");
        }
        return ret;
    }

    public ContentAssistProcessorTestBuilder assertCount(int completionProposalCount) throws Exception {
        return this.assertCountAtCursorPosition(completionProposalCount, this.cursorPosition);
    }

    public ContentAssistProcessorTestBuilder assertText(String ... expectedText) throws Exception {
        return this.assertTextAtCursorPosition(this.cursorPosition, expectedText);
    }

    public ContentAssistProcessorTestBuilder assertTextAtCursorPosition(String cursorPosition, String ... expectedText) throws Exception {
        return this.assertTextAtCursorPosition(this.getModel().indexOf(cursorPosition), expectedText);
    }

    public ContentAssistProcessorTestBuilder assertTextAtCursorPosition(String cursorPosition, int offset, String ... expectedText) throws Exception {
        return this.assertTextAtCursorPosition(this.getModel().indexOf(cursorPosition) + offset, expectedText);
    }

    public ContentAssistProcessorTestBuilder assertTextAtCursorPosition(int cursorPosition, String ... expectedText) throws Exception {
        String currentModelToParse = this.getModel();
        ICompletionProposal[] computeCompletionProposals = this.computeCompletionProposals(currentModelToParse, cursorPosition);
        if (computeCompletionProposals == null) {
            computeCompletionProposals = new ICompletionProposal[]{};
        }
        Arrays.sort(expectedText);
        String expectation = Strings.concat((String)", ", Arrays.asList(expectedText));
        String actual = Strings.concat((String)", ", this.toString(computeCompletionProposals));
        Assert.assertEquals((String)expectation, (String)actual);
        int i = 0;
        while (i < computeCompletionProposals.length) {
            ICompletionProposal completionProposal = computeCompletionProposals[i];
            String proposedText = completionProposal.getDisplayString();
            if (completionProposal instanceof ConfigurableCompletionProposal) {
                ConfigurableCompletionProposal configurableProposal = (ConfigurableCompletionProposal)completionProposal;
                proposedText = configurableProposal.getReplacementString();
                if (configurableProposal.getTextApplier() instanceof ReplacementTextApplier) {
                    proposedText = ((ReplacementTextApplier)configurableProposal.getTextApplier()).getActualReplacementString(configurableProposal);
                }
            }
            Assert.assertTrue((String)("Missing proposal '" + proposedText + "'. Expect completionProposal text '" + expectation + "', but got " + actual), (boolean)Arrays.asList(expectedText).contains(proposedText));
            ++i;
        }
        return this;
    }

    public ContentAssistProcessorTestBuilder assertMatchString(String matchString) throws Exception {
        String contentType;
        ISourceViewer sourceViewer;
        String currentModelToParse = this.getModel();
        XtextResource xtextResource = this.loadHelper.getResourceFor((InputStream)new StringInputStream(currentModelToParse));
        IXtextDocument xtextDocument = this.getDocument(xtextResource, currentModelToParse);
        XtextSourceViewerConfiguration configuration = this.get(XtextSourceViewerConfiguration.class);
        IContentAssistant contentAssistant = configuration.getContentAssistant(sourceViewer = this.getSourceViewer(xtextDocument, configuration));
        if (contentAssistant.getContentAssistProcessor(contentType = xtextDocument.getContentType(currentModelToParse.length())) != null) {
            ContentAssistContext[] contexts;
            ContentAssistContext.Factory factory = this.get(ContentAssistContext.Factory.class);
            ContentAssistContext[] contentAssistContextArray = contexts = factory.create((ITextViewer)sourceViewer, currentModelToParse.length(), xtextResource);
            int n = contexts.length;
            int n2 = 0;
            while (n2 < n) {
                ContentAssistContext context = contentAssistContextArray[n2];
                Assert.assertTrue((String)("matchString = '" + matchString + "', actual: '" + context.getPrefix() + "'"), ("".equals(context.getPrefix()) || matchString.equals(context.getPrefix()) ? 1 : 0) != 0);
                ++n2;
            }
        } else {
            Assert.fail((String)("No content assistant for content type " + contentType));
        }
        return this;
    }

    protected String getModel() {
        return this.model == null ? "" : this.model;
    }

    public List<String> toString(ICompletionProposal[] proposals) {
        if (proposals == null) {
            return Collections.emptyList();
        }
        ArrayList<String> res = new ArrayList<String>(proposals.length);
        ICompletionProposal[] iCompletionProposalArray = proposals;
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionProposal proposal = iCompletionProposalArray[n2];
            String proposedText = proposal.getDisplayString();
            if (proposal instanceof ConfigurableCompletionProposal) {
                ConfigurableCompletionProposal configurableProposal = (ConfigurableCompletionProposal)proposal;
                proposedText = configurableProposal.getReplacementString();
                if (configurableProposal.getTextApplier() instanceof ReplacementTextApplier) {
                    proposedText = ((ReplacementTextApplier)configurableProposal.getTextApplier()).getActualReplacementString(configurableProposal);
                }
            }
            res.add(proposedText);
            ++n2;
        }
        Collections.sort(res);
        return res;
    }

    public ContentAssistProcessorTestBuilder assertCountAtCursorPosition(int completionProposalCount, int cursorPosition) throws Exception {
        String currentModelToParse = this.getModel();
        ICompletionProposal[] computeCompletionProposals = this.computeCompletionProposals(currentModelToParse, cursorPosition);
        StringBuffer computedProposals = new StringBuffer();
        int i = 0;
        while (i < computeCompletionProposals.length) {
            computedProposals.append(computeCompletionProposals[i].getDisplayString());
            if (i < computeCompletionProposals.length - 1) {
                computedProposals.append(",");
            }
            ++i;
        }
        Assert.assertEquals((String)("expect only " + completionProposalCount + " CompletionProposal item for model '" + currentModelToParse + "' but got '" + computedProposals + "'"), (int)completionProposalCount, (int)computeCompletionProposals.length);
        return this;
    }

    public ICompletionProposal[] computeCompletionProposals(String currentModelToParse, int cursorPosition) throws Exception {
        String contentType;
        ISourceViewer sourceViewer;
        XtextResource xtextResource = this.loadHelper.getResourceFor((InputStream)new StringInputStream(currentModelToParse));
        IXtextDocument xtextDocument = this.getDocument(xtextResource, currentModelToParse);
        XtextSourceViewerConfiguration configuration = this.get(XtextSourceViewerConfiguration.class);
        IContentAssistant contentAssistant = configuration.getContentAssistant(sourceViewer = this.getSourceViewer(xtextDocument, configuration));
        IContentAssistProcessor processor = contentAssistant.getContentAssistProcessor(contentType = xtextDocument.getContentType(cursorPosition));
        if (processor != null) {
            return processor.computeCompletionProposals((ITextViewer)sourceViewer, cursorPosition);
        }
        return new ICompletionProposal[0];
    }

    protected ISourceViewer getSourceViewer(IXtextDocument xtextDocument, XtextSourceViewerConfiguration configuration) {
        XtextSourceViewer.Factory factory = this.get(XtextSourceViewer.Factory.class);
        XtextSourceViewer sourceViewer = factory.createSourceViewer((Composite)new Shell(), null, null, false, 0);
        sourceViewer.configure((SourceViewerConfiguration)configuration);
        sourceViewer.setDocument((IDocument)xtextDocument);
        return sourceViewer;
    }

    public ICompletionProposal[] computeCompletionProposals(int cursorPosition) throws Exception {
        return this.computeCompletionProposals(this.getModel(), cursorPosition);
    }

    public ICompletionProposal[] computeCompletionProposals(String cursorPosition) throws Exception {
        return this.computeCompletionProposals(this.getModel(), this.getModel().indexOf(cursorPosition));
    }

    public ICompletionProposal[] computeCompletionProposals() throws Exception {
        return this.computeCompletionProposals(this.getModel(), this.cursorPosition);
    }

    public String toString() {
        return String.valueOf(this.getModel()) + "\n length: " + this.getModel().length() + "\n cursor at: " + this.cursorPosition;
    }

    public IXtextDocument getDocument(XtextResource xtextResource, String model) {
        XtextDocument document = this.get(XtextDocument.class);
        document.set(model);
        document.setInput(xtextResource);
        DocumentPartitioner partitioner = this.get(DocumentPartitioner.class);
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        return document;
    }

    public ITextViewer getSourceViewer(String currentModelToParse, final IXtextDocument xtextDocument) {
        MockableTextViewer result = new MockableTextViewer(){

            public IDocument getDocument() {
                return xtextDocument;
            }

            public ISelectionProvider getSelectionProvider() {
                return new MockableSelectionProvider(){

                    public ISelection getSelection() {
                        return TextSelection.emptySelection();
                    }
                };
            }

            public StyledText getTextWidget() {
                return null;
            }
        };
        return result;
    }

    protected ContentAssistProcessorTestBuilder clone(String model, int offset) throws Exception {
        ContentAssistProcessorTestBuilder builder = (ContentAssistProcessorTestBuilder)this.clone();
        builder.model = model;
        builder.cursorPosition = offset;
        return builder;
    }

    public <T> T get(Class<T> clazz) {
        return (T)this.injector.getInstance(clazz);
    }

    protected int getCursorPosition() {
        return this.cursorPosition;
    }

    public static class Factory {
        private Injector injector;

        @Inject
        public Factory(Injector injector) {
            this.injector = injector;
        }

        public ContentAssistProcessorTestBuilder create(ResourceLoadHelper resourceLoadHelper) throws Exception {
            return new ContentAssistProcessorTestBuilder(this.injector, resourceLoadHelper);
        }
    }
}

