/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.contentassist.antlr;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Set;
import org.antlr.runtime.BaseRecognizer;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.antlr.IUnorderedGroupHelper;
import org.eclipse.xtext.ui.editor.contentassist.antlr.AbstractContentAssistParser;
import org.eclipse.xtext.ui.editor.contentassist.antlr.EntryPointFinder;
import org.eclipse.xtext.ui.editor.contentassist.antlr.FollowElement;
import org.eclipse.xtext.ui.editor.contentassist.antlr.IPartialContentAssistParser;
import org.eclipse.xtext.ui.editor.contentassist.antlr.ObservableXtextTokenStream;
import org.eclipse.xtext.ui.editor.contentassist.antlr.internal.AbstractInternalContentAssistParser;
import org.eclipse.xtext.ui.editor.contentassist.antlr.internal.InfiniteRecursion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPartialContentAssistParser
extends AbstractContentAssistParser
implements IPartialContentAssistParser {
    @Inject
    private EntryPointFinder entryPointFinder;

    @Override
    public Collection<FollowElement> getFollowElements(IParseResult parseResult, int offset, boolean strict) {
        ICompositeNode entryPoint = this.entryPointFinder.findEntryPoint(parseResult, offset);
        if (entryPoint != null) {
            String parseMe = this.getTextToParse(parseResult, entryPoint, offset);
            TokenSource tokenSource = this.createTokenSource(parseMe);
            AbstractInternalContentAssistParser parser = this.createParser();
            parser.setStrict(strict);
            ObservableXtextTokenStream tokens = new ObservableXtextTokenStream(tokenSource, parser);
            tokens.setInitialHiddenTokens(this.getInitialHiddenTokens());
            parser.setTokenStream((TokenStream)tokens);
            IUnorderedGroupHelper helper = (IUnorderedGroupHelper)this.getUnorderedGroupHelper().get();
            parser.setUnorderedGroupHelper(helper);
            helper.initializeWith((BaseRecognizer)parser);
            tokens.setListener(parser);
            try {
                Collection<FollowElement> followElements = this.getFollowElements(parser, this.getEntryGrammarElement(entryPoint));
                return Lists.newArrayList(followElements);
            }
            catch (InfiniteRecursion infinite) {
                return Lists.newArrayList(parser.getFollowElements());
            }
        }
        String text = parseResult.getRootNode().getText();
        String parseMe = text.substring(0, offset);
        Collection<FollowElement> followElements = this.getFollowElements(parseMe, strict);
        return followElements;
    }

    protected AbstractElement getEntryGrammarElement(ICompositeNode entryPoint) {
        AbstractElement result;
        EObject grammarElement = entryPoint.getGrammarElement();
        if (grammarElement instanceof RuleCall) {
            AbstractRule rule = ((RuleCall)grammarElement).getRule();
            if (rule instanceof ParserRule && !GrammarUtil.isMultipleCardinality((AbstractElement)rule.getAlternatives())) {
                grammarElement = rule.getAlternatives();
            }
        } else if (grammarElement instanceof ParserRule) {
            grammarElement = ((ParserRule)grammarElement).getAlternatives();
        }
        if ((result = (AbstractElement)grammarElement) instanceof Action) {
            return this.getEntryGrammarElement((ICompositeNode)entryPoint.getFirstChild());
        }
        return result;
    }

    protected String getTextToParse(IParseResult parseResult, ICompositeNode entryPoint, int offset) {
        StringBuilder result = new StringBuilder(offset - entryPoint.getTotalOffset());
        this.appendTextToParse(entryPoint, offset, false, result);
        return result.toString();
    }

    protected boolean appendTextToParse(ICompositeNode node, int offset, boolean skipOptional, StringBuilder result) {
        for (INode child : node.getChildren()) {
            if (child instanceof ILeafNode) {
                String text = child.getText();
                if (child.getTotalEndOffset() >= offset) {
                    String sub = text.substring(0, offset - child.getTotalOffset());
                    result.append(sub);
                    return true;
                }
                result.append(text);
                continue;
            }
            if (!skipOptional) {
                if (!this.appendTextToParse((ICompositeNode)child, offset, skipOptional || child.getTotalEndOffset() < offset, result)) continue;
                return true;
            }
            String skippedAs = this.getReplacement((ICompositeNode)child);
            if (skippedAs != null) {
                result.append(skippedAs);
                continue;
            }
            if (!this.appendTextToParse((ICompositeNode)child, offset, skipOptional || child.getTotalEndOffset() < offset, result)) continue;
            return true;
        }
        return false;
    }

    protected String getReplacement(ICompositeNode node) {
        return null;
    }

    protected Collection<FollowElement> getFollowElements(AbstractInternalContentAssistParser parser, AbstractElement entryPoint) {
        RuleCall call;
        AbstractRule rule;
        String ruleName = this.getRuleName(entryPoint);
        if (ruleName == null && entryPoint instanceof RuleCall && (rule = (call = (RuleCall)entryPoint).getRule()) instanceof ParserRule) {
            ruleName = "rule" + rule.getName();
        }
        if (ruleName == null) {
            throw new IllegalStateException("entryPoint: " + entryPoint);
        }
        try {
            Method method = parser.getClass().getMethod(ruleName, new Class[0]);
            method.setAccessible(true);
            try {
                method.invoke((Object)parser, new Object[0]);
            }
            catch (InvocationTargetException targetException) {
                if (targetException.getCause() instanceof InfiniteRecursion) {
                    throw (InfiniteRecursion)targetException.getCause();
                }
                throw new RuntimeException(targetException);
            }
            Set<FollowElement> result = parser.getFollowElements();
            return result;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Collection<FollowElement> getFollowElements(String input, boolean strict) {
        TokenSource tokenSource = this.createTokenSource(input);
        AbstractInternalContentAssistParser parser = this.createParser();
        parser.setStrict(strict);
        ObservableXtextTokenStream tokens = new ObservableXtextTokenStream(tokenSource, parser);
        tokens.setInitialHiddenTokens(this.getInitialHiddenTokens());
        parser.setTokenStream((TokenStream)tokens);
        IUnorderedGroupHelper helper = (IUnorderedGroupHelper)this.getUnorderedGroupHelper().get();
        parser.setUnorderedGroupHelper(helper);
        helper.initializeWith((BaseRecognizer)parser);
        tokens.setListener(parser);
        try {
            return Lists.newArrayList(this.getFollowElements(parser));
        }
        catch (InfiniteRecursion infinite) {
            return Lists.newArrayList(parser.getFollowElements());
        }
    }
}

