/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.tasks.preferences;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.xtext.tasks.PreferenceTaskTagProvider;
import org.eclipse.xtext.tasks.Priority;
import org.eclipse.xtext.tasks.TaskTag;
import org.eclipse.xtext.ui.editor.tasks.dialogfields.DialogField;
import org.eclipse.xtext.ui.editor.tasks.dialogfields.IDialogFieldListener;
import org.eclipse.xtext.ui.editor.tasks.dialogfields.IListAdapter;
import org.eclipse.xtext.ui.editor.tasks.dialogfields.ListDialogField;
import org.eclipse.xtext.ui.editor.tasks.dialogfields.SelectionButtonDialogField;
import org.eclipse.xtext.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.xtext.ui.tasks.preferences.PreferencesMessages;
import org.eclipse.xtext.ui.tasks.preferences.TaskTagInputDialog;

public class TaskTagConfigurationBlock
extends OptionsConfigurationBlock {
    private static final int IDX_ADD = 0;
    private static final int IDX_EDIT = 1;
    private static final int IDX_REMOVE = 2;
    private ListDialogField taskTags;
    private SelectionButtonDialogField caseSensitiveCheckBox;
    private String languageName;

    public TaskTagConfigurationBlock(IProject project, IPreferenceStore preferenceStore, IWorkbenchPreferenceContainer container, String languageName) {
        super(project, preferenceStore, container);
        this.languageName = languageName;
        this.registerKey(this.getTasksCaseSensitiveKey());
        this.registerKey(this.getTaskTagsKey());
        this.registerKey(this.getTaskPrioritiesKey());
        TaskTagListAdapter adapter = new TaskTagListAdapter();
        String[] buttons = new String[]{PreferencesMessages.TaskTagConfigurationBlock_markers_tasks_add_button, PreferencesMessages.TaskTagConfigurationBlock_markers_tasks_edit_button, PreferencesMessages.TaskTagConfigurationBlock_markers_tasks_remove_button};
        this.taskTags = new ListDialogField(adapter, buttons, (ILabelProvider)new TaskTagLabelProvider());
        this.taskTags.setDialogFieldListener(adapter);
        this.taskTags.setRemoveButtonIndex(2);
        String[] columnsHeaders = new String[]{PreferencesMessages.TaskTagConfigurationBlock_markers_tasks_name_column, PreferencesMessages.TaskTagConfigurationBlock_markers_tasks_priority_column};
        this.taskTags.setTableColumns(new ListDialogField.ColumnsDescription(columnsHeaders, true));
        this.taskTags.setViewerComparator(new TaskTagSorter());
        this.caseSensitiveCheckBox = new SelectionButtonDialogField(32);
        this.caseSensitiveCheckBox.setLabelText(PreferencesMessages.TaskTagConfigurationBlock_casesensitive_label);
        this.caseSensitiveCheckBox.setDialogFieldListener(adapter);
        this.unpackTaskTags();
        if (this.taskTags.getSize() > 0) {
            this.taskTags.selectFirstElement();
        } else {
            this.taskTags.enableButton(1, false);
        }
    }

    protected Control doCreateContents(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        PixelConverter conv = new PixelConverter((Control)parent);
        Composite markersComposite = new Composite(parent, 0);
        markersComposite.setLayout((Layout)layout);
        markersComposite.setFont(parent.getFont());
        GridData data = new GridData(1808);
        data.widthHint = conv.convertWidthInCharsToPixels(50);
        Control listControl = this.taskTags.getListControl(markersComposite);
        listControl.setLayoutData((Object)data);
        Composite buttonsControl = this.taskTags.getButtonBox(markersComposite);
        buttonsControl.setLayoutData((Object)new GridData(258));
        this.caseSensitiveCheckBox.doFillIntoGrid(markersComposite, 2);
        return markersComposite;
    }

    public void setEnabled(boolean isEnabled) {
        this.taskTags.setEnabled(isEnabled);
        this.caseSensitiveCheckBox.setEnabled(isEnabled);
    }

    protected final void updateModel(DialogField field) {
        if (field == this.taskTags) {
            List list = this.taskTags.getElements();
            this.setValue(this.getTaskTagsKey(), PreferenceTaskTagProvider.serializeTags((List)list));
            this.setValue(this.getTaskPrioritiesKey(), PreferenceTaskTagProvider.serializePriorities((List)list));
        } else if (field == this.caseSensitiveCheckBox) {
            String state = this.caseSensitiveCheckBox.isSelected() ? "true" : "false";
            this.setValue(this.getTasksCaseSensitiveKey(), state);
        }
    }

    private String getTasksCaseSensitiveKey() {
        return PreferenceTaskTagProvider.CASE_SENSITIVE_KEY.getId();
    }

    private String getTaskPrioritiesKey() {
        return PreferenceTaskTagProvider.PRIORITIES_KEY.getId();
    }

    private String getTaskTagsKey() {
        return PreferenceTaskTagProvider.TAGS_KEY.getId();
    }

    protected void updateControls() {
        super.updateControls();
        this.unpackTaskTags();
    }

    private void unpackTaskTags() {
        String rawTags = this.getValue(this.getTaskTagsKey());
        String rawPrios = this.getValue(this.getTaskPrioritiesKey());
        this.taskTags.setElements(PreferenceTaskTagProvider.parseTags((String)rawTags, (String)rawPrios));
        boolean isCaseSensitive = "true".equals(this.getValue(this.getTasksCaseSensitiveKey()));
        this.caseSensitiveCheckBox.setSelection(isCaseSensitive);
    }

    private void taskTagButtonPressed(int index) {
        TaskTagInputDialog dialog;
        TaskTag edited = null;
        if (index != 0) {
            edited = (TaskTag)this.taskTags.getSelectedElements().get(0);
        }
        if ((index == 0 || index == 1) && (dialog = new TaskTagInputDialog(this.getShell(), edited, this.taskTags.getElements(), this.languageName)).open() == 0) {
            if (edited != null) {
                this.taskTags.replaceElement(edited, dialog.getResult());
            } else {
                this.taskTags.addElement(dialog.getResult());
            }
        }
    }

    protected void validateSettings(String changedKey, String oldValue, String newValue) {
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        String title = PreferencesMessages.TaskTagConfigurationBlock_needsbuild_title;
        String message = this.getProject() == null ? PreferencesMessages.TaskTagConfigurationBlock_needsfullbuild_message : PreferencesMessages.TaskTagConfigurationBlock_needsprojectbuild_message;
        return new String[]{title, message};
    }

    protected Job getBuildJob(IProject project) {
        OptionsConfigurationBlock.BuildJob buildJob = new OptionsConfigurationBlock.BuildJob("Rebuild", project);
        buildJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        buildJob.setUser(true);
        return buildJob;
    }

    private class TaskTagLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider {
        private TaskTagLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            TaskTag task = (TaskTag)element;
            if (columnIndex == 0) {
                return task.getName();
            }
            if (Priority.HIGH == task.getPriority()) {
                return PreferencesMessages.TaskTagConfigurationBlock_markers_tasks_high_priority;
            }
            if (Priority.NORMAL == task.getPriority()) {
                return PreferencesMessages.TaskTagConfigurationBlock_markers_tasks_normal_priority;
            }
            if (Priority.LOW == task.getPriority()) {
                return PreferencesMessages.TaskTagConfigurationBlock_markers_tasks_low_priority;
            }
            return "";
        }

        public Font getFont(Object element) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TaskTagListAdapter
    implements IListAdapter,
    IDialogFieldListener {
        private TaskTagListAdapter() {
        }

        private boolean canEdit(List<TaskTag> selectedElements) {
            return selectedElements.size() == 1;
        }

        @Override
        public void customButtonPressed(ListDialogField field, int index) {
            TaskTagConfigurationBlock.this.taskTagButtonPressed(index);
        }

        @Override
        public void selectionChanged(ListDialogField field) {
            List selectedElements = field.getSelectedElements();
            field.enableButton(1, this.canEdit(selectedElements));
        }

        @Override
        public void doubleClicked(ListDialogField field) {
            if (this.canEdit(field.getSelectedElements())) {
                TaskTagConfigurationBlock.this.taskTagButtonPressed(1);
            }
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            TaskTagConfigurationBlock.this.updateModel(field);
        }
    }

    private static class TaskTagSorter
    extends ViewerComparator {
        private TaskTagSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return this.getComparator().compare(((TaskTag)e1).getName(), ((TaskTag)e2).getName());
        }
    }
}

