/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.EObjectDiagnosticImpl;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureNames;
import org.eclipse.xtext.xbase.scoping.batch.IIdentifiableElementDescription;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;
import org.eclipse.xtext.xbase.typesystem.arguments.IFeatureCallArgumentSlot;
import org.eclipse.xtext.xbase.typesystem.computation.IFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ILinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractPendingLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.AmbiguousFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.CandidateCompareResult;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.FeatureLinkHelper;
import org.eclipse.xtext.xbase.typesystem.internal.ImplicitFirstArgument;
import org.eclipse.xtext.xbase.typesystem.internal.ImplicitReceiver;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.SuspiciouslyOverloadedCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.TypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.util.FeatureKinds;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.typesystem.util.DeferredTypeParameterHintCollector;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;
import org.eclipse.xtext.xbase.util.XExpressionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureLinkingCandidate
extends AbstractPendingLinkingCandidate<XAbstractFeatureCall>
implements IFeatureLinkingCandidate,
IFeatureNames {
    public FeatureLinkingCandidate(XAbstractFeatureCall featureCall, IIdentifiableElementDescription description, ITypeExpectation expectation, ExpressionTypeComputationState state) {
        super(featureCall, description, expectation, state);
    }

    @Override
    protected ILinkingCandidate createAmbiguousLinkingCandidate(AbstractPendingLinkingCandidate<?> second) {
        return new AmbiguousFeatureLinkingCandidate(this, second);
    }

    @Override
    protected ILinkingCandidate createSuspiciousLinkingCandidate(AbstractPendingLinkingCandidate<?> chosenCandidate) {
        return new SuspiciouslyOverloadedCandidate((FeatureLinkingCandidate)chosenCandidate, this);
    }

    @Override
    protected boolean isRawTypeContext() {
        if (this.isThisOrSuper()) {
            return false;
        }
        LightweightTypeReference receiverType = this.getReceiverType();
        return receiverType != null && receiverType.isRawType();
    }

    @Override
    protected void initializeMapping(JvmTypeParameter typeParameter, Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> result) {
        ITypeReferenceOwner owner = this.getState().getReferenceOwner();
        if (typeParameter.getDeclarator() instanceof JvmType && owner.getDeclaredTypeParameters().contains(typeParameter)) {
            ParameterizedTypeReference typeReference = new ParameterizedTypeReference(owner, (JvmType)typeParameter);
            result.put(typeParameter, new LightweightMergedBoundTypeArgument(typeReference, VarianceInfo.INVARIANT));
        } else {
            super.initializeMapping(typeParameter, result);
        }
    }

    @Override
    protected List<XExpression> getArguments() {
        List<XExpression> syntacticArguments = this.getSyntacticArguments();
        XExpression firstArgument = this.getFirstArgument();
        if (firstArgument != null) {
            return this.createArgumentList(firstArgument, syntacticArguments);
        }
        return syntacticArguments;
    }

    @Override
    public boolean validate(IAcceptor<? super AbstractDiagnostic> result) {
        EObjectDiagnosticImpl diagnostic;
        String message;
        XAbstractFeatureCall featureCall = this.getFeatureCall();
        if (this.isReassignFirstArgument(featureCall)) {
            XBinaryOperation binaryOperation = (XBinaryOperation)featureCall;
            LightweightTypeReference actualType = this.getDeclaredType(featureCall.getFeature());
            LightweightTypeReference expectedType = this.getActualType(binaryOperation.getLeftOperand());
            if (!expectedType.getIdentifier().equals(actualType.getIdentifier())) {
                EObjectDiagnosticImpl diagnostic2 = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.incompatible_types", String.format("Type mismatch: cannot convert from %s to %s", actualType.getHumanReadableName(), expectedType.getHumanReadableName()), this.getExpression(), (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
                result.accept((Object)diagnostic2);
                return false;
            }
        }
        if (this.isInvalidStaticSyntax()) {
            String message2 = String.format("The static %1$s %2$s%3$s should be accessed in a static way", this.getFeatureTypeName(), this.getFeature().getSimpleName(), this.getFeatureParameterTypesAsString());
            EObjectDiagnosticImpl diagnostic3 = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.instance_access_to_static_member", message2, this.getExpression(), (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
            result.accept((Object)diagnostic3);
            return false;
        }
        if (!this.isStatic() && this.isStaticAccessSyntax()) {
            EObject featureOwner = this.getFeature().eContainer();
            message = String.format("Cannot make a static reference to the non-static %1$s %2$s%3$s", this.getFeatureTypeName(), this.getFeature().getSimpleName(), this.getFeatureParameterTypesAsString());
            if (featureOwner instanceof JvmDeclaredType) {
                message = String.valueOf(message) + " from the type " + ((JvmDeclaredType)featureOwner).getSimpleName();
            }
            diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.static_access_to_instance_member", message, this.getExpression(), (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
            result.accept((Object)diagnostic);
            return false;
        }
        if (super.validate(result)) {
            String message3;
            if (this.isExplicitOperationCallOrBuilderSyntax() && !(this.getFeature() instanceof JvmExecutable)) {
                String typeName = this.getFeatureTypeName();
                String code = "org.eclipse.xtext.xbase.validation.IssueCodes.field_access_with_parentheses";
                if (!(this.getFeature() instanceof JvmField)) {
                    code = "org.eclipse.xtext.xbase.validation.IssueCodes.local_var_access_with_parentheses";
                }
                message3 = "Cannot access the " + typeName + " " + this.getFeature().getSimpleName() + " with parentheses";
                EObjectDiagnosticImpl diagnostic4 = new EObjectDiagnosticImpl(Severity.ERROR, code, message3, this.getExpression(), (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
                result.accept((Object)diagnostic4);
                return false;
            }
            JvmIdentifiableElement feature = this.getFeature();
            if (feature instanceof JvmType) {
                QualifiedName featureName = this.description.getName();
                if (!this.getState().isInstanceContext()) {
                    if (!SELF.equals((Object)featureName)) {
                        message3 = String.format("Cannot use %s in a static context", featureName);
                        EObjectDiagnosticImpl diagnostic5 = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.static_access_to_instance_member", message3, this.getExpression(), (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
                        result.accept((Object)diagnostic5);
                        return false;
                    }
                } else if (this.getExpression() instanceof XMemberFeatureCall && !SELF.equals((Object)featureName)) {
                    XMemberFeatureCall memberFeatureCall = (XMemberFeatureCall)this.getExpression();
                    XAbstractFeatureCall target = (XAbstractFeatureCall)memberFeatureCall.getMemberCallTarget();
                    JvmType enclosingType = (JvmType)target.getFeature();
                    List<JvmDeclaredType> enclosingTypes = this.getState().getFeatureScopeSession().getEnclosingTypes();
                    if (!enclosingTypes.contains(enclosingType)) {
                        String message4 = String.format("No enclosing instance of the type %s is accessible in scope", enclosingType.getSimpleName());
                        EObjectDiagnosticImpl diagnostic6 = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.no_enclosing_instance_available", message4, this.getExpression(), (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
                        result.accept((Object)diagnostic6);
                        return false;
                    }
                }
            }
            if (feature instanceof XVariableDeclaration) {
                EObjectDiagnosticImpl diagnostic7;
                XVariableDeclaration casted = (XVariableDeclaration)feature;
                if (casted.isWriteable() && (message3 = this.getState().getResolver().getInvalidWritableVariableAccessMessage(casted, this.getFeatureCall())) != null) {
                    diagnostic7 = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_mutable_variable_access", message3, this.getExpression(), (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
                    result.accept((Object)diagnostic7);
                    return false;
                }
                if (EcoreUtil.isAncestor((EObject)casted, (EObject)this.getFeatureCall())) {
                    message3 = String.format("The local variable %s may not have been initialized", feature.getSimpleName());
                    diagnostic7 = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.illegal_forward_reference", message3, this.getExpression(), (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
                    result.accept((Object)diagnostic7);
                    return false;
                }
            }
        }
        if (this.isGetClassOnTypeLiteral() && "class".equals(this.description.getName().getFirstSegment())) {
            LightweightTypeReference receiverType = this.getSyntacticReceiverType();
            if (receiverType == null) {
                throw new IllegalStateException();
            }
            receiverType = receiverType.getTypeArguments().get(0);
            message = String.format("The syntax for type literals is typeof(%s) or %s.", receiverType.getHumanReadableName(), receiverType.getHumanReadableName());
            diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.unexpected_invocation_on_type_literal", message, this.getExpression(), (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
            result.accept((Object)diagnostic);
            return false;
        }
        return true;
    }

    protected boolean isReassignFirstArgument(XAbstractFeatureCall featureCall) {
        if (featureCall instanceof XBinaryOperation) {
            XBinaryOperation binaryOperation = (XBinaryOperation)featureCall;
            return binaryOperation.isReassignFirstArgument();
        }
        return false;
    }

    protected boolean isInvalidStaticSyntax() {
        boolean result;
        boolean bl = result = this.isStatic() && !this.isExtension() && this.isAssignmentOrMemberFeatureCall() && !this.isStaticWithDeclaringType();
        return result;
    }

    protected boolean isStaticWithDeclaringType() {
        XAbstractFeatureCall featureCall = this.getFeatureCall();
        if (featureCall instanceof XMemberFeatureCall) {
            return ((XMemberFeatureCall)featureCall).isStaticWithDeclaringType();
        }
        if (featureCall instanceof XAssignment) {
            return this.isStaticWithDeclaringType((XAssignment)featureCall);
        }
        return false;
    }

    protected boolean isStaticWithDeclaringType(XAssignment assignment) {
        return assignment.isExplicitStatic() || this.isImplicitlyStatic(assignment);
    }

    protected boolean isImplicitlyStatic(XAssignment assignment) {
        return assignment.isStatic() && this.isTypeLiteral(assignment.getAssignable());
    }

    protected boolean isTypeLiteral(XExpression expression) {
        return expression instanceof XAbstractFeatureCall && ((XAbstractFeatureCall)expression).isTypeLiteral();
    }

    protected boolean isExplicitOperationCallOrBuilderSyntax() {
        XAbstractFeatureCall featureCall = this.getFeatureCall();
        if (featureCall instanceof XBinaryOperation || featureCall instanceof XAssignment) {
            return false;
        }
        return featureCall.isExplicitOperationCallOrBuilderSyntax();
    }

    @Override
    protected String getFeatureTypeName() {
        JvmIdentifiableElement feature = this.getFeature();
        String result = FeatureKinds.getTypeName(feature);
        return result;
    }

    protected boolean isStaticAccessSyntax() {
        XAbstractFeatureCall featureCall = this.getFeatureCall();
        if (featureCall instanceof XMemberFeatureCall) {
            return ((XMemberFeatureCall)featureCall).isExplicitStatic();
        }
        return false;
    }

    protected boolean isAssignmentOrMemberFeatureCall() {
        if (this.getImplicitReceiverType() != null) {
            return true;
        }
        XAbstractFeatureCall featureCall = this.getFeatureCall();
        if (featureCall instanceof XAssignment) {
            return this.isSimpleAssignment((XAssignment)featureCall);
        }
        return featureCall instanceof XMemberFeatureCall;
    }

    protected boolean isSimpleAssignment(XAssignment assignment) {
        return assignment.getAssignable() != null;
    }

    protected List<XExpression> createArgumentList(XExpression head, List<XExpression> tail) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)(tail.size() + 1));
        result.add(head);
        for (XExpression expression : tail) {
            result.add(expression);
        }
        return result;
    }

    @Override
    public int getArityMismatch() {
        int result = super.getArityMismatch();
        if (this.isStatic() && (this.getImplicitReceiver() != null || this.getSyntacticReceiverIfPossibleArgument() != null && !this.isExtension())) {
            result = result < 0 ? --result : ++result;
        }
        return result;
    }

    @Override
    protected List<XExpression> getSyntacticArguments() {
        return new FeatureLinkHelper().getSyntacticArguments(this.getFeatureCall());
    }

    @Override
    public boolean isExtension() {
        return this.description.isExtension();
    }

    @Override
    protected boolean hasReceiver() {
        return !this.isStatic();
    }

    @Override
    public boolean isStatic() {
        return this.description.isStatic();
    }

    protected boolean isSyntacticReceiverPossibleArgument() {
        return this.description.isSyntacticReceiverPossibleArgument();
    }

    @Override
    public boolean isTypeLiteral() {
        return false;
    }

    @Override
    protected CandidateCompareResult getExpectedTypeCompareResultOther(AbstractPendingLinkingCandidate<?> right) {
        if (!(right instanceof FeatureLinkingCandidate) || this.getState().isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.suspiciously_overloaded_feature")) {
            return CandidateCompareResult.OTHER;
        }
        FeatureLinkingCandidate casted = (FeatureLinkingCandidate)right;
        XExpression otherImplicitReceiver = casted.getImplicitReceiver();
        if (otherImplicitReceiver != null) {
            JvmIdentifiableElement otherImplicitReceiverFeature;
            if (otherImplicitReceiver instanceof XAbstractFeatureCall && this.getImplicitReceiver() instanceof XAbstractFeatureCall && (otherImplicitReceiverFeature = ((XAbstractFeatureCall)otherImplicitReceiver).getFeature()) != ((XAbstractFeatureCall)this.getImplicitReceiver()).getFeature()) {
                return CandidateCompareResult.SUSPICIOUS_OTHER;
            }
        } else if (this.isStatic() && casted.isStatic()) {
            JvmIdentifiableElement otherFeature = casted.getFeature();
            if (this.getFeature().eContainer() != otherFeature.eContainer() && otherFeature.eResource() == ((XAbstractFeatureCall)this.getExpression()).eResource() && EcoreUtil.isAncestor((EObject)otherFeature.eContainer(), (EObject)this.getFeature())) {
                return CandidateCompareResult.SUSPICIOUS_OTHER;
            }
        }
        return CandidateCompareResult.OTHER;
    }

    @Override
    protected EnumSet<ConformanceHint> getConformanceHints(int idx, boolean recompute) {
        if (idx == 0 && this.getReceiver() != null) {
            EnumSet<ConformanceHint> result = this.getReceiverConformanceHints();
            return result;
        }
        return super.getConformanceHints(idx, recompute);
    }

    @Override
    protected LightweightTypeReference getSubstitutedExpectedType(int idx) {
        if (idx == 0 && this.getReceiver() != null) {
            return null;
        }
        return super.getSubstitutedExpectedType(idx);
    }

    protected boolean isExplicitOperationCall() {
        return this.getFeatureCall().isExplicitOperationCallOrBuilderSyntax();
    }

    @Override
    protected CandidateCompareResult compareByName(AbstractPendingLinkingCandidate<?> right) {
        boolean otherCompoundOperator;
        if (!(right instanceof FeatureLinkingCandidate)) {
            return super.compareByName(right);
        }
        FeatureLinkingCandidate other = (FeatureLinkingCandidate)right;
        boolean thisCompoundOperator = this.isCompoundOperator();
        if (thisCompoundOperator == (otherCompoundOperator = other.isCompoundOperator())) {
            return CandidateCompareResult.AMBIGUOUS;
        }
        if (thisCompoundOperator) {
            return CandidateCompareResult.THIS;
        }
        return CandidateCompareResult.OTHER;
    }

    protected boolean isCompoundOperator() {
        if (!(this.getFeatureCall() instanceof XBinaryOperation)) {
            return false;
        }
        String methodName = this.getFeature().getSimpleName();
        return this.getState().getReferenceOwner().getServices().getOperatorMapping().isCompoundMethod(methodName);
    }

    @Override
    protected CandidateCompareResult compareByBucket(AbstractPendingLinkingCandidate<?> right) {
        if (this.isExtension() && right.isExtension()) {
            if (this.description.getShadowingKey().equals(right.description.getShadowingKey())) {
                if (this.description.getBucketId() == right.description.getBucketId()) {
                    return CandidateCompareResult.AMBIGUOUS;
                }
                if (this.isAmbiguousExtensionProvider(right)) {
                    return CandidateCompareResult.AMBIGUOUS;
                }
                return CandidateCompareResult.THIS;
            }
            return CandidateCompareResult.AMBIGUOUS;
        }
        return super.compareByBucket(right);
    }

    protected boolean isAmbiguousExtensionProvider(AbstractPendingLinkingCandidate<?> right) {
        XExpression otherImplicitReceiver;
        XExpression implicitReceiver = this.getImplicitReceiver();
        if (implicitReceiver instanceof XAbstractFeatureCall && (otherImplicitReceiver = right.description.getImplicitReceiver()) instanceof XAbstractFeatureCall) {
            JvmIdentifiableElement feature = ((XAbstractFeatureCall)implicitReceiver).getFeature();
            JvmIdentifiableElement otherFeature = ((XAbstractFeatureCall)otherImplicitReceiver).getFeature();
            if (feature.eContainer() == otherFeature.eContainer()) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected CandidateCompareResult compareByArityWith(AbstractPendingLinkingCandidate<?> right) {
        CandidateCompareResult result = super.compareByArityWith(right);
        if (result == CandidateCompareResult.AMBIGUOUS) {
            boolean isExecutable = this.getFeature() instanceof JvmExecutable;
            if (isExecutable != right.getFeature() instanceof JvmExecutable && this.isVisible() == right.isVisible() && this.isTypeLiteral() == right.isTypeLiteral()) {
                if (this.getExpression() instanceof XAssignment) {
                    if (isExecutable) {
                        return CandidateCompareResult.OTHER;
                    }
                    return CandidateCompareResult.THIS;
                }
                if (this.isExplicitOperationCall()) {
                    if (isExecutable) {
                        return CandidateCompareResult.THIS;
                    }
                    return CandidateCompareResult.OTHER;
                }
                if (isExecutable) {
                    return CandidateCompareResult.OTHER;
                }
                return CandidateCompareResult.THIS;
            }
            if (this.getFeature() == right.getFeature() && right instanceof FeatureLinkingCandidate) {
                FeatureLinkingCandidate casted = (FeatureLinkingCandidate)right;
                if (this.isStatic() && casted.isStatic() && this.getReceiver() == casted.getReceiver() && this.isSyntacticReceiverPossibleArgument() == casted.isSyntacticReceiverPossibleArgument()) {
                    return CandidateCompareResult.THIS;
                }
            }
        }
        return result;
    }

    @Override
    protected CandidateCompareResult compareByArgumentTypes(AbstractPendingLinkingCandidate<?> right, int argumentIndex, EnumSet<ConformanceHint> leftConformance, EnumSet<ConformanceHint> rightConformance) {
        boolean rightFirstArgumentMismatch;
        CandidateCompareResult result = super.compareByArgumentTypes(right, argumentIndex, leftConformance, rightConformance);
        if (result != CandidateCompareResult.EQUALLY_INVALID && result != CandidateCompareResult.AMBIGUOUS || leftConformance.contains((Object)ConformanceHint.SUCCESS) || !(right instanceof FeatureLinkingCandidate)) {
            return result;
        }
        boolean firstArgumentMismatch = this.isFirstArgument(argumentIndex);
        if (firstArgumentMismatch != (rightFirstArgumentMismatch = ((FeatureLinkingCandidate)right).isFirstArgument(argumentIndex))) {
            if (firstArgumentMismatch) {
                return CandidateCompareResult.OTHER;
            }
            return CandidateCompareResult.THIS;
        }
        return result;
    }

    protected boolean isFirstArgument(int argumentIndex) {
        if (argumentIndex > 1 || this.getFirstArgument() == null) {
            return false;
        }
        if (this.isStatic()) {
            return argumentIndex == 0;
        }
        return argumentIndex == 1;
    }

    @Override
    protected CandidateCompareResult compareByArgumentTypes(AbstractPendingLinkingCandidate<?> right, int leftBoxing, int rightBoxing, int leftDemand, int rightDemand) {
        if (leftDemand != rightDemand) {
            if (leftDemand < rightDemand) {
                return CandidateCompareResult.THIS;
            }
            return CandidateCompareResult.OTHER;
        }
        if (right instanceof FeatureLinkingCandidate) {
            FeatureLinkingCandidate casted = (FeatureLinkingCandidate)right;
            if (this.isExtension() != casted.isExtension()) {
                if (this.isExtension()) {
                    return CandidateCompareResult.OTHER;
                }
                return CandidateCompareResult.THIS;
            }
            if (this.isStatic() != casted.isStatic()) {
                if (this.isSyntacticReceiverPossibleArgument() == casted.isSyntacticReceiverPossibleArgument()) {
                    if (this.isStatic()) {
                        return CandidateCompareResult.OTHER;
                    }
                    return CandidateCompareResult.THIS;
                }
                if (this.isStatic() && !this.isSyntacticReceiverPossibleArgument()) {
                    return CandidateCompareResult.THIS;
                }
                if (casted.isStatic() && !casted.isSyntacticReceiverPossibleArgument()) {
                    return CandidateCompareResult.OTHER;
                }
            }
        }
        if (leftBoxing != rightBoxing) {
            if (leftBoxing < rightBoxing) {
                return CandidateCompareResult.THIS;
            }
            return CandidateCompareResult.OTHER;
        }
        return CandidateCompareResult.AMBIGUOUS;
    }

    @Override
    protected void preApply() {
        this.applyImplicitReceiver();
        super.preApply();
        XExpression implicitFirstArgument = this.getImplicitFirstArgument();
        if (implicitFirstArgument != null) {
            new ImplicitFirstArgument(this.getFeatureCall(), (XAbstractFeatureCall)implicitFirstArgument, this.getState()).applyToComputationState();
        }
        this.getState().markAsRefinedTypeIfNecessary(this);
        this.discardRefinementTypeIfReassigned();
    }

    protected void applyImplicitReceiver() {
        XExpression implicitReceiver;
        if (!this.isStatic() && (implicitReceiver = this.getImplicitReceiver()) != null) {
            ResolvedTypes resolvedTypes = this.getState().getResolvedTypes();
            LightweightTypeReference receiverType = this.getImplicitReceiverType();
            if (receiverType == null) {
                throw new IllegalStateException("Cannot determine the receiver's type");
            }
            LightweightTypeReference expectedReceiverType = new FeatureLinkHelper().getExpectedReceiverType(this.getFeature(), receiverType);
            if (expectedReceiverType != null) {
                expectedReceiverType = expectedReceiverType.copyInto(resolvedTypes.getReferenceOwner());
            }
            if (receiverType.isSynonym()) {
                receiverType = receiverType.getMultiTypeComponents().get(0);
            }
            TypeExpectation expectation = new TypeExpectation(expectedReceiverType, this.getState(), false);
            resolvedTypes.acceptType(implicitReceiver, expectation, receiverType.copyInto(resolvedTypes.getReferenceOwner()), false, ConformanceHint.UNCHECKED);
            if (implicitReceiver instanceof XAbstractFeatureCall) {
                new ImplicitReceiver(this.getFeatureCall(), (XAbstractFeatureCall)implicitReceiver, this.getState()).applyToComputationState();
            } else {
                throw new IllegalStateException("unexpected implicit receiver, was: " + implicitReceiver);
            }
        }
    }

    @Override
    protected void resolveAgainstActualType(LightweightTypeReference declaredType, LightweightTypeReference actualType, AbstractTypeComputationState state) {
        super.resolveAgainstActualType(declaredType, actualType, state);
        if (!this.isStatic() || (!actualType.getTypeArguments().isEmpty() || actualType.isArray()) && this.getDeclaredTypeParameters().isEmpty()) {
            DeferredTypeParameterHintCollector collector = new DeferredTypeParameterHintCollector(state.getReferenceOwner());
            collector.processPairedReferences(declaredType, actualType);
        }
    }

    @Override
    public XAbstractFeatureCall getFeatureCall() {
        return (XAbstractFeatureCall)this.getExpression();
    }

    @Override
    protected List<LightweightTypeReference> getSyntacticTypeArguments() {
        return Lists.transform(this.getFeatureCall().getTypeArguments(), (Function)this.getState().getResolvedTypes().getConverter());
    }

    @Override
    protected void resolveArgumentType(XExpression argument, LightweightTypeReference declaredType, ITypeComputationState argumentState) {
        if (argument == this.getSyntacticReceiverIfPossibleArgument()) {
            LightweightTypeReference receiverType = this.getSyntacticReceiverType();
            if (receiverType != null) {
                this.resolveKnownArgumentType(argument, receiverType, declaredType, argumentState);
            }
        } else if (argument == this.getImplicitFirstArgument()) {
            LightweightTypeReference argumentType = this.getImplicitFirstArgumentType();
            if (argumentType != null) {
                this.resolveKnownArgumentType(argument, argumentType, declaredType, argumentState);
            }
        } else {
            super.resolveArgumentType(argument, declaredType, argumentState);
        }
    }

    protected void resolveKnownArgumentType(XExpression argument, LightweightTypeReference knownType, LightweightTypeReference declaredType, ITypeComputationState argumentState) {
        if (!(argumentState instanceof AbstractLinkingCandidate.ArgumentTypeComputationState)) {
            throw new IllegalArgumentException("argumentState was " + argumentState);
        }
        AbstractLinkingCandidate.ArgumentTypeComputationState castedArgumentState = (AbstractLinkingCandidate.ArgumentTypeComputationState)argumentState;
        ResolvedTypes resolvedTypes = this.getState().getResolvedTypes();
        LightweightTypeReference copiedDeclaredType = declaredType != null ? declaredType.copyInto(resolvedTypes.getReferenceOwner()) : null;
        TypeExpectation expectation = new TypeExpectation(copiedDeclaredType, castedArgumentState, false);
        LightweightTypeReference copiedReceiverType = knownType.copyInto(resolvedTypes.getReferenceOwner());
        ConformanceHint defaultHint = castedArgumentState.getDefaultHint();
        if (defaultHint == null) {
            resolvedTypes.acceptType(argument, expectation, copiedReceiverType, false, ConformanceHint.UNCHECKED);
        } else {
            resolvedTypes.acceptType(argument, expectation, copiedReceiverType, false, ConformanceHint.UNCHECKED, defaultHint);
        }
        if (copiedDeclaredType != null) {
            this.resolveAgainstActualType(copiedDeclaredType, copiedReceiverType, castedArgumentState);
        }
    }

    @Override
    protected void computeVarArgumentType(IFeatureCallArgumentSlot slot, TypeParameterSubstitutor<?> substitutor) {
        List<XExpression> arguments;
        if (this.isExtension() && (arguments = slot.getArgumentExpressions()).size() == 1 && arguments.get(0) == this.getFirstArgument()) {
            this.computeFixedArityArgumentType(slot, substitutor);
            return;
        }
        super.computeVarArgumentType(slot, substitutor);
    }

    @Override
    protected Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> getDeclaratorParameterMapping() {
        if (this.isStatic()) {
            if (this.getFeature() instanceof JvmConstructor) {
                return this.description.getImplicitReceiverTypeParameterMapping();
            }
            return super.getDeclaratorParameterMapping();
        }
        if (this.getImplicitReceiver() != null) {
            return this.description.getImplicitReceiverTypeParameterMapping();
        }
        return this.description.getSyntacticReceiverTypeParameterMapping();
    }

    protected XExpression getReceiver() {
        if (this.isStatic()) {
            return null;
        }
        XExpression result = this.getImplicitReceiver();
        if (result != null) {
            return result;
        }
        return this.getSyntacticReceiverIfPossibleArgument();
    }

    protected LightweightTypeReference getReceiverType() {
        if (this.isStatic()) {
            return null;
        }
        LightweightTypeReference result = this.getImplicitReceiver() != null ? this.getImplicitReceiverType() : this.getSyntacticReceiverType();
        return result;
    }

    protected EnumSet<ConformanceHint> getReceiverConformanceHints() {
        if (this.isStatic()) {
            throw new IllegalStateException();
        }
        if (this.getImplicitReceiver() != null) {
            return this.description.getImplicitReceiverConformanceHints();
        }
        if (this.getSyntacticReceiverIfPossibleArgument() != null) {
            return this.description.getSyntacticReceiverConformanceHints();
        }
        throw new IllegalStateException();
    }

    protected XExpression getFirstArgument() {
        if (!this.isExtension()) {
            return null;
        }
        XExpression firstArgument = this.getImplicitFirstArgument();
        if (firstArgument != null) {
            return firstArgument;
        }
        return this.getSyntacticReceiverIfPossibleArgument();
    }

    protected LightweightTypeReference getFirstArgumentType() {
        if (!this.isExtension()) {
            return null;
        }
        LightweightTypeReference result = this.getImplicitFirstArgumentType();
        if (result != null) {
            return result;
        }
        return this.getSyntacticReceiverType();
    }

    protected XExpression getImplicitReceiver() {
        return this.description.getImplicitReceiver();
    }

    protected LightweightTypeReference getImplicitReceiverType() {
        return this.description.getImplicitReceiverType();
    }

    protected XExpression getSyntacticReceiver() {
        return this.description.getSyntacticReceiver();
    }

    protected XExpression getSyntacticReceiverIfPossibleArgument() {
        if (this.description.isSyntacticReceiverPossibleArgument()) {
            return this.getSyntacticReceiver();
        }
        return null;
    }

    protected LightweightTypeReference getSyntacticReceiverType() {
        return this.description.getSyntacticReceiverType();
    }

    protected XExpression getImplicitFirstArgument() {
        return this.description.getImplicitFirstArgument();
    }

    protected LightweightTypeReference getImplicitFirstArgumentType() {
        return this.description.getImplicitFirstArgumentType();
    }

    @Override
    protected LightweightTypeReference getDeclaredType(JvmIdentifiableElement feature) {
        if (feature instanceof JvmConstructor) {
            return this.getState().getConverter().toLightweightReference(this.getState().getTypeReferences().getTypeForName(Void.TYPE, (Notifier)feature, new JvmTypeReference[0]));
        }
        if (this.isGetClass(feature)) {
            LightweightTypeReference receiverType = this.getReceiverType();
            if (receiverType == null) {
                throw new IllegalStateException("Cannot determine the receiver's type");
            }
            List<JvmType> rawTypes = receiverType.getRawTypes();
            if (rawTypes.isEmpty()) {
                return super.getDeclaredType(feature);
            }
            ParameterizedTypeReference result = new ParameterizedTypeReference(receiverType.getOwner(), ((JvmOperation)feature).getReturnType().getType());
            WildcardTypeReference wildcard = new WildcardTypeReference(receiverType.getOwner());
            wildcard.addUpperBound(new ParameterizedTypeReference(receiverType.getOwner(), rawTypes.get(0)));
            result.addTypeArgument(wildcard);
            return result;
        }
        return super.getDeclaredType(feature);
    }

    protected boolean isGetClassOnTypeLiteral() {
        IFeatureLinkingCandidate linkingCandidate;
        XExpression receiver;
        JvmIdentifiableElement feature = this.getFeature();
        return this.isGetClass(feature) && (receiver = this.getSyntacticReceiver()) instanceof XAbstractFeatureCall && (linkingCandidate = this.getState().getResolvedTypes().getLinkingCandidate((XAbstractFeatureCall)receiver)) != null && linkingCandidate.isTypeLiteral();
    }

    protected boolean isGetClass(JvmIdentifiableElement feature) {
        JvmOperation getClassOperation;
        return feature instanceof JvmOperation && feature.getSimpleName().equals("getClass") && (getClassOperation = (JvmOperation)feature).getParameters().isEmpty() && "java.lang.Object".equals(getClassOperation.getDeclaringType().getIdentifier());
    }

    @Override
    public void applyToModel() {
        this.resolveLinkingProxy(XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, 0);
        XAbstractFeatureCall featureCall = this.getFeatureCall();
        if (featureCall instanceof XMemberFeatureCall) {
            XMemberFeatureCall casted = (XMemberFeatureCall)featureCall;
            XExpression syntacticReceiver = casted.getMemberCallTarget();
            if (this.isStaticWithDeclaringType(syntacticReceiver) || this.isThisOrSuper()) {
                casted.setStaticWithDeclaringType(true);
            }
        } else if (featureCall instanceof XAssignment) {
            XAssignment casted = (XAssignment)featureCall;
            XExpression syntacticReceiver = casted.getAssignable();
            if (this.isStaticWithDeclaringType(syntacticReceiver)) {
                casted.setStaticWithDeclaringType(true);
            }
        } else if (featureCall instanceof XBinaryOperation) {
            XBinaryOperation binaryOperation = (XBinaryOperation)featureCall;
            CommonTypeComputationServices services = this.getState().getReferenceOwner().getServices();
            OperatorMapping operatorMapping = services.getOperatorMapping();
            if (operatorMapping.getCompoundOperators().contains(this.description.getName())) {
                JvmIdentifiableElement feature = this.description.getElementOrProxy();
                String methodName = feature.getSimpleName();
                if (operatorMapping.isCompoundMethod(methodName)) {
                    XExpressionHelper expressionHelper = services.getExpressionHelper();
                    if (expressionHelper.findReassignFirstArgumentAnnotation(feature) != null) {
                        binaryOperation.setReassignFirstArgument(true);
                    }
                } else {
                    binaryOperation.setReassignFirstArgument(true);
                }
            }
        }
    }

    private boolean isThisOrSuper() {
        return (THIS.equals((Object)this.description.getName()) || SUPER.equals((Object)this.description.getName())) && this.description.getElementOrProxy() instanceof JvmType && !this.isSyntacticReceiverPossibleArgument();
    }

    private boolean isStaticWithDeclaringType(XExpression syntacticReceiver) {
        IFeatureLinkingCandidate candidate;
        return this.isStatic() && syntacticReceiver instanceof XAbstractFeatureCall && !this.isExtension() && (candidate = this.getState().getResolvedTypes().getLinkingCandidate((XAbstractFeatureCall)syntacticReceiver)) != null && candidate.isTypeLiteral();
    }

    @Override
    protected Severity getUnhandledExceptionSeverity(JvmExecutable executable) {
        if (this.getFeature() instanceof JvmConstructor) {
            return Severity.ERROR;
        }
        return super.getUnhandledExceptionSeverity(executable);
    }
}

