/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.conformance;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.xbase.typesystem.computation.SynonymTypesProvider;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.internal.util.WrapperTypeLookup;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentMerger;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentSource;
import org.eclipse.xtext.xbase.typesystem.util.UnboundTypeParameterPreservingSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class RawTypeConformanceComputer {
    public static final int RAW_TYPE = 1;
    public static final int AS_TYPE_ARGUMENT = 2;
    public static final int ALLOW_RAW_TYPE_CONVERSION = 4;
    public static final int ALLOW_BOXING = 8;
    public static final int ALLOW_UNBOXING = 16;
    public static final int ALLOW_BOXING_UNBOXING = 24;
    public static final int ALLOW_PRIMITIVE_WIDENING = 32;
    public static final int UNBOUND_COMPUTATION_ADDS_HINTS = 64;
    public static final int ALLOW_SYNONYMS = 128;
    public static final int ALLOW_FUNCTION_CONVERSION = 256;
    public static final int SUCCESS = 512;
    public static final int DEMAND_CONVERSION = 1024;
    public static final int SUBTYPE = 2048;
    public static final int PRIMITIVE_WIDENING = 4096;
    public static final int UNBOXING = 8192;
    public static final int BOXING = 16384;
    public static final int RAW_TYPE_CONVERSION = 32768;
    public static final int SYNONYM = 65536;
    private SynonymTypesProvider synonymTypesProvider;
    private boolean useCustomSynonymTypes = false;

    @Inject
    public void setSynonymTypesProvider(SynonymTypesProvider synonymTypesProvider) {
        this.synonymTypesProvider = synonymTypesProvider;
        this.useCustomSynonymTypes = !synonymTypesProvider.getClass().equals(SynonymTypesProvider.class);
    }

    public int isConformant(LightweightTypeReference left, LightweightTypeReference right, int flags) {
        if (left == right && left != null) {
            return flags | 0x200;
        }
        int result = this.doIsConformant(left, right, flags);
        return this.isSynonymConformant(result, left, right, flags);
    }

    protected int isSynonymConformant(int originalConformance, final LightweightTypeReference left, LightweightTypeReference right, final int flags) {
        if (this.useCustomSynonymTypes && (originalConformance & 0x200) == 0 && (flags & 0x80) != 0) {
            final int[] resultFromSynonyms = new int[]{originalConformance};
            this.synonymTypesProvider.collectSynonymTypes(right, new SynonymTypesProvider.Acceptor(){

                @Override
                protected boolean accept(LightweightTypeReference synonym, EnumSet<ConformanceHint> hints) {
                    int synonymResult;
                    if (!hints.contains((Object)ConformanceHint.BOXING) && !hints.contains((Object)ConformanceHint.UNBOXING) && ((synonymResult = RawTypeConformanceComputer.this.isConformant(left, synonym, flags & 0xFFFFFF7F)) & 0x200) != 0) {
                        resultFromSynonyms[0] = synonymResult | RawTypeConformanceComputer.this.toSynonymResult(hints);
                        return false;
                    }
                    return true;
                }
            });
            return resultFromSynonyms[0];
        }
        return originalConformance;
    }

    protected int toSynonymResult(EnumSet<ConformanceHint> hints) {
        int result = 65536;
        if (hints.contains((Object)ConformanceHint.SUCCESS)) {
            result |= 0x200;
        }
        if (hints.contains((Object)ConformanceHint.DEMAND_CONVERSION)) {
            result |= 0x400;
        }
        if (hints.contains((Object)ConformanceHint.SUBTYPE)) {
            result |= 0x800;
        }
        if (hints.contains((Object)ConformanceHint.PRIMITIVE_WIDENING)) {
            result |= 0x1000;
        }
        if (hints.contains((Object)ConformanceHint.UNBOXING)) {
            result |= 0x2000;
        }
        if (hints.contains((Object)ConformanceHint.BOXING)) {
            result |= 0x4000;
        }
        if (hints.contains((Object)ConformanceHint.RAWTYPE_CONVERSION)) {
            result |= 0x8000;
        }
        if (hints.contains((Object)ConformanceHint.RAW)) {
            result |= 1;
        }
        return result;
    }

    protected int doIsConformant(LightweightTypeReference left, LightweightTypeReference right, int flags) {
        int rightKind = right.getKind();
        switch (rightKind) {
            case 7: {
                return flags | 0x200;
            }
            case 6: {
                UnboundTypeReference castedRight = (UnboundTypeReference)right;
                LightweightTypeReference resolved = castedRight.internalGetResolvedTo();
                if (resolved != null) {
                    return this.doIsConformant(left, resolved, flags);
                }
                if (left.getKind() == 6) {
                    UnboundTypeReference castedLeft = (UnboundTypeReference)left;
                    LightweightTypeReference resolvedLeft = castedLeft.internalGetResolvedTo();
                    if (resolvedLeft != null) {
                        return this.doIsConformant(resolvedLeft, castedRight, flags);
                    }
                    return this.doIsConformant((UnboundTypeReference)left, castedRight, flags);
                }
                return this.doIsConformant(left, castedRight, flags);
            }
            case 4: {
                int leftKind = left.getKind();
                if (leftKind == 6 || leftKind == 4 || leftKind == 8) break;
                for (LightweightTypeReference component : right.getMultiTypeComponents()) {
                    int result = this.doIsConformant(left, component, flags);
                    if ((result & 0x200) == 0) continue;
                    return result;
                }
                return flags;
            }
        }
        switch (left.getKind()) {
            case 7: {
                return flags | 0x200;
            }
            case 9: {
                switch (rightKind) {
                    case 9: {
                        return this.doIsConformant((FunctionTypeReference)left, (FunctionTypeReference)right, flags);
                    }
                    case 5: {
                        return this.doIsConformant((FunctionTypeReference)left, (ParameterizedTypeReference)right, flags);
                    }
                }
            }
            case 5: {
                switch (rightKind) {
                    case 3: {
                        return this.doIsConformant((ParameterizedTypeReference)left, (ArrayTypeReference)right, flags);
                    }
                    case 9: {
                        return this.doIsConformant((ParameterizedTypeReference)left, (FunctionTypeReference)right, flags);
                    }
                    case 5: {
                        return this.doIsConformant((ParameterizedTypeReference)left, (ParameterizedTypeReference)right, flags);
                    }
                    case 2: {
                        return this.doIsConformantToAnyType((ParameterizedTypeReference)left, flags);
                    }
                    case 8: {
                        return this.doIsConformant(left, (WildcardTypeReference)right, flags);
                    }
                }
                return flags;
            }
            case 3: {
                switch (rightKind) {
                    case 3: {
                        return this.doIsConformant((ArrayTypeReference)left, (ArrayTypeReference)right, flags);
                    }
                    case 5: 
                    case 9: {
                        return this.doIsConformant((ArrayTypeReference)left, (ParameterizedTypeReference)right, flags);
                    }
                    case 2: {
                        return flags | 0x200;
                    }
                    case 8: {
                        return this.doIsConformant(left, (WildcardTypeReference)right, flags);
                    }
                }
                return flags;
            }
            case 4: {
                List<LightweightTypeReference> leftReferences = left.getMultiTypeComponents();
                if (leftReferences.isEmpty()) {
                    if (left.isSynonym()) {
                        return flags;
                    }
                    return flags | 0x200;
                }
                int result = flags;
                for (LightweightTypeReference reference : leftReferences) {
                    int componentResult = this.doIsConformant(reference, right, flags);
                    if ((componentResult & 0x200) != 0) {
                        if (left.isSynonym()) {
                            return componentResult;
                        }
                        result |= componentResult;
                        continue;
                    }
                    if (left.isSynonym()) continue;
                    return flags;
                }
                return result;
            }
            case 2: {
                switch (rightKind) {
                    case 2: {
                        return flags | 0x200;
                    }
                    case 8: {
                        return this.doIsConformant(left, (WildcardTypeReference)right, flags);
                    }
                }
                return flags;
            }
            case 6: {
                UnboundTypeReference castedLeft = (UnboundTypeReference)left;
                LightweightTypeReference resolvedLeft = castedLeft.internalGetResolvedTo();
                if (resolvedLeft != null) {
                    return this.doIsConformant(resolvedLeft, right, flags);
                }
                switch (rightKind) {
                    case 2: {
                        return flags | 0x200;
                    }
                }
                return this.tryResolveAndCheckConformance(castedLeft, right, flags);
            }
            case 8: {
                switch (rightKind) {
                    case 8: {
                        return this.doIsConformant((WildcardTypeReference)left, (WildcardTypeReference)right, flags);
                    }
                }
                return this.doIsConformant((WildcardTypeReference)left, right, flags);
            }
        }
        return flags;
    }

    protected int doIsConformant(ParameterizedTypeReference left, ArrayTypeReference right, int flags) {
        if (left.isType(Object.class) || left.isType(Serializable.class) || left.isType(Cloneable.class)) {
            return flags | 0x200 | 0x800;
        }
        if ((flags & 0x80) != 0 && (left.isType(List.class) || left.isType(Collection.class) || left.isType(Iterable.class))) {
            List<LightweightTypeReference> arguments = left.getTypeArguments();
            if (arguments.isEmpty()) {
                return flags | 0x200 | 0x400;
            }
            LightweightTypeReference componentType = right.getComponentType().getWrapperTypeIfPrimitive();
            int result = this.doIsConformant(arguments.get(0).getInvariantBoundSubstitute(), componentType, flags);
            if ((result & 0x200) != 0) {
                return result | 0x400;
            }
        }
        return flags;
    }

    protected int doIsConformant(ArrayTypeReference left, ArrayTypeReference right, int flags) {
        LightweightTypeReference leftComponent = left.getComponentType();
        LightweightTypeReference rightComponent = right.getComponentType();
        return this.doIsConformant(leftComponent, rightComponent, flags & 0xFFFFFE47);
    }

    protected int doIsConformant(ArrayTypeReference left, ParameterizedTypeReference right, int flags) {
        LightweightTypeReference rightComponent;
        LightweightTypeReference leftComponent;
        int result;
        ArrayTypeReference rightAsArray;
        if ((flags & 2) == 0 && (flags & 0x80) != 0 && (rightAsArray = right.tryConvertToArray()) != null && ((result = this.doIsConformant(leftComponent = left.getComponentType().getWrapperTypeIfPrimitive(), rightComponent = rightAsArray.getComponentType(), flags & 0xFFFFFE47)) & 0x200) != 0) {
            return result | 0x400 | 0x10000;
        }
        return flags;
    }

    protected int doIsConformant(LightweightTypeReference left, WildcardTypeReference right, int flags) {
        if ((flags & 2) == 0) {
            for (LightweightTypeReference upperBound : right.getUpperBounds()) {
                int result = this.doIsConformant(left, upperBound, flags);
                if ((result & 0x200) == 0) continue;
                return result;
            }
        }
        return flags;
    }

    protected int doIsConformant(WildcardTypeReference left, LightweightTypeReference right, int flags) {
        if ((flags & 2) != 0) {
            LightweightTypeReference lowerBound = left.getLowerBound();
            if (lowerBound != null) {
                int result;
                int newFlags = flags & 0xFFFFFE41;
                if (right.isRawType()) {
                    newFlags |= 4;
                }
                if (((result = this.doIsConformant(right, lowerBound, newFlags)) & 0x200) == 0) {
                    return result;
                }
            }
            for (LightweightTypeReference leftUpperBound : left.getUpperBounds()) {
                int result;
                int newFlags = flags & 0xFFFFFE41;
                if (leftUpperBound.isRawType()) {
                    newFlags |= 4;
                }
                if (((result = this.doIsConformant(leftUpperBound, right, newFlags)) & 0x200) != 0) continue;
                return result;
            }
            return flags | 0x200 | 0x800;
        }
        return flags;
    }

    protected int doIsConformant(WildcardTypeReference left, WildcardTypeReference right, int flags) {
        if ((flags & 2) != 0) {
            LightweightTypeReference leftLowerBound = left.getLowerBound();
            if (leftLowerBound != null) {
                LightweightTypeReference rightLowerBound = right.getLowerBound();
                if (rightLowerBound != null) {
                    int newFlags = flags & 0xFFFFFE41;
                    if (rightLowerBound.isRawType()) {
                        newFlags |= 4;
                    }
                    int result = this.doIsConformant(rightLowerBound, leftLowerBound, newFlags);
                    return result;
                }
                return flags;
            }
            int subtypeOrRawConversion = 0;
            for (LightweightTypeReference leftUpperBound : left.getUpperBounds()) {
                int result;
                int newFlags = flags & 0xFFFFFE41;
                if (leftUpperBound.isRawType()) {
                    newFlags |= 4;
                }
                if (((result = this.doIsConformant(leftUpperBound, (LightweightTypeReference)right, newFlags)) & 0x200) == 0) {
                    return result;
                }
                subtypeOrRawConversion |= result & 0x8800;
            }
            return flags | 0x200 | subtypeOrRawConversion;
        }
        return flags;
    }

    protected int doIsConformantToAnyType(ParameterizedTypeReference left, int flags) {
        if (left.isPrimitive() || left.isPrimitiveVoid()) {
            return flags;
        }
        return flags | 0x200;
    }

    protected int doIsConformant(LightweightTypeReference left, UnboundTypeReference right, int flags) {
        if (left.getType() == right.getType() || left.isType(Object.class)) {
            return flags | 0x200;
        }
        if ((flags & 0x10) == 0 && left.isPrimitive()) {
            return flags;
        }
        boolean doesNotHaveSignificantHints = false;
        if ((flags & 1) == 0 && (right.canResolveTo(left) || (flags & 2) != 0 && (doesNotHaveSignificantHints = !right.hasSignificantHints()))) {
            if ((flags & 0x40) != 0 && doesNotHaveSignificantHints) {
                right.acceptHint(left, BoundTypeArgumentSource.INFERRED_LATER, left, VarianceInfo.INVARIANT, VarianceInfo.INVARIANT);
            }
            return flags | 0x200;
        }
        right.tryResolve(false);
        LightweightTypeReference resolvedTo = right.getResolvedTo();
        if (resolvedTo != null) {
            return this.doIsConformant(left, resolvedTo, flags);
        }
        return flags;
    }

    protected int doIsConformant(UnboundTypeReference left, UnboundTypeReference right, int flags) {
        if (left.getHandle().equals(right.getHandle())) {
            return flags | 0x200;
        }
        List<LightweightBoundTypeArgument> leftHints = left.getAllHints();
        List<LightweightBoundTypeArgument> rightHints = right.getAllHints();
        if ((flags & 0x40) != 0 && (leftHints.isEmpty() || rightHints.isEmpty() || !left.hasSignificantHints(leftHints) || !right.hasSignificantHints())) {
            left.acceptHint(right, BoundTypeArgumentSource.INFERRED, this, VarianceInfo.OUT, VarianceInfo.OUT);
            return flags | 0x200;
        }
        if (leftHints.equals(rightHints)) {
            return flags | 0x200;
        }
        return this.tryResolveAndCheckConformance(left, right, flags);
    }

    protected int tryResolveAndCheckConformance(UnboundTypeReference left, LightweightTypeReference right, int flags) {
        return this.tryResolveAndCheckConformance(left, left.getAllHints(), right, flags);
    }

    protected int tryResolveAndCheckConformance(UnboundTypeReference left, List<LightweightBoundTypeArgument> leftHints, LightweightTypeReference right, int flags) {
        if (leftHints.isEmpty() && (flags & 0x40) == 0) {
            return flags;
        }
        int result = this.isConformantToConstraints(left, right, leftHints, flags & 0xFFFFFE5D);
        if ((result & 0x200) == 0) {
            return flags;
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Helper {
            final List<LightweightBoundTypeArgument> hintsToProcess;
            final List<LightweightBoundTypeArgument> inferredHintsToProcess;
            int laterCount = 0;
            boolean inferredAsWildcard = false;

            Helper(List<LightweightBoundTypeArgument> hints) {
                this.hintsToProcess = Lists.newArrayListWithCapacity((int)hints.size());
                this.inferredHintsToProcess = Lists.newArrayListWithCapacity((int)hints.size());
                for (LightweightBoundTypeArgument hint : hints) {
                    if (hint.getDeclaredVariance() == null) continue;
                    this.hintsToProcess.add(hint);
                    if (hint.getSource() == BoundTypeArgumentSource.INFERRED) {
                        if (hint.getTypeReference() instanceof WildcardTypeReference) {
                            this.inferredAsWildcard = true;
                        }
                        this.inferredHintsToProcess.add(hint);
                        continue;
                    }
                    if (hint.getSource() != BoundTypeArgumentSource.INFERRED_LATER) continue;
                    ++this.laterCount;
                }
            }

            private List<LightweightBoundTypeArgument> getHintsToMerge() {
                return this.inferredHintsToProcess.isEmpty() || this.laterCount > 1 && this.inferredAsWildcard ? this.hintsToProcess : this.inferredHintsToProcess;
            }

            LightweightMergedBoundTypeArgument getMergeResult(UnboundTypeReference left) {
                LightweightBoundTypeArgument singleBoundArgument;
                VarianceInfo varianceInfo;
                BoundTypeArgumentMerger merger = left.getOwner().getServices().getBoundTypeArgumentMerger();
                if (this.inferredHintsToProcess.size() == 1 && (varianceInfo = (singleBoundArgument = this.inferredHintsToProcess.get(0)).getDeclaredVariance().mergeDeclaredWithActual(singleBoundArgument.getActualVariance())) != null) {
                    return new LightweightMergedBoundTypeArgument(singleBoundArgument.getTypeReference(), varianceInfo);
                }
                return merger.merge(this.getHintsToMerge(), left.getOwner());
            }
        }
        Helper state = new Helper(leftHints);
        if (state.hintsToProcess.isEmpty() && (flags & 0x40) != 0) {
            return this.addHintAndAnnounceSuccess(left, right, flags);
        }
        LightweightMergedBoundTypeArgument mergeResult = state.getMergeResult(left);
        if (mergeResult != null && mergeResult.getVariance() != null) {
            return this.isConformantMergeResult(mergeResult, right, flags);
        }
        return flags;
    }

    protected int isConformantToConstraints(final UnboundTypeReference left, final LightweightTypeReference right, List<LightweightBoundTypeArgument> hints, int flags) {
        UnboundTypeParameterPreservingSubstitutor unboundSubstitutor = new UnboundTypeParameterPreservingSubstitutor(Collections.singletonMap(left.getTypeParameter(), new LightweightMergedBoundTypeArgument(right, VarianceInfo.INVARIANT)), right.getOwner()){

            @Override
            public LightweightTypeReference doVisitUnboundTypeReference(UnboundTypeReference reference, Set<JvmTypeParameter> visiting) {
                if (reference.getHandle() == left.getHandle()) {
                    return right;
                }
                return super.doVisitUnboundTypeReference(reference, visiting);
            }
        };
        int result = flags;
        for (LightweightBoundTypeArgument hint : hints) {
            if (hint.getSource() != BoundTypeArgumentSource.CONSTRAINT) continue;
            LightweightTypeReference constraintReference = unboundSubstitutor.substitute(hint.getTypeReference());
            int constraintResult = this.doIsConformant(constraintReference, right, flags);
            if ((constraintResult & 0x200) == 0) {
                return flags;
            }
            result |= constraintResult;
        }
        return result | 0x200;
    }

    protected int addHintAndAnnounceSuccess(UnboundTypeReference left, LightweightTypeReference hint, int flags) {
        if (hint instanceof WildcardTypeReference) {
            List<LightweightTypeReference> bounds = ((WildcardTypeReference)hint).getUpperBounds();
            for (LightweightTypeReference upperBound : bounds) {
                left.acceptHint(upperBound, BoundTypeArgumentSource.INFERRED, this, VarianceInfo.OUT, VarianceInfo.OUT);
            }
        } else {
            left.acceptHint(hint, BoundTypeArgumentSource.INFERRED, this, VarianceInfo.OUT, VarianceInfo.OUT);
        }
        return flags | 0x200;
    }

    protected int isConformantMergeResult(LightweightMergedBoundTypeArgument mergeResult, LightweightTypeReference right, int flags) {
        LightweightTypeReference mergeResultReference = mergeResult.getTypeReference();
        if (right.isWildcard() && mergeResultReference.isWildcard()) {
            if (right.getLowerBoundSubstitute().isAny()) {
                LightweightTypeReference lowerBoundMergeResult = mergeResultReference.getLowerBoundSubstitute();
                if (!lowerBoundMergeResult.isAny()) {
                    mergeResultReference = lowerBoundMergeResult;
                }
            } else {
                flags |= 2;
            }
        } else if (mergeResultReference.isWildcard()) {
            flags |= 2;
        }
        return this.isConformant(mergeResultReference, right, flags);
    }

    protected int doIsConformant(ParameterizedTypeReference left, FunctionTypeReference right, int flags) {
        int result;
        if ((flags & 0x100) == 0) {
            return this.doIsConformant(left, (ParameterizedTypeReference)right, flags);
        }
        FunctionTypeReference convertedLeft = left.getAsFunctionTypeReference();
        if (convertedLeft != null) {
            return this.doIsConformant(convertedLeft, right, flags);
        }
        if (right.isFunctionType() && (convertedLeft = left.tryConvertToFunctionTypeReference(false)) != null && ((result = this.doIsConformant(convertedLeft, right, flags)) & 0x200) != 0) {
            return result | 0x400;
        }
        return this.doIsConformant(left, (ParameterizedTypeReference)right, flags);
    }

    protected int doIsConformant(FunctionTypeReference left, FunctionTypeReference right, int flags) {
        if (left.getType() == right.getType()) {
            return flags | 0x200;
        }
        if ((flags & 0x100) == 0) {
            return flags;
        }
        if (left.getParameterTypes().size() == right.getParameterTypes().size()) {
            LightweightTypeReference rightReturnType;
            LightweightTypeReference leftReturnType = left.getReturnType();
            if (leftReturnType == (rightReturnType = right.getReturnType())) {
                return flags | 0x200;
            }
            if (leftReturnType != null && rightReturnType != null && leftReturnType.isPrimitiveVoid() == rightReturnType.isPrimitiveVoid()) {
                return flags | 0x200;
            }
        }
        return flags;
    }

    protected int doIsConformant(FunctionTypeReference left, ParameterizedTypeReference right, int flags) {
        int result;
        if ((flags & 0x100) == 0) {
            return this.doIsConformant((ParameterizedTypeReference)left, right, flags);
        }
        FunctionTypeReference convertedRight = right.getAsFunctionTypeReference();
        if (convertedRight != null) {
            return this.doIsConformant(left, convertedRight, flags);
        }
        if (left.isFunctionType() && (convertedRight = right.tryConvertToFunctionTypeReference(false)) != null && ((result = this.doIsConformant(left, convertedRight, flags)) & 0x200) != 0) {
            return result | 0x400;
        }
        return this.doIsConformant((ParameterizedTypeReference)left, right, flags);
    }

    protected int doIsConformant(ParameterizedTypeReference left, ParameterizedTypeReference right, int flags) {
        ParameterizedTypeReference rightSuperType;
        if (left.getType() == right.getType()) {
            return this.doIsConformantTypeArguments(left, right, flags);
        }
        if (left.isPrimitiveVoid() || right.isPrimitiveVoid()) {
            return flags;
        }
        if ((flags & 0x38) != 0) {
            Primitives.Primitive rightPrimitiveKind;
            Primitives.Primitive leftPrimitiveKind = left.getPrimitiveKind();
            if (leftPrimitiveKind != null) {
                rightPrimitiveKind = right.getPrimitiveKind();
                if (rightPrimitiveKind != null) {
                    if ((flags & 0x20) != 0 && this.isWideningConversion(leftPrimitiveKind, rightPrimitiveKind)) {
                        return flags | 0x200 | 0x1000;
                    }
                } else if ((flags & 0x10) != 0 && (rightPrimitiveKind = right.getPrimitiveKindIfWrapperType()) != null && (rightPrimitiveKind == leftPrimitiveKind || this.isWideningConversion(leftPrimitiveKind, rightPrimitiveKind))) {
                    return flags | 0x200 | 0x2000;
                }
                if (right.getType().eClass() != TypesPackage.Literals.JVM_TYPE_PARAMETER) {
                    return flags;
                }
            } else if ((flags & 8) != 0 && (rightPrimitiveKind = right.getPrimitiveKind()) != null) {
                if (left.isType(Object.class)) {
                    return flags | 0x200 | 0x4000;
                }
                if (left.isType(String.class)) {
                    return flags;
                }
                LightweightTypeReference wrapper = WrapperTypeLookup.getWrapperType(right, rightPrimitiveKind);
                int result = this.doIsConformant(left, (ParameterizedTypeReference)wrapper, flags);
                if ((result & 0x200) != 0) {
                    return result | 0x4000;
                }
                return flags;
            }
        } else if (left.isPrimitive() || right.isPrimitive()) {
            return flags;
        }
        if ((flags & 2) != 0) {
            return flags;
        }
        if (left.isType(Object.class)) {
            return flags | 0x200 | 0x800;
        }
        JvmType leftType = left.getType();
        JvmType rightType = right.getType();
        if (leftType.eClass() == TypesPackage.Literals.JVM_GENERIC_TYPE) {
            JvmGenericType castedLeftType = (JvmGenericType)leftType;
            if (castedLeftType.isFinal()) {
                if (rightType.eClass() == TypesPackage.Literals.JVM_TYPE_PARAMETER && this.getSuperType(right, (JvmType)castedLeftType) != null) {
                    return flags | 0x200 | 0x800;
                }
                return flags;
            }
            if (!castedLeftType.isInterface() && rightType.eClass() == TypesPackage.Literals.JVM_GENERIC_TYPE && ((JvmGenericType)rightType).isInterface()) {
                return flags;
            }
        } else if (leftType.eClass() == TypesPackage.Literals.JVM_TYPE_PARAMETER) {
            if (rightType.eClass() == TypesPackage.Literals.JVM_TYPE_PARAMETER && this.getSuperType(right, leftType) != null) {
                return flags | 0x200 | 0x800;
            }
            return flags;
        }
        if ((rightSuperType = (ParameterizedTypeReference)this.getSuperType(right, leftType)) != null) {
            int result = this.doIsConformantTypeArguments(left, rightSuperType, flags);
            if ((result & 0x200) != 0) {
                return result | 0x800;
            }
            return result;
        }
        return this.isAssignableAsFunctionType(left, right, flags);
    }

    protected int isAssignableAsFunctionType(ParameterizedTypeReference left, ParameterizedTypeReference right, int flags) {
        if ((flags & 0x100) == 0) {
            return flags;
        }
        FunctionTypeReference leftFunctionType = left.getAsFunctionTypeReference();
        if (leftFunctionType != null) {
            int result;
            FunctionTypeReference rightFunctionType = right.getAsFunctionTypeReference();
            if (rightFunctionType != null) {
                return flags;
            }
            rightFunctionType = right.tryConvertToFunctionTypeReference((flags & 1) != 0);
            if (rightFunctionType != null && ((result = this.doIsConformant(leftFunctionType, rightFunctionType, flags)) & 0x200) != 0) {
                return result | 0x400;
            }
        } else {
            int result;
            FunctionTypeReference rightFunctionType = right.getAsFunctionTypeReference();
            if (rightFunctionType != null && (leftFunctionType = left.tryConvertToFunctionTypeReference((flags & 1) != 0)) != null && ((result = this.doIsConformant(leftFunctionType, rightFunctionType, flags)) & 0x200) != 0) {
                return result | 0x400;
            }
        }
        return flags;
    }

    private boolean isWideningConversion(Primitives.Primitive leftPrimitiveKind, Primitives.Primitive rightPrimitiveKind) {
        switch (rightPrimitiveKind) {
            case Byte: {
                switch (leftPrimitiveKind) {
                    case Byte: 
                    case Void: {
                        return false;
                    }
                }
                return true;
            }
            case Short: 
            case Char: {
                switch (leftPrimitiveKind) {
                    case Byte: 
                    case Short: 
                    case Char: 
                    case Void: {
                        return false;
                    }
                }
                return true;
            }
            case Int: {
                switch (leftPrimitiveKind) {
                    case Long: 
                    case Float: 
                    case Double: {
                        return true;
                    }
                }
                return false;
            }
            case Long: {
                switch (leftPrimitiveKind) {
                    case Float: 
                    case Double: {
                        return true;
                    }
                }
                return false;
            }
            case Float: {
                return leftPrimitiveKind == Primitives.Primitive.Double;
            }
        }
        return false;
    }

    protected int doIsConformantTypeArguments(ParameterizedTypeReference left, ParameterizedTypeReference right, int flags) {
        if (left.isRawType() != right.isRawType()) {
            return flags | 0x200 | 0x8000;
        }
        return flags | 0x200;
    }

    protected LightweightTypeReference getSuperType(ParameterizedTypeReference current, JvmType type) {
        return current.getRawSuperType(type);
    }
}

