/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.navigation;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.text.Region;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.xtext.ui.TypeAwareHyperlinkHelper;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.hyperlinking.IHyperlinkAcceptor;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.xbase.imports.StaticallyImportedMemberProvider;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XtypePackage;

public class StaticallyImportedMemberAwareHyperlinkHelper
extends TypeAwareHyperlinkHelper {
    @Inject
    @Extension
    private ILocationInFileProvider _iLocationInFileProvider;
    @Inject
    @Extension
    private StaticallyImportedMemberProvider _staticallyImportedMemberProvider;

    public void createHyperlinksByOffset(XtextResource resource, int offset, IHyperlinkAcceptor acceptor) {
        EObject _resolveElementAt;
        EObjectAtOffsetHelper _eObjectAtOffsetHelper = this.getEObjectAtOffsetHelper();
        EObject element = _resolveElementAt = _eObjectAtOffsetHelper.resolveElementAt(resource, offset);
        boolean _matched = false;
        if (!_matched && element instanceof XImportDeclaration) {
            boolean _isWildcard;
            boolean _not;
            boolean _and = false;
            boolean _isStatic = ((XImportDeclaration)element).isStatic();
            _and = !_isStatic ? false : (_not = !(_isWildcard = ((XImportDeclaration)element).isWildcard()));
            if (_and) {
                boolean _notEquals;
                _matched = true;
                ITextRegion textRegion = this.getTextRegion((XImportDeclaration)element, offset);
                boolean bl = _notEquals = !Objects.equal((Object)textRegion, null);
                if (_notEquals) {
                    int _offset = textRegion.getOffset();
                    int _length = textRegion.getLength();
                    Region region = new Region(_offset, _length);
                    Iterable _allFeatures = this._staticallyImportedMemberProvider.getAllFeatures((XImportDeclaration)element);
                    for (JvmFeature feature : _allFeatures) {
                        this.createHyperlinksTo(resource, region, (EObject)feature, acceptor);
                    }
                }
            }
        }
        super.createHyperlinksByOffset(resource, offset, acceptor);
    }

    public ITextRegion getTextRegion(XImportDeclaration it, int offset) {
        List nodes = NodeModelUtils.findNodesForFeature((EObject)it, (EStructuralFeature)XtypePackage.Literals.XIMPORT_DECLARATION__MEMBER_NAME);
        for (INode node : nodes) {
            ITextRegion textRegion = node.getTextRegion();
            boolean _contains = textRegion.contains(offset);
            if (!_contains) continue;
            return textRegion;
        }
        return null;
    }

    protected void createHyperlinksTo(XtextResource resource, INode node, EObject target, IHyperlinkAcceptor acceptor) {
        boolean _isStatic;
        EObject _findActualSemanticObjectFor;
        EObject element = _findActualSemanticObjectFor = NodeModelUtils.findActualSemanticObjectFor((INode)node);
        boolean _matched = false;
        if (!_matched && element instanceof XImportDeclaration && (_isStatic = ((XImportDeclaration)element).isStatic())) {
            _matched = true;
            ITextRegion textRegion = this._iLocationInFileProvider.getSignificantTextRegion(element, (EStructuralFeature)XtypePackage.Literals.XIMPORT_DECLARATION__IMPORTED_TYPE, 0);
            int _offset = textRegion.getOffset();
            int _length = textRegion.getLength();
            Region region = new Region(_offset, _length);
            this.createHyperlinksTo(resource, region, target, acceptor);
        }
        if (!_matched) {
            super.createHyperlinksTo(resource, node, target, acceptor);
        }
    }
}

