/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.wizard.releng;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xtext.ui.wizard.releng.PDEUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogCatalog {
    public static final void openFeatureSelectionDialog(Shell shell, IAcceptor<IProject> acceptor) {
        PDEUtils.selectFeature(shell, acceptor);
    }

    public static String openOSFolderSelectionDialog(Shell shell) {
        DirectoryDialog dialog = new DirectoryDialog(shell, 0x10002000);
        dialog.setMessage("Select Buckminster headless installation directory");
        dialog.setText("Buckminster headless");
        return dialog.open();
    }

    public static IFile openWorkspaceFileSelectionDialog(Shell shell, String patternString, ViewerFilter additionalFilter) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setAllowMultiple(false);
        dialog.setTitle("Select workspace resource");
        dialog.setMessage("Select " + patternString + " file");
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        PatternFilter filter = new PatternFilter();
        filter.setPattern(patternString);
        dialog.addFilter((ViewerFilter)filter);
        if (additionalFilter != null) {
            dialog.addFilter(additionalFilter);
        }
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                IResource resource;
                if (selection.length == 1 && (resource = (IResource)selection[0]) instanceof IFile) {
                    return new Status(0, "org.eclipse.xtext.xtext.ui", "");
                }
                return new Status(4, "org.eclipse.xtext.xtext.ui", "Please select a file.");
            }
        });
        dialog.create();
        dialog.open();
        Object result = dialog.getFirstResult();
        if (!(result instanceof IFile)) {
            return null;
        }
        IFile resource = (IFile)result;
        return resource;
    }

    public static IFile openJunitLaunchSelectionDialog(Shell shell) {
        ViewerFilter viewerFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFile) {
                    IFile file = (IFile)element;
                    ILaunchConfiguration launchConfiguration = DebugPlugin.getDefault().getLaunchManager().getLaunchConfiguration(file);
                    try {
                        if ("JUnit".equals(launchConfiguration.getType().getName())) {
                            return true;
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    return false;
                }
                return true;
            }
        };
        return DialogCatalog.openWorkspaceFileSelectionDialog(shell, "*.launch", viewerFilter);
    }
}

