/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.wizard.project;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.xtext.ui.wizard.IProjectInfo;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xtext.ui.wizard.project.WizardContribution;

public class XtextProjectInfo
implements IProjectInfo {
    private String projectName;
    private String languageName;
    private String fileExtension;
    private String encoding;
    private boolean createTestProject = false;
    private IWorkingSet[] workingSets;
    private IWorkbench workbench;
    private IPath projectsRootLocation;
    private WizardContribution wizardContribution;
    private boolean createEclipseRuntimeLaunchConfig;
    private boolean createFeatureProject;

    public boolean isCreateEclipseRuntimeLaunchConfig() {
        return this.createEclipseRuntimeLaunchConfig;
    }

    public void setCreateEclipseRuntimeLaunchConfig(boolean createEclipseRuntimeLaunchConfig) {
        this.createEclipseRuntimeLaunchConfig = createEclipseRuntimeLaunchConfig;
    }

    public void setWizardContribution(WizardContribution wizardContribution) {
        this.wizardContribution = wizardContribution;
    }

    public WizardContribution getWizardContribution() {
        return this.wizardContribution;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean isCreateTestProject() {
        return this.createTestProject;
    }

    public void setCreateTestProject(boolean createTestProject) {
        this.createTestProject = createTestProject;
    }

    public boolean isCreateFeatureProject() {
        return this.createFeatureProject;
    }

    public void setCreateFeatureProject(boolean createFeatureProject) {
        this.createFeatureProject = createFeatureProject;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public String getLanguageName() {
        return this.languageName;
    }

    public void setLanguageName(String languageName) {
        this.languageName = languageName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getGeneratorProjectName() {
        return String.valueOf(this.getProjectName()) + ".generator";
    }

    public String getTestProjectName() {
        return String.valueOf(this.getProjectName()) + ".tests";
    }

    public String getFeatureProjectName() {
        return String.valueOf(this.getProjectName()) + ".sdk";
    }

    public String getUiProjectName() {
        return String.valueOf(this.getProjectName()) + ".ui";
    }

    public String getBasePackagePath() {
        return this.getBasePackage().replaceAll("\\.", "/");
    }

    public String getBasePackage() {
        int lastIndexOf = this.getLanguageName().lastIndexOf(".");
        return this.getLanguageName().substring(0, lastIndexOf == -1 ? this.getLanguageName().length() : lastIndexOf);
    }

    public String getLanguageNameAbbreviation() {
        String[] packageNames = this.languageName.split("\\.");
        return Strings.toFirstUpper((String)packageNames[packageNames.length - 1]);
    }

    public String getNsURI() {
        String[] strings = this.languageName.split("\\.");
        if (strings.length < 2) {
            return "http://www." + this.languageName;
        }
        String s = "http://www." + strings[1] + "." + strings[0];
        int i = 2;
        while (i < strings.length) {
            s = String.valueOf(s) + "/" + strings[i];
            ++i;
        }
        return s;
    }

    public String getFirstFileExtension() {
        StringTokenizer tokenizer;
        String delim = ",";
        if (this.getFileExtension() != null && this.getFileExtension().contains(delim) && (tokenizer = new StringTokenizer(this.getFileExtension(), delim, false)).hasMoreTokens()) {
            return tokenizer.nextToken().trim();
        }
        return this.fileExtension;
    }

    public void setWorkingSets(IWorkingSet[] workingSets) {
        this.workingSets = workingSets;
    }

    public IWorkingSet[] getWorkingSets() {
        return this.workingSets;
    }

    public void setWorkbench(IWorkbench workbench) {
        this.workbench = workbench;
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public void setProjectsRootLocation(IPath projectsRootLocation) {
        this.projectsRootLocation = projectsRootLocation;
    }

    public IPath getDslProjectLocation() {
        return this.projectsRootLocation.append(this.getProjectName());
    }

    public IPath getUiProjectLocation() {
        return this.projectsRootLocation.append(this.getUiProjectName());
    }

    public IPath getTestProjectLocation() {
        return this.projectsRootLocation.append(this.getTestProjectName());
    }

    public IPath getFeatureProjectLocation() {
        return this.projectsRootLocation.append(this.getFeatureProjectName());
    }

    public String getGrammarFilePath() {
        return String.valueOf(this.getBasePackagePath()) + "/" + this.getLanguageNameAbbreviation() + ".xtext";
    }
}

