/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.util;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTraversalData;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.DeclaratorTypeArgumentCollector;

@NonNullByDefault
public class ConstraintAwareTypeArgumentCollector
extends DeclaratorTypeArgumentCollector {
    private ITypeReferenceOwner owner;

    public ConstraintAwareTypeArgumentCollector(ITypeReferenceOwner owner) {
        this.owner = owner;
    }

    public Boolean doVisitParameterizedTypeReference(ParameterizedTypeReference reference, LightweightTraversalData data) {
        JvmType type = reference.getType();
        if (!type.eIsProxy() && data.getVisited().add(type)) {
            if (type instanceof JvmTypeParameter) {
                JvmTypeParameter typeParameter = (JvmTypeParameter)type;
                if (!data.getTypeParameterMapping().containsKey(type)) {
                    return this.addConstraintMapping(typeParameter, this.owner, data);
                }
            } else {
                return this.doVisitParameterizedTypeReference(reference, type, data);
            }
        }
        return Boolean.FALSE;
    }
}

