/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.xbase.scoping.batch.AbstractFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.AbstractNestedFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.TypeBucket;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedFeatures;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class FeatureScopeSessionWithStaticTypes
extends AbstractNestedFeatureScopeSession {
    private final List<? extends JvmType> staticFeatureProviders;
    private final List<? extends JvmType> extensionProviders;
    private List<TypeBucket> staticallyImportedTypes;
    private List<TypeBucket> staticallyImportedExtensions;
    private IResolvedFeatures.Provider resolvedFeaturesProvider;

    public FeatureScopeSessionWithStaticTypes(AbstractFeatureScopeSession featureScopeSession, List<? extends JvmType> staticFeatureProviders, List<? extends JvmType> extensionProviders, IResolvedFeatures.Provider resolvedFeaturesProvider) {
        super(featureScopeSession);
        this.staticFeatureProviders = staticFeatureProviders;
        this.extensionProviders = extensionProviders;
        this.resolvedFeaturesProvider = resolvedFeaturesProvider;
    }

    @Override
    public List<TypeBucket> getStaticallyImportedTypes() {
        if (this.staticallyImportedTypes != null) {
            return this.staticallyImportedTypes;
        }
        this.staticallyImportedTypes = this.concatTypeBuckets(this.staticFeatureProviders, super.getStaticallyImportedTypes());
        return this.staticallyImportedTypes;
    }

    @Override
    public List<TypeBucket> getStaticallyImportedExtensionTypes() {
        if (this.staticallyImportedExtensions != null) {
            return this.staticallyImportedExtensions;
        }
        this.staticallyImportedExtensions = this.concatTypeBuckets(this.extensionProviders, super.getStaticallyImportedExtensionTypes());
        return this.staticallyImportedExtensions;
    }

    protected List<TypeBucket> concatTypeBuckets(List<? extends JvmType> types, List<TypeBucket> parentResult) {
        if (types.isEmpty()) {
            return parentResult;
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)3);
        result.add(new TypeBucket(this.getId(), types, this.resolvedFeaturesProvider));
        result.addAll(parentResult);
        return result;
    }
}

