/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.resource;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.xtext.resource.IClasspathUriResolver;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.resource.IResourceSetInitializer;
import org.eclipse.xtext.ui.resource.IStorage2UriMapperJdtExtensions;
import org.eclipse.xtext.ui.util.JdtClasspathUriResolver;
import org.eclipse.xtext.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaProjectResourceSetInitializer
implements IResourceSetInitializer {
    private static final Logger LOG = Logger.getLogger(JavaProjectResourceSetInitializer.class);
    @Inject
    private IStorage2UriMapperJdtExtensions storage2UriMapper;

    @Override
    public void initialize(ResourceSet resourceSet, IProject project) {
        if (resourceSet instanceof XtextResourceSet) {
            XtextResourceSet casted = (XtextResourceSet)resourceSet;
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject != null && javaProject.exists()) {
                casted.getURIConverter().getURIMap().putAll(this.computePlatformURIMap(javaProject));
                casted.setClasspathURIContext((Object)javaProject);
                casted.setClasspathUriResolver((IClasspathUriResolver)new JdtClasspathUriResolver());
            }
        }
    }

    protected Map<URI, URI> computePlatformURIMap(IJavaProject javaProject) {
        HashMap hashMap = Maps.newHashMap();
        try {
            hashMap.putAll(EcorePlugin.computePlatformURIMap((boolean)false));
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        if (!javaProject.exists()) {
            return hashMap;
        }
        try {
            IPackageFragmentRoot[] roots;
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots = javaProject.getAllPackageFragmentRoots();
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                Pair<URI, URI> uriMapping = this.storage2UriMapper.getURIMapping(root);
                if (uriMapping != null) {
                    Map<URI, IStorage> mapping = this.storage2UriMapper.getAllEntries(root);
                    for (URI key : mapping.keySet()) {
                        IStorage storage = mapping.get(key);
                        URI physicalURI = null;
                        physicalURI = storage instanceof IFile ? URI.createPlatformResourceURI((String)storage.getFullPath().toString(), (boolean)true) : key.replacePrefix((URI)uriMapping.getFirst(), (URI)uriMapping.getSecond());
                        hashMap.put(key, physicalURI);
                        if (!key.isPlatformResource()) continue;
                        URI pluginURI = URI.createPlatformPluginURI((String)key.toPlatformString(false), (boolean)false);
                        hashMap.put(pluginURI, physicalURI);
                    }
                }
                ++n2;
            }
            IProject project = javaProject.getProject();
            IProject[] iProjectArray = project.getWorkspace().getRoot().getProjects();
            int n3 = iProjectArray.length;
            n = 0;
            while (n < n3) {
                IPath location;
                IProject iProject = iProjectArray[n];
                if (iProject.isAccessible() && (location = iProject.getLocation()) != null) {
                    hashMap.put(URI.createPlatformResourceURI((String)(String.valueOf(iProject.getName()) + "/"), (boolean)true), URI.createFileURI((String)(String.valueOf(location.toFile().getPath()) + "/")));
                }
                ++n;
            }
        }
        catch (JavaModelException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return hashMap;
    }
}

