/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.ui.refactoring.IDependentElementsCalculator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDependentElementsCalculator
implements IDependentElementsCalculator {
    @Inject
    private IQualifiedNameProvider nameProvider;

    public List<URI> getDependentElementURIs(EObject baseElement, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        ArrayList elementURIs = Lists.newArrayList();
        TreeIterator i = EcoreUtil.getAllProperContents((EObject)baseElement, (boolean)false);
        while (i.hasNext()) {
            URI childURI;
            if (progress.isCanceled()) break;
            EObject childElement = (EObject)i.next();
            if (this.nameProvider.getFullyQualifiedName(childElement) != null && (childURI = EcoreUtil.getURI((EObject)childElement)) != null) {
                elementURIs.add(childURI);
            }
            progress.worked(1);
            progress.setWorkRemaining(10);
        }
        return elementURIs;
    }
}

