/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor;

import com.google.inject.ImplementedBy;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.SlaveDocumentEvent;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.widgets.Composite;

public class XtextSourceViewer
extends ProjectionViewer
implements IAdaptable {
    private static final Logger log = Logger.getLogger(XtextSourceViewer.class);
    private int lengthDiff = Integer.MIN_VALUE;

    public XtextSourceViewer(Composite parent, IVerticalRuler ruler, IOverviewRuler overviewRuler, boolean showsAnnotationOverview, int styles) {
        super(parent, ruler, overviewRuler, showsAnnotationOverview, styles);
    }

    public void prependTextPresentationListener(ITextPresentationListener listener) {
        Assert.isNotNull((Object)listener);
        if (this.fTextPresentationListeners == null) {
            this.fTextPresentationListeners = new ArrayList();
        }
        this.fTextPresentationListeners.remove(listener);
        this.fTextPresentationListeners.add(0, listener);
    }

    protected void updateTextListeners(TextViewer.WidgetCommand cmd) {
        if (cmd.event == null && cmd.length == 0 && cmd.start == 0 && cmd.text == null) {
            super.updateTextListeners(cmd);
        } else {
            ArrayList textListeners = this.fTextListeners;
            if (textListeners != null) {
                textListeners = new ArrayList(textListeners);
                DocumentEvent event = cmd.event;
                if (event instanceof SlaveDocumentEvent) {
                    event = ((SlaveDocumentEvent)event).getMasterEvent();
                }
                int usedDiff = 0;
                if (event == null) {
                    if (this.lengthDiff > 0) {
                        usedDiff = this.lengthDiff;
                    }
                    this.lengthDiff = Integer.MIN_VALUE;
                } else {
                    this.lengthDiff = event.fText.length() - event.fLength;
                }
                int length = cmd.length + usedDiff;
                String text = cmd.text;
                if (usedDiff != 0) {
                    try {
                        IRegion model = this.getModelCoverage();
                        length = Math.min(cmd.start + length, model.getLength()) - cmd.start;
                        text = this.getDocument().get(cmd.start + model.getOffset(), length);
                    }
                    catch (BadLocationException e) {
                        length = cmd.length;
                        log.debug((Object)"Ignored BadLocationException when fixing document events", (Throwable)e);
                    }
                }
                TextEvent e = new TextEvent(cmd.start, length, text, cmd.preservedText, event, this.redraws()){};
                int i = 0;
                while (i < textListeners.size()) {
                    ITextListener l = (ITextListener)textListeners.get(i);
                    try {
                        l.textChanged(e);
                    }
                    catch (NullPointerException exception) {
                        log.info((Object)e);
                    }
                    ++i;
                }
            }
        }
    }

    public IContentAssistant getContentAssistant() {
        return this.fContentAssistant;
    }

    public Object getAdapter(Class adapter) {
        if (IReconciler.class.isAssignableFrom(adapter)) {
            return this.fReconciler;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public static class DefaultFactory
    implements Factory {
        public XtextSourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, IOverviewRuler overviewRuler, boolean showsAnnotationOverview, int styles) {
            return new XtextSourceViewer(parent, ruler, overviewRuler, showsAnnotationOverview, styles);
        }
    }

    @ImplementedBy(value=DefaultFactory.class)
    public static interface Factory {
        public XtextSourceViewer createSourceViewer(Composite var1, IVerticalRuler var2, IOverviewRuler var3, boolean var4, int var5);
    }
}

