/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.references;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypes;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeKind;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypes;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.OwnedConverter;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitor;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithParameter;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithParameterAndResult;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithResult;
import org.eclipse.xtext.xbase.typesystem.util.IVisibilityHelper;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class ParameterizedTypeReference
extends LightweightTypeReference {
    private List<LightweightTypeReference> typeArguments;
    private JvmType type;
    protected boolean resolved;

    public ParameterizedTypeReference(ITypeReferenceOwner owner, JvmType type) {
        super(owner);
        if (type == null) {
            throw new NullPointerException("type may not be null");
        }
        if (type instanceof JvmArrayType) {
            throw new IllegalArgumentException("type may not be an array type");
        }
        this.type = type;
        this.resolved = !(type instanceof JvmTypeParameter);
    }

    @Override
    public JvmTypeReference toTypeReference() {
        JvmParameterizedTypeReference result = this.getTypesFactory().createJvmParameterizedTypeReference();
        result.setType(this.type);
        if (this.typeArguments != null) {
            for (LightweightTypeReference typeArgument : this.typeArguments) {
                result.getArguments().add((Object)typeArgument.toTypeReference());
            }
        }
        return result;
    }

    protected boolean isTypeVisible(IVisibilityHelper visibilityHelper) {
        return !(this.type instanceof JvmDeclaredType) || visibilityHelper.isVisible((JvmMember)((JvmDeclaredType)this.type));
    }

    @Override
    public boolean isVisible(IVisibilityHelper visibilityHelper) {
        if (this.isTypeVisible(visibilityHelper)) {
            if (this.typeArguments != null) {
                for (LightweightTypeReference typeArgument : this.typeArguments) {
                    if (typeArgument.isVisible(visibilityHelper)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public JvmTypeReference toJavaCompliantTypeReference(IVisibilityHelper visibilityHelper) {
        if (this.isTypeVisible(visibilityHelper)) {
            JvmParameterizedTypeReference result = this.getTypesFactory().createJvmParameterizedTypeReference();
            result.setType(this.type);
            if (this.typeArguments != null) {
                for (LightweightTypeReference typeArgument : this.typeArguments) {
                    result.getArguments().add((Object)typeArgument.toJavaCompliantTypeReference());
                }
            }
            return result;
        }
        return this.toJavaCompliantTypeReference(this.getSuperTypes(), visibilityHelper);
    }

    @Override
    public JvmType getType() {
        return this.type;
    }

    @Override
    protected boolean isRawType(Set<JvmType> seenTypes) {
        if (this.type instanceof JvmGenericType) {
            if (!((JvmGenericType)this.type).getTypeParameters().isEmpty() && this.expose(this.typeArguments).isEmpty()) {
                return true;
            }
        } else if (this.type instanceof JvmTypeParameter && seenTypes.add(this.type)) {
            JvmTypeParameter typeParameter = (JvmTypeParameter)this.type;
            EList constraints = typeParameter.getConstraints();
            for (JvmTypeConstraint constraint : constraints) {
                JvmTypeReference typeReference = constraint.getTypeReference();
                LightweightTypeReference lightweightConstraint = new OwnedConverter(this.getOwner()).toLightweightReference(typeReference);
                if (!lightweightConstraint.isRawType(seenTypes)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isOwnedBy(ITypeReferenceOwner owner) {
        if (super.isOwnedBy(owner)) {
            for (LightweightTypeReference typeArgument : this.expose(this.typeArguments)) {
                if (typeArgument.isOwnedBy(owner)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public LightweightTypeReference getWrapperTypeIfPrimitive() {
        if (this.type instanceof JvmPrimitiveType) {
            Primitives primitives = this.getOwner().getServices().getPrimitives();
            JvmType wrapperType = primitives.getWrapperType((JvmPrimitiveType)this.type);
            return new ParameterizedTypeReference(this.getOwner(), wrapperType);
        }
        return this;
    }

    @Override
    public LightweightTypeReference getPrimitiveIfWrapperType() {
        Primitives primitives;
        JvmType primitiveType;
        if (this.type instanceof JvmDeclaredType && (primitiveType = (primitives = this.getOwner().getServices().getPrimitives()).getPrimitiveTypeIfWrapper((JvmDeclaredType)this.type)) != null) {
            return new ParameterizedTypeReference(this.getOwner(), primitiveType);
        }
        return this;
    }

    @Override
    public boolean isPrimitive() {
        return this.type instanceof JvmPrimitiveType;
    }

    @Override
    protected boolean isInterfaceType() {
        if (this.type instanceof JvmGenericType) {
            return ((JvmGenericType)this.type).isInterface();
        }
        return false;
    }

    @Override
    public boolean isWrapper() {
        if (this.type instanceof JvmDeclaredType || this.type instanceof JvmTypeParameter) {
            Primitives primitives = this.getOwner().getServices().getPrimitives();
            boolean result = primitives.isWrapperType(this.type);
            return result;
        }
        return false;
    }

    @Override
    protected List<LightweightTypeReference> getSuperTypes(TypeParameterSubstitutor<?> substitutor) {
        EList constraints;
        if (this.type instanceof JvmDeclaredType) {
            EList superTypes = ((JvmDeclaredType)this.type).getSuperTypes();
            if (!superTypes.isEmpty()) {
                if (!this.isRawType()) {
                    OwnedConverter converter = new OwnedConverter(this.getOwner());
                    ArrayList result = Lists.newArrayListWithCapacity((int)superTypes.size());
                    for (JvmTypeReference superType : superTypes) {
                        LightweightTypeReference lightweightSuperType = converter.toLightweightReference(superType);
                        if (lightweightSuperType.isType(Object.class) && superTypes.size() != 1) continue;
                        result.add(substitutor.substitute(lightweightSuperType));
                    }
                    return result;
                }
                OwnedConverter converter = new OwnedConverter(this.getOwner());
                ArrayList result = Lists.newArrayListWithCapacity((int)superTypes.size());
                for (JvmTypeReference superType : superTypes) {
                    LightweightTypeReference lightweightSuperType = converter.toLightweightReference(superType);
                    if (lightweightSuperType.isType(Object.class) && superTypes.size() != 1) continue;
                    result.add(substitutor.substitute(lightweightSuperType).getRawTypeReference());
                }
                return result;
            }
        } else if (this.type instanceof JvmTypeParameter && !(constraints = ((JvmTypeParameter)this.type).getConstraints()).isEmpty()) {
            ArrayList result = Lists.newArrayListWithCapacity((int)constraints.size());
            OwnedConverter converter = new OwnedConverter(this.getOwner());
            for (JvmTypeConstraint constraint : constraints) {
                if (!(constraint instanceof JvmUpperBound) || constraint.getTypeReference() == null) continue;
                LightweightTypeReference upperBound = converter.toLightweightReference(constraint.getTypeReference());
                result.add(substitutor.substitute(upperBound));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    @Nullable
    public LightweightTypeReference getSuperType(JvmType rawType) {
        if (rawType == this.type) {
            return this;
        }
        JvmTypeReference superType = this.getSuperType(rawType, this.type, Sets.newHashSetWithExpectedSize((int)3));
        if (superType != null) {
            if (superType instanceof JvmParameterizedTypeReference && ((JvmParameterizedTypeReference)superType).getArguments().isEmpty()) {
                return new ParameterizedTypeReference(this.getOwner(), rawType);
            }
            JvmParameterizedTypeReference plainSuperType = this.getServices().getTypeReferences().createTypeRef(rawType, new JvmTypeReference[0]);
            OwnedConverter converter = new OwnedConverter(this.getOwner());
            LightweightTypeReference unresolved = converter.toLightweightReference((JvmTypeReference)plainSuperType);
            TypeParameterSubstitutor<?> substitutor = this.createSubstitutor();
            LightweightTypeReference result = substitutor.substitute(unresolved);
            if (this.isRawType()) {
                result = result.getRawTypeReference();
            }
            return result;
        }
        return null;
    }

    @Nullable
    protected JvmTypeReference getSuperType(JvmType rawType, JvmType thisType, Set<JvmType> seenTypes) {
        if (thisType == rawType || !seenTypes.add(thisType)) {
            return null;
        }
        if (thisType instanceof JvmGenericType && rawType instanceof JvmGenericType) {
            if (!"java.lang.Object".equals(rawType.getIdentifier())) {
                if (((JvmGenericType)thisType).isInterface() && !((JvmGenericType)rawType).isInterface()) {
                    return null;
                }
            } else {
                return this.getServices().getTypeReferences().createTypeRef(rawType, new JvmTypeReference[0]);
            }
        }
        if (thisType instanceof JvmDeclaredType) {
            EList superTypes = ((JvmDeclaredType)thisType).getSuperTypes();
            for (JvmTypeReference superType : superTypes) {
                if (superType.getType() == rawType) {
                    return superType;
                }
                JvmTypeReference result = this.getSuperType(rawType, superType.getType(), seenTypes);
                if (result == null) continue;
                return result;
            }
        } else if (thisType instanceof JvmTypeParameter) {
            EList constraints = ((JvmTypeParameter)thisType).getConstraints();
            for (JvmTypeConstraint constraint : constraints) {
                if (!(constraint instanceof JvmUpperBound) || constraint.getTypeReference() == null) continue;
                JvmTypeReference superType = constraint.getTypeReference();
                if (superType.getType() == rawType) {
                    return superType;
                }
                JvmTypeReference result = this.getSuperType(rawType, superType.getType(), seenTypes);
                if (result == null) continue;
                return result;
            }
        } else if (thisType instanceof JvmArrayType) {
            String identifier = rawType.getIdentifier();
            if (Cloneable.class.getCanonicalName().equals(identifier) || Serializable.class.getCanonicalName().equals(identifier) || Object.class.getCanonicalName().equals(identifier)) {
                return this.getServices().getTypeReferences().createTypeRef(rawType, new JvmTypeReference[0]);
            }
        }
        return null;
    }

    @Override
    public List<LightweightTypeReference> getTypeArguments() {
        return this.expose(this.typeArguments);
    }

    @Override
    protected ParameterizedTypeReference doCopyInto(ITypeReferenceOwner owner) {
        ParameterizedTypeReference result = new ParameterizedTypeReference(owner, this.type);
        this.copyTypeArguments(result, owner);
        return result;
    }

    protected void copyTypeArguments(ParameterizedTypeReference result, ITypeReferenceOwner owner) {
        if (this.typeArguments != null && !this.typeArguments.isEmpty()) {
            for (LightweightTypeReference typeArgument : this.typeArguments) {
                result.addTypeArgument(typeArgument.copyInto(owner));
            }
        }
    }

    @Override
    public boolean isResolved() {
        return this.resolved;
    }

    public void addTypeArgument(LightweightTypeReference argument) {
        if (argument == null) {
            throw new NullPointerException("argument may not be null");
        }
        if (!argument.isOwnedBy(this.getOwner())) {
            throw new IllegalArgumentException("argument is not valid in current context");
        }
        if (this.typeArguments == null) {
            this.typeArguments = Lists.newArrayListWithCapacity((int)2);
        }
        this.typeArguments.add(argument);
        this.resolved = this.resolved && argument.isResolved();
    }

    @Override
    public String getSimpleName() {
        return this.getAsString(this.type.getSimpleName(), new LightweightTypeReference.SimpleNameFunction());
    }

    @Override
    public String getIdentifier() {
        return this.getAsString(this.type.getIdentifier(), new LightweightTypeReference.IdentifierFunction());
    }

    @Override
    public String getJavaIdentifier() {
        return this.getAsString(this.type.getIdentifier(), new LightweightTypeReference.JavaIdentifierFunction());
    }

    protected String getAsString(String type, Function<LightweightTypeReference, String> format) {
        if (this.typeArguments != null) {
            return String.valueOf(type) + "<" + Joiner.on((String)", ").join(Iterables.transform(this.typeArguments, format)) + ">";
        }
        return type;
    }

    @Override
    public boolean isType(Class<?> clazz) {
        if (this.type != null) {
            return clazz.getCanonicalName().equals(this.type.getIdentifier());
        }
        return false;
    }

    @Override
    public void accept(TypeReferenceVisitor visitor) {
        visitor.doVisitParameterizedTypeReference(this);
    }

    @Override
    public <Param> void accept(TypeReferenceVisitorWithParameter<Param> visitor, Param param) {
        visitor.doVisitParameterizedTypeReference(this, param);
    }

    @Override
    @Nullable
    public <Result> Result accept(TypeReferenceVisitorWithResult<Result> visitor) {
        return visitor.doVisitParameterizedTypeReference(this);
    }

    @Override
    @Nullable
    public <Param, Result> Result accept(TypeReferenceVisitorWithParameterAndResult<Param, Result> visitor, Param param) {
        return visitor.doVisitParameterizedTypeReference(this, param);
    }

    @Override
    public FunctionTypeKind getFunctionTypeKind() {
        FunctionTypes functionTypes = this.getServices().getFunctionTypes();
        return functionTypes.getFunctionTypeKind(this);
    }

    @Override
    @Nullable
    public FunctionTypeReference getAsFunctionTypeReference() {
        FunctionTypes functionTypes = this.getServices().getFunctionTypes();
        return functionTypes.getAsFunctionTypeReference(this);
    }

    @Override
    @Nullable
    public FunctionTypeReference tryConvertToFunctionTypeReference(boolean rawType) {
        FunctionTypes functionTypes = this.getServices().getFunctionTypes();
        return functionTypes.tryConvertToFunctionTypeReference(this, rawType);
    }

    @Override
    @Nullable
    public ArrayTypeReference tryConvertToArray() {
        ArrayTypes arrayTypes = this.getServices().getArrayTypes();
        return arrayTypes.tryConvertToArray(this);
    }

    @Override
    @Nullable
    public LightweightTypeReference tryConvertToListType() {
        if (this.isAssignableFrom(List.class)) {
            return this;
        }
        return super.tryConvertToListType();
    }

    public ParameterizedTypeReference toInstanceTypeReference() {
        ParameterizedTypeReference result = new ParameterizedTypeReference(this.getOwner(), this.getType());
        for (LightweightTypeReference typeArgument : this.getTypeArguments()) {
            result.addTypeArgument(typeArgument.getInvariantBoundSubstitute());
        }
        return result;
    }
}

