/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.jvmmodel;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.util.TypeReferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvmModelCompleter {
    @Inject
    private TypeReferences references;

    public void complete(Iterable<? extends JvmIdentifiableElement> elements) {
        for (JvmIdentifiableElement jvmIdentifiableElement : elements) {
            this.complete(jvmIdentifiableElement);
        }
    }

    public void complete(JvmIdentifiableElement element) {
        if (element instanceof JvmGenericType) {
            this.completeJvmGenericType((JvmGenericType)element);
        }
        if (element instanceof JvmDeclaredType) {
            JvmDeclaredType declaredType = (JvmDeclaredType)element;
            this.complete((Iterable<? extends JvmIdentifiableElement>)declaredType.getMembers());
        }
        if (element instanceof JvmConstructor) {
            this.completeJvmConstructor((JvmConstructor)element);
        }
        if (element instanceof JvmEnumerationType) {
            this.completeJvmEnumerationType((JvmEnumerationType)element);
        }
        if (element instanceof JvmEnumerationLiteral) {
            this.completeJvmEnumerationLiteral((JvmEnumerationLiteral)element);
        }
    }

    protected void completeJvmEnumerationType(JvmEnumerationType element) {
        this.ensureSuperTypeObject((JvmDeclaredType)element);
    }

    protected void completeJvmEnumerationLiteral(JvmEnumerationLiteral element) {
        if (element.getType() == null) {
            element.setType((JvmTypeReference)this.references.createTypeRef((JvmType)element.getDeclaringType(), new JvmTypeReference[0]));
        }
    }

    public void completeJvmConstructor(JvmConstructor constructor) {
        String simpleName;
        JvmDeclaredType declaringType = constructor.getDeclaringType();
        if (declaringType != null && (simpleName = declaringType.getSimpleName()) != null) {
            constructor.setSimpleName(simpleName);
            return;
        }
        constructor.setSimpleName("unset");
    }

    protected void completeJvmGenericType(JvmGenericType element) {
        this.ensureSuperTypeObject((JvmDeclaredType)element);
        if (!element.isInterface() && Iterables.isEmpty((Iterable)element.getDeclaredConstructors())) {
            JvmConstructor constructor = TypesFactory.eINSTANCE.createJvmConstructor();
            constructor.setSimpleName(element.getSimpleName());
            constructor.setVisibility(JvmVisibility.PUBLIC);
            element.getMembers().add((Object)constructor);
        }
    }

    protected void ensureSuperTypeObject(JvmDeclaredType element) {
        JvmTypeReference objectType;
        if (element.getSuperTypes().isEmpty() && (objectType = this.references.getTypeForName(Object.class, (Notifier)element, new JvmTypeReference[0])) != null) {
            element.getSuperTypes().add((Object)objectType);
        }
    }
}

