/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.scoping.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleScope
extends AbstractScope {
    private final Iterable<IEObjectDescription> descriptions;
    protected Set<Object> shadowingIndex;

    public SimpleScope(IScope parent, Iterable<IEObjectDescription> descriptions, boolean ignoreCase) {
        super(parent, ignoreCase);
        if (descriptions == null) {
            throw new IllegalArgumentException("descriptions may not be null");
        }
        this.descriptions = descriptions;
    }

    public SimpleScope(IScope parent, Iterable<IEObjectDescription> descriptions) {
        this(parent, descriptions, false);
    }

    public SimpleScope(Iterable<IEObjectDescription> descriptions, boolean ignoreCase) {
        this(IScope.NULLSCOPE, descriptions, ignoreCase);
    }

    public SimpleScope(Iterable<IEObjectDescription> descriptions) {
        this(IScope.NULLSCOPE, descriptions, false);
    }

    @Override
    protected Iterable<IEObjectDescription> getAllLocalElements() {
        return this.descriptions;
    }

    @Override
    protected Iterable<IEObjectDescription> getLocalElementsByEObject(final EObject object, final URI uri) {
        Iterable<IEObjectDescription> localElements = this.getAllLocalElements();
        Iterable result = Iterables.filter(localElements, (Predicate)new Predicate<IEObjectDescription>(){

            public boolean apply(IEObjectDescription input) {
                if (input.getEObjectOrProxy() == object) {
                    return this.canBeFoundByNameAndShadowingKey(input);
                }
                if (uri.equals((Object)input.getEObjectURI())) {
                    return this.canBeFoundByNameAndShadowingKey(input);
                }
                return false;
            }

            public boolean canBeFoundByNameAndShadowingKey(IEObjectDescription input) {
                Iterable<IEObjectDescription> lookUp = SimpleScope.this.getLocalElementsByName(input.getName());
                Object myShadowingKey = SimpleScope.this.getShadowingKey(input);
                for (IEObjectDescription other : lookUp) {
                    if (!myShadowingKey.equals(SimpleScope.this.getShadowingKey(other))) continue;
                    if (other == input) {
                        return true;
                    }
                    if (other.getEObjectOrProxy() == object) {
                        return true;
                    }
                    return uri.equals((Object)other.getEObjectURI());
                }
                return false;
            }
        });
        return result;
    }

    protected Object getShadowingKey(IEObjectDescription description) {
        if (this.isIgnoreCase()) {
            return description.getName().toLowerCase();
        }
        return description.getName();
    }

    @Override
    protected boolean isShadowed(IEObjectDescription fromParent) {
        if (this.shadowingIndex == null) {
            this.shadowingIndex = Sets.newHashSet();
            for (IEObjectDescription local : this.getAllLocalElements()) {
                this.shadowingIndex.add(this.getShadowingKey(local));
            }
        }
        boolean result = this.shadowingIndex.contains(this.getShadowingKey(fromParent));
        return result;
    }
}

