/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4.parameterized;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.junit4.parameterized.IParameterProvider;
import org.eclipse.xtext.junit4.parameterized.Offset;
import org.eclipse.xtext.junit4.parameterized.ParameterSyntax;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parsetree.reconstr.impl.NodeIterator;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.Exceptions;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.Wrapper;
import org.eclipse.xtext.util.formallang.FollowerFunction;
import org.eclipse.xtext.util.formallang.FollowerFunctionImpl;
import org.eclipse.xtext.util.formallang.Nfa;
import org.eclipse.xtext.util.formallang.NfaUtil;
import org.eclipse.xtext.util.formallang.Production;
import org.eclipse.xtext.util.formallang.StringProduction;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XpectParameterProvider
implements IParameterProvider {
    public static final String PARAM_OFFSET = "offset";
    public static final String PARAM_RESOURCE = "resource";
    protected static final Pattern WS = Pattern.compile("^[\\s]+");
    protected static Pattern XPECT_PATTERN = Pattern.compile("(\\S)?XPECT(_CLASS|_IMPORT)?\\s+([a-zA-Z0-9]*)");

    @Override
    public void collectParameters(Class<?> testClass, XtextResource resource, IParameterProvider.IParameterAcceptor acceptor) {
        this.collectTestMethods(testClass, resource, acceptor);
        for (ILeafNode leaf : resource.getParseResult().getRootNode().getLeafNodes()) {
            if (!leaf.isHidden() || !leaf.getText().contains("XPECT")) continue;
            this.parseLeaf(testClass, resource, leaf, acceptor);
        }
    }

    protected void collectTestMethods(Class<?> testClass, XtextResource res, IParameterProvider.IParameterAcceptor acceptor) {
        Method[] methodArray = testClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Test annotation;
            Method meth = methodArray[n2];
            if (Modifier.isPublic(meth.getModifiers()) && !Modifier.isStatic(meth.getModifiers()) && (annotation = meth.getAnnotation(Test.class)) != null) {
                acceptor.acceptTest(null, meth.getName(), this.getDefaultParams(res, 0), null, false);
            }
            ++n2;
        }
    }

    protected Iterable<Object> convertValue(XtextResource res, INode ctx, int offset, Token token, String value) {
        switch (token) {
            case OFFSET: {
                int add = value.indexOf(124);
                if (add >= 0) {
                    value = String.valueOf(value.substring(0, add)) + value.substring(add + 1);
                } else {
                    add = 0;
                }
                String text = ctx.getRootNode().getText();
                int result = text.indexOf(value, offset);
                if (result >= 0) {
                    int off = result + add;
                    return Lists.newArrayList((Object[])new Object[]{off, new Offset(res, off)});
                }
                throw new RuntimeException("OFFSET '" + value + "' not found");
            }
            case INT: {
                ArrayList r = Lists.newArrayList();
                try {
                    r.add(Integer.valueOf(value));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    r.add(new BigInteger(value));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                r.add(value);
                return r;
            }
            case ID: 
            case STRING: 
            case TEXT: {
                return Collections.singleton(value);
            }
        }
        return Collections.singleton(value);
    }

    protected Multimap<String, Object> getDefaultParams(XtextResource res, int offset) {
        HashMultimap result = HashMultimap.create();
        result.put((Object)PARAM_RESOURCE, (Object)res);
        result.put((Object)PARAM_OFFSET, (Object)offset);
        result.put((Object)PARAM_OFFSET, (Object)new Offset(res, offset));
        return result;
    }

    protected String getIndentation(INode ctx, int offset) {
        String text = ctx.getRootNode().getText();
        int nl = text.lastIndexOf("\n", offset);
        if (nl < 0) {
            nl = 0;
        }
        StringBuilder result = new StringBuilder();
        int i = nl + 1;
        while (i < text.length() && Character.isWhitespace(text.charAt(i))) {
            result.append(text.charAt(i));
            ++i;
        }
        return result.toString();
    }

    protected int getOffsetOfNextSemanticNode(INode node) {
        NodeIterator it = new NodeIterator(node);
        while (it.hasNext()) {
            INode n = (INode)it.next();
            if (!(n instanceof ILeafNode) || ((ILeafNode)n).isHidden()) continue;
            return n.getOffset();
        }
        return node.getOffset() + node.getLength();
    }

    protected Nfa<StringProduction.ProdElement> getParameterNfa(String syntax) {
        AssignedProduction prod = new AssignedProduction(syntax);
        FollowerFunctionImpl ff = new FollowerFunctionImpl((Production)prod);
        AssignedProduction assignedProduction = prod;
        ((Object)((Object)assignedProduction)).getClass();
        StringProduction.ProdElement start = new StringProduction.ProdElement((StringProduction)assignedProduction, StringProduction.ElementType.TOKEN);
        AssignedProduction assignedProduction2 = prod;
        ((Object)((Object)assignedProduction2)).getClass();
        StringProduction.ProdElement stop = new StringProduction.ProdElement((StringProduction)assignedProduction2, StringProduction.ElementType.TOKEN);
        Nfa result = new NfaUtil().create((Production)prod, (FollowerFunction)ff, (Object)start, (Object)stop);
        return result;
    }

    protected String getParameterSyntax(Class<?> testClass, String methodName) {
        try {
            Method method = testClass.getMethod(methodName, new Class[0]);
            ParameterSyntax annotation = method.getAnnotation(ParameterSyntax.class);
            if (annotation != null) {
                return annotation.value();
            }
        }
        catch (SecurityException e) {
            Exceptions.throwUncheckedException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            Exceptions.throwUncheckedException((Throwable)e);
        }
        return null;
    }

    protected void parseLeaf(Class<?> testClass, XtextResource resource, ILeafNode leaf, IParameterProvider.IParameterAcceptor acceptor) {
        String text = leaf.getText();
        Matcher matcher = XPECT_PATTERN.matcher(text);
        int offset = 0;
        while (offset < text.length() && matcher.find(offset)) {
            if (matcher.group(2) == null) {
                int newOffset = this.parseXpect(testClass, resource, (INode)leaf, text, matcher.group(3), matcher.end(), acceptor, matcher.group(1) != null);
                if (newOffset >= 0) {
                    offset = newOffset;
                    continue;
                }
                offset = matcher.end();
                continue;
            }
            if (!"_IMPORT".equals(matcher.group(2))) continue;
            offset = this.parseXpectImport(resource, text, matcher.end(2), acceptor);
        }
    }

    protected int parseString(String text, int offset, Wrapper<String> value) {
        if (offset < text.length() && text.charAt(offset) == '\"') {
            int i = offset + 1;
            while (offset < text.length() && text.charAt(i - 1) == '\\' || text.charAt(i) != '\"') {
                ++i;
            }
            if (text.charAt(i) == '\"') {
                value.set((Object)text.substring(offset + 1, i - 1));
                return i;
            }
        }
        return -1;
    }

    protected int parseStringOrText(String text, int offset, Wrapper<String> value) {
        int newOffset = this.parseString(text, offset, value);
        if (newOffset < 0) {
            newOffset = this.parseText(text, offset, value);
        }
        return newOffset;
    }

    protected int parseText(String text, int offset, Wrapper<String> value) {
        int i = offset;
        while (i < text.length()) {
            switch (text.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    value.set((Object)text.substring(offset, i));
                    return i;
                }
            }
            ++i;
        }
        value.set((Object)text.substring(offset, i));
        return i;
    }

    protected int parseXpect(Class<?> testClass, XtextResource res, INode ctx, String text, String method, int offset, IParameterProvider.IParameterAcceptor acceptor, boolean ignore) {
        HashMultimap params = HashMultimap.create();
        Wrapper expectation = new Wrapper(null);
        int newOffset = this.parseXpectParams(testClass, res, ctx, method, text, offset = this.skipWhitespace(text, offset), (Multimap<String, Object>)params);
        if (newOffset >= 0) {
            offset = newOffset;
        }
        if ((newOffset = this.parseXpectSLExpectation(ctx, text, offset = this.skipWhitespace(text, offset), (Wrapper<Expectation>)expectation)) >= 0) {
            offset = newOffset;
        } else {
            newOffset = this.parseXpectMLExpectation(ctx, text, offset, (Wrapper<Expectation>)expectation);
            if (newOffset >= 0) {
                offset = newOffset;
            }
        }
        acceptor.acceptTest(null, method, (Multimap<String, Object>)params, (IParameterProvider.IExpectation)expectation.get(), ignore);
        return offset;
    }

    protected int parseXpectImport(XtextResource res, String text, int offset, IParameterProvider.IParameterAcceptor acceptor) {
        int end;
        String fileName = text.substring(offset = this.skipWhitespace(text, offset), end = text.indexOf("\n", offset)).trim();
        URI uri = URI.createURI((String)fileName);
        if (uri.isRelative() && !res.getURI().isRelative()) {
            uri = uri.resolve(res.getURI());
        }
        acceptor.acceptImportURI(uri);
        return end;
    }

    protected int parseXpectMLExpectation(INode node, String text, int offset, Wrapper<Expectation> expectation) {
        if (offset + 3 < text.length() && text.substring(offset, offset + 3).equals("---")) {
            String substring;
            String indentation = this.getIndentation(node, node.getOffset() + offset);
            int start = text.indexOf(10, offset + 3);
            int end = text.indexOf("---", offset + 3);
            if (start >= 0 && end >= 0 && (end = (substring = text.substring(start + 1, end)).lastIndexOf(10)) >= 0) {
                String exp = substring.substring(0, end);
                int len = exp.length();
                if (exp.startsWith(indentation)) {
                    exp = exp.substring(indentation.length());
                }
                exp = exp.replace("\n" + indentation, "\n");
                expectation.set((Object)new Expectation(node.getOffset() + start + 1, len, exp, indentation));
                return end + start + 1;
            }
        }
        return -1;
    }

    protected int parseXpectParams(Class<?> testClass, XtextResource res, INode node, String methodName, final String text, int offset, Multimap<String, Object> params) {
        int semanticOffset = this.getOffsetOfNextSemanticNode(node);
        params.putAll(this.getDefaultParams(res, semanticOffset));
        String paramSyntax = this.getParameterSyntax(testClass, methodName);
        if (Strings.isEmpty((String)paramSyntax)) {
            return -1;
        }
        Nfa<StringProduction.ProdElement> nfa = this.getParameterNfa(paramSyntax);
        List trace = new NfaUtil().backtrack(nfa, (Object)new BacktrackItem(offset), (NfaUtil.BacktrackHandler)new NfaUtil.BacktrackHandler<StringProduction.ProdElement, BacktrackItem>(){

            public BacktrackItem handle(StringProduction.ProdElement state, BacktrackItem previous) {
                if (Strings.isEmpty((String)state.getValue())) {
                    return previous;
                }
                if (Strings.isEmpty((String)state.getName())) {
                    if (text.regionMatches(previous.offset, state.getValue(), 0, state.getValue().length())) {
                        int newOffset = previous.offset + state.getValue().length();
                        Matcher ws = WS.matcher(text).region(newOffset, text.length());
                        int childOffset = ws.find() ? ws.end() : newOffset;
                        return new BacktrackItem(childOffset, state, state.getValue());
                    }
                } else {
                    Token t = Token.valueOf(state.getValue());
                    Matcher matcher = t.pattern.matcher(text).region(previous.offset, text.length());
                    if (matcher.find()) {
                        Matcher ws = WS.matcher(text).region(matcher.end(), text.length());
                        int childOffset = ws.find() ? ws.end() : matcher.end();
                        String value = matcher.groupCount() > 0 && matcher.group(1) != null ? matcher.group(1) : matcher.group(0);
                        return new BacktrackItem(childOffset, state, value);
                    }
                }
                return null;
            }

            public boolean isSolution(BacktrackItem result) {
                return true;
            }

            public Iterable<StringProduction.ProdElement> sortFollowers(BacktrackItem result, Iterable<StringProduction.ProdElement> followers) {
                return followers;
            }
        });
        if (trace != null && !trace.isEmpty()) {
            for (BacktrackItem item : trace) {
                if (item.token == null || item.token.getName() == null) continue;
                String key = item.token.getName();
                params.removeAll((Object)key);
                params.putAll((Object)key, this.convertValue(res, node, semanticOffset, Token.valueOf(item.token.getValue()), item.value));
            }
            return ((BacktrackItem)trace.get((int)(trace.size() - 1))).offset;
        }
        return -1;
    }

    protected int parseXpectSLExpectation(INode node, String text, int offset, Wrapper<Expectation> expectation) {
        if (offset + 3 < text.length() && text.substring(offset, offset + 3).equals("-->")) {
            int end;
            int begin = offset + 3;
            if (text.charAt(begin) == '\r' || text.charAt(begin) == '\n') {
                expectation.set((Object)new Expectation(node.getOffset() + begin, 0, ""));
                return begin;
            }
            if (Character.isWhitespace(text.charAt(begin))) {
                ++begin;
            }
            if ((end = text.indexOf(10, begin)) < 0) {
                end = text.length();
            }
            String exp = text.substring(begin, end);
            expectation.set((Object)new Expectation(node.getOffset() + begin, exp.length(), exp));
            return end;
        }
        return -1;
    }

    protected int skipWhitespace(String text, int offset) {
        int i;
        for (i = offset; i < text.length(); ++i) {
            if (Character.isWhitespace(text.charAt(i))) {
                continue;
            }
            return i;
        }
        return i;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AssignedProduction
    extends StringProduction {
        public AssignedProduction(String production) {
            super(production);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected StringProduction.ProdElement parsePrim(Stack<Pair<StringProduction.Token, String>> tokens) {
            Pair<StringProduction.Token, String> current = tokens.pop();
            switch ((StringProduction.Token)current.getFirst()) {
                case PL: {
                    StringProduction.ProdElement result1 = this.parseAlt(tokens);
                    if (!((StringProduction.Token)tokens.peek().getFirst()).equals((Object)StringProduction.Token.PR)) {
                        throw new RuntimeException("')' expected, but " + tokens.peek().getFirst() + " found");
                    }
                    tokens.pop();
                    this.parseCardinality(tokens, result1);
                    return result1;
                }
                case STRING: {
                    StringProduction.ProdElement result2 = this.createElement(StringProduction.ElementType.TOKEN);
                    result2.setValue((String)current.getSecond());
                    this.parseCardinality(tokens, result2);
                    return result2;
                }
                case ID: {
                    StringProduction.ProdElement result3 = this.createElement(StringProduction.ElementType.TOKEN);
                    result3.setName((String)current.getSecond());
                    Pair<StringProduction.Token, String> eq = tokens.pop();
                    if (eq.getFirst() != StringProduction.Token.EQ) throw new RuntimeException("Unexpected token " + eq.getFirst() + ", expected '='");
                    Pair<StringProduction.Token, String> val = tokens.pop();
                    switch ((StringProduction.Token)val.getFirst()) {
                        case ID: 
                        case STRING: {
                            result3.setValue((String)val.getSecond());
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unexpected token " + current.getFirst());
                        }
                    }
                    this.parseCardinality(tokens, result3);
                    return result3;
                }
            }
            throw new RuntimeException("Unexpected token " + current.getFirst());
        }
    }

    protected static class BacktrackItem {
        protected int offset;
        protected StringProduction.ProdElement token;
        protected String value;

        public BacktrackItem(int offset) {
            this.offset = offset;
        }

        public BacktrackItem(int offset, StringProduction.ProdElement token, String value) {
            this.offset = offset;
            this.token = token;
            this.value = value;
        }

        public String toString() {
            return this.token + ":" + this.value;
        }
    }

    protected static class Expectation
    implements IParameterProvider.IExpectation {
        protected String expectation;
        protected String indentation = null;
        protected int lenght;
        protected int offset;

        public Expectation(int offset, int lenght, String expectation) {
            this.offset = offset;
            this.lenght = lenght;
            this.expectation = expectation;
        }

        public Expectation(int offset, int lenght, String expectation, String indentation) {
            this.offset = offset;
            this.lenght = lenght;
            this.expectation = expectation;
            this.indentation = indentation;
        }

        public String getExpectation() {
            return this.expectation;
        }

        public String getIndentation() {
            return this.indentation;
        }

        public int getLength() {
            return this.lenght;
        }

        public int getOffset() {
            return this.offset;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Token {
        ID("[a-zA-Z][a-zA-Z0-9_]*"),
        INT("[0-9]+"),
        OFFSET("'([^']*)'|[^\\s]+"),
        STRING("'([^']*)'"),
        TEXT("[^\\s]+");

        public final Pattern pattern;

        private Token(String regex) {
            this.pattern = Pattern.compile("^" + regex);
        }
    }
}

