/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl;

import java.util.Collection;
import java.util.Queue;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.builder.impl.QueuedBuildData;
import org.eclipse.xtext.builder.impl.ToBeBuilt;
import org.eclipse.xtext.resource.IResourceDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildData {
    private final ToBeBuilt toBeBuilt;
    private final QueuedBuildData queuedBuildData;
    private final String projectName;
    private final ResourceSet resourceSet;

    public BuildData(String projectName, ResourceSet resourceSet, ToBeBuilt toBeBuilt, QueuedBuildData queuedBuildData) {
        this.projectName = projectName;
        this.resourceSet = resourceSet;
        this.toBeBuilt = toBeBuilt;
        this.queuedBuildData = queuedBuildData;
    }

    public boolean isEmpty() {
        return this.getToBeDeleted().isEmpty() && this.getToBeUpdated().isEmpty() && this.queuedBuildData.isEmpty(this.projectName);
    }

    public Set<URI> getToBeDeleted() {
        return this.toBeBuilt.getToBeDeleted();
    }

    public Set<URI> getToBeUpdated() {
        return this.toBeBuilt.getToBeUpdated();
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public Set<URI> getAndRemoveToBeDeleted() {
        Set<URI> result = this.toBeBuilt.getAndRemoveToBeDeleted();
        return result;
    }

    public void queueURI(URI uri) {
        this.queuedBuildData.queueURI(uri);
    }

    public Collection<IResourceDescription.Delta> getAndRemovePendingDeltas() {
        return this.queuedBuildData.getAndRemovePendingDeltas();
    }

    public Queue<URI> getURIQueue() {
        return this.queuedBuildData.getQueue(this.projectName);
    }

    public Iterable<URI> getAllRemainingURIs() {
        return this.queuedBuildData.getAllRemainingURIs();
    }

    public String getProjectName() {
        return this.projectName;
    }
}

