/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.refactoring;

import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.util.TypeConformanceComputer;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.refactoring.impl.DisplayChangeWrapper;
import org.eclipse.xtext.ui.refactoring.impl.StatusWrapper;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.typing.ITypeProvider;
import org.eclipse.xtext.xbase.ui.refactoring.ExpressionUtil;
import org.eclipse.xtext.xbase.ui.refactoring.IndentationUtil;
import org.eclipse.xtext.xbase.ui.refactoring.NewFeatureNameUtil;
import org.eclipse.xtext.xbase.ui.refactoring.TypeSerializationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractMethodRefactoring
extends Refactoring {
    public static final Logger LOG = Logger.getLogger(ExtractMethodRefactoring.class);
    @Inject
    private Provider<StatusWrapper> statusProvider;
    @Inject
    private ILocationInFileProvider locationInFileProvider;
    @Inject
    private ITypeProvider typeProvider;
    @Inject
    private TypeConformanceComputer typeConformance;
    @Inject
    private TypeSerializationUtil typeUtil;
    @Inject
    private ExpressionUtil expressionUtil;
    @Inject
    private NewFeatureNameUtil nameUtil;
    @Inject
    private IndentationUtil indentationUtil;
    @Inject
    private IXtendJvmAssociations associations;
    private IDocument document;
    private List<XExpression> expressions;
    private String methodName = "";
    private JvmVisibility visibility;
    private boolean isStatic;
    private List<ParameterInfo> parameterInfos = Lists.newArrayList();
    private boolean isExplicitlyDeclareReturnType;
    private XExpression firstExpression;
    private XExpression lastExpression;
    private URI resourceURI;
    private XtendClass xtendClass;
    private XtendFunction originalMethod;
    private MultiTextEdit textEdit;
    private List<String> localFeatureNames = Lists.newArrayList();
    private Multimap<String, XFeatureCall> externalFeatureCalls = HashMultimap.create();
    private XExpression returnExpression;
    private JvmTypeReference returnType;
    private Set<JvmTypeParameter> neededTypeParameters = Sets.newHashSet();

    public boolean initialize(IXtextDocument document, List<XExpression> expressions) {
        if (expressions.isEmpty() || document == null) {
            return false;
        }
        this.document = document;
        this.expressions = expressions;
        this.firstExpression = expressions.get(0);
        this.lastExpression = expressions.get(expressions.size() - 1);
        this.resourceURI = EcoreUtil2.getNormalizedResourceURI((EObject)this.firstExpression);
        this.xtendClass = (XtendClass)EcoreUtil2.getContainerOfType((EObject)this.firstExpression, XtendClass.class);
        this.originalMethod = (XtendFunction)EcoreUtil2.getContainerOfType((EObject)this.firstExpression, XtendFunction.class);
        if (this.xtendClass == null || this.originalMethod == null) {
            return false;
        }
        this.visibility = this.originalMethod.getVisibility();
        this.isStatic = this.originalMethod.isStatic();
        XExpression successorExpression = this.expressionUtil.findSuccessorExpressionForVariableDeclaration((EObject)this.lastExpression);
        this.nameUtil.setFeatureScopeContext(successorExpression);
        this.indentationUtil.initialize((IDocument)document, this.resourceURI);
        return true;
    }

    public String getName() {
        return "Extract Method Refactoring";
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public RefactoringStatus validateMethodName(String newMethodName) {
        RefactoringStatus status = new RefactoringStatus();
        this.nameUtil.checkNewFeatureName(newMethodName, true, status);
        return status;
    }

    public JvmVisibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(JvmVisibility visibility) {
        this.visibility = visibility;
    }

    public void setExplicitlyDeclareReturnType(boolean isExplicitlyDeclareReturnType) {
        this.isExplicitlyDeclareReturnType = isExplicitlyDeclareReturnType;
    }

    public boolean isExplicitlyDeclareReturnType() {
        return this.isExplicitlyDeclareReturnType;
    }

    public XtendClass getXtendClass() {
        return this.xtendClass;
    }

    public List<ParameterInfo> getParameterInfos() {
        return this.parameterInfos;
    }

    public RefactoringStatus validateParameters() {
        RefactoringStatus status = new RefactoringStatus();
        HashSet namesSoFar = Sets.newHashSet();
        for (ParameterInfo parameterInfo : this.parameterInfos) {
            String newName = parameterInfo.getNewName();
            if (namesSoFar.contains(newName)) {
                status.addError("Duplicate parameter name '" + newName + "'");
            }
            if (!Strings.equal((String)newName, (String)parameterInfo.getOldName()) && this.localFeatureNames.contains(newName)) {
                status.addError("'" + newName + "' is already used as a name in the selected code");
            }
            this.nameUtil.checkNewFeatureName(newName, false, status);
            namesSoFar.add(newName);
        }
        return status;
    }

    public String getMethodSignature() {
        boolean isFirst;
        StringBuilder builder = new StringBuilder("def ");
        if (this.visibility != JvmVisibility.PUBLIC) {
            builder.append(this.getVisibility().getName().toLowerCase()).append(" ");
        }
        if (this.isStatic) {
            builder.append("static ");
        }
        if (!this.neededTypeParameters.isEmpty()) {
            builder.append("<");
            isFirst = true;
            for (JvmTypeParameter typeParameter : this.associations.getDirectlyInferredOperation(this.originalMethod).getTypeParameters()) {
                if (!this.neededTypeParameters.contains(typeParameter)) continue;
                if (!isFirst) {
                    builder.append(", ");
                }
                isFirst = false;
                builder.append(this.typeUtil.serialize((JvmType)typeParameter, (EObject)this.firstExpression));
            }
            builder.append("> ");
        }
        if (this.isExplicitlyDeclareReturnType) {
            builder.append(this.typeUtil.serialize(this.returnType, (EObject)this.firstExpression)).append(" ");
        }
        builder.append(this.methodName).append("(");
        isFirst = true;
        for (ParameterInfo parameterInfo : this.getParameterInfos()) {
            if (!isFirst) {
                builder.append(", ");
            }
            isFirst = false;
            builder.append(parameterInfo.getOldTypeName()).append(" ").append(parameterInfo.getNewName());
        }
        builder.append(")");
        return builder.toString();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        StatusWrapper status = (StatusWrapper)this.statusProvider.get();
        try {
            HashSet calledExternalFeatureNames = Sets.newHashSet();
            this.returnType = this.calculateReturnType();
            if (!Strings.equal((String)"void", (String)this.typeUtil.serialize(this.returnType, (EObject)this.firstExpression))) {
                this.returnExpression = this.lastExpression;
            }
            boolean isReturnAllowed = this.isEndOfOriginalMethod();
            for (EObject element : EcoreUtil2.eAllContents((EObject)this.originalMethod.getExpression())) {
                boolean isLocalExpression = EcoreUtil.isAncestor(this.expressions, (EObject)element);
                if (element instanceof XFeatureCall) {
                    XFeatureCall featureCall = (XFeatureCall)element;
                    JvmIdentifiableElement feature = featureCall.getFeature();
                    JvmTypeReference featureType = this.typeProvider.getType((XExpression)featureCall);
                    boolean isLocalFeature = EcoreUtil.isAncestor(this.expressions, (EObject)feature);
                    if (!isLocalFeature && isLocalExpression) {
                        if (!(feature instanceof JvmFormalParameter) && !(feature instanceof XVariableDeclaration)) continue;
                        if (!calledExternalFeatureNames.contains(feature.getSimpleName())) {
                            calledExternalFeatureNames.add(feature.getSimpleName());
                            this.parameterInfos.add(new ParameterInfo(this.typeUtil.serialize(featureType, (EObject)this.firstExpression), feature.getSimpleName(), this.parameterInfos.size()));
                        }
                        this.externalFeatureCalls.put((Object)feature.getSimpleName(), (Object)featureCall);
                        continue;
                    }
                    if (!isLocalFeature || isLocalExpression) continue;
                    if (this.returnExpression != null) {
                        status.add(4, "Ambiguous return value: Multiple local variables are accesed in subsequent code.", new Object[0]);
                        break;
                    }
                    this.returnExpression = featureCall;
                    this.returnType = featureType;
                    continue;
                }
                if (!isLocalExpression) continue;
                if (element instanceof XReturnExpression && !isReturnAllowed) {
                    status.add(4, "Extracting method would break control flow due to return statements.", new Object[0]);
                    break;
                }
                if (element instanceof JvmTypeReference) {
                    EList typeParameters;
                    JvmType type = ((JvmTypeReference)element).getType();
                    if (!(type instanceof JvmTypeParameter) || !(typeParameters = this.associations.getDirectlyInferredOperation(this.originalMethod).getTypeParameters()).contains(type)) continue;
                    this.neededTypeParameters.add((JvmTypeParameter)type);
                    continue;
                }
                if (element instanceof JvmFormalParameter) {
                    this.localFeatureNames.add(((JvmFormalParameter)element).getName());
                    continue;
                }
                if (!(element instanceof XVariableDeclaration)) continue;
                this.localFeatureNames.add(((XVariableDeclaration)element).getIdentifier());
            }
        }
        catch (Exception exc) {
            this.handleException(exc, status);
        }
        return status.getRefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        StatusWrapper status = (StatusWrapper)this.statusProvider.get();
        try {
            status.merge(this.validateMethodName(this.methodName));
            status.merge(this.validateParameters());
            ITextRegion expressionsRegion = this.getExpressionsRegion();
            this.textEdit = new MultiTextEdit();
            this.textEdit.addChild((TextEdit)this.createMethodCallEdit(expressionsRegion));
            this.textEdit.addChild(this.createMethodDeclarationEdit(expressionsRegion));
        }
        catch (Exception exc) {
            this.handleException(exc, status);
        }
        return status.getRefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        DocumentChange change = new DocumentChange("Extract Method", this.document);
        change.setEdit((TextEdit)this.textEdit);
        change.setTextType(this.resourceURI.fileExtension());
        return new DisplayChangeWrapper((Change)change);
    }

    protected void handleException(Exception exc, StatusWrapper status) {
        status.add(4, "Error during refactoring: {0}", exc, LOG);
    }

    protected JvmTypeReference calculateReturnType() {
        ArrayList returnTypes = Lists.newArrayList();
        for (XExpression expression : this.expressions) {
            returnTypes.add(this.typeProvider.getCommonReturnType(expression, expression == this.lastExpression));
        }
        returnTypes.add(this.typeProvider.getType(this.lastExpression));
        return this.typeConformance.getCommonSuperType((List)returnTypes);
    }

    protected ITextRegion getExpressionsRegion() {
        ITextRegion firstRegion = this.locationInFileProvider.getFullTextRegion((EObject)this.firstExpression);
        ITextRegion lastRegion = this.locationInFileProvider.getFullTextRegion((EObject)this.lastExpression);
        TextRegion expressionRegion = new TextRegion(firstRegion.getOffset(), lastRegion.getOffset() + lastRegion.getLength() - firstRegion.getOffset());
        return expressionRegion;
    }

    protected TextEdit createMethodDeclarationEdit(ITextRegion expressionsRegion) throws BadLocationException {
        String expressionsAsString = this.getExtractedMethodBody(expressionsRegion);
        ITextRegion predecessorRegion = this.locationInFileProvider.getFullTextRegion((EObject)this.originalMethod);
        int methodIndentLevel = this.indentationUtil.getIndentationLevelAtOffset(predecessorRegion.getOffset());
        int expressionIndentLevel = this.indentationUtil.getIndentationLevelAtOffset(this.locationInFileProvider.getFullTextRegion((EObject)this.firstExpression).getOffset());
        StringBuilder declaration = new StringBuilder().append(this.indentationUtil.getLineSeparator()).append(this.indentationUtil.getLineSeparator()).append(this.indentationUtil.indent(methodIndentLevel)).append(this.getMethodSignature()).append(" {").append(this.indentationUtil.getLineSeparator()).append(this.indentationUtil.indent(methodIndentLevel + 1)).append(expressionsAsString.replaceAll(String.valueOf(Pattern.quote(this.indentationUtil.getLineSeparator())) + this.indentationUtil.indent(expressionIndentLevel), String.valueOf(this.indentationUtil.getLineSeparator()) + this.indentationUtil.indent(methodIndentLevel + 1)));
        if (this.isNeedsReturnExpression()) {
            declaration.append(this.indentationUtil.getLineSeparator()).append(this.indentationUtil.indent(methodIndentLevel + 1)).append(((XFeatureCall)this.returnExpression).getFeature().getSimpleName());
        }
        declaration.append(this.indentationUtil.getLineSeparator()).append(this.indentationUtil.indent(methodIndentLevel)).append("}");
        return new InsertEdit(predecessorRegion.getOffset() + predecessorRegion.getLength(), declaration.toString());
    }

    protected String getExtractedMethodBody(ITextRegion expressionsRegion) throws BadLocationException {
        String methodBody = this.getMethodBodyWithRenamedParameters(expressionsRegion);
        if (!(this.expressions.size() != 1 || !(this.firstExpression instanceof XClosure) || methodBody.startsWith("[") && methodBody.endsWith("]"))) {
            return "[" + methodBody + "]";
        }
        return methodBody;
    }

    protected String getMethodBodyWithRenamedParameters(ITextRegion expressionsRegion) throws BadLocationException {
        String expressionsAsString = this.document.get(expressionsRegion.getOffset(), expressionsRegion.getLength());
        ArrayList parameterRenames = Lists.newArrayList();
        for (final String parameterName : this.externalFeatureCalls.keySet()) {
            ParameterInfo parameter = (ParameterInfo)Iterables.find(this.parameterInfos, (Predicate)new Predicate<ParameterInfo>(){

                public boolean apply(ParameterInfo info) {
                    return Strings.equal((String)info.getOldName(), (String)parameterName);
                }
            });
            if (!parameter.isRenamed()) continue;
            for (XFeatureCall featureCall : this.externalFeatureCalls.get((Object)parameterName)) {
                ITextRegion textRegion = this.locationInFileProvider.getSignificantTextRegion((EObject)featureCall, (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1);
                parameterRenames.add(new ReplaceRegion(textRegion, parameter.getNewName()));
            }
        }
        Collections.sort(parameterRenames, new Comparator<ReplaceRegion>(){

            @Override
            public int compare(ReplaceRegion o1, ReplaceRegion o2) {
                return o2.getOffset() - o1.getOffset();
            }
        });
        StringBuffer buffer = new StringBuffer(expressionsAsString);
        for (ReplaceRegion parameterRename : parameterRenames) {
            buffer.replace(parameterRename.getOffset() - expressionsRegion.getOffset(), parameterRename.getEndOffset() - expressionsRegion.getOffset(), parameterRename.getText());
        }
        expressionsAsString = buffer.toString();
        return expressionsAsString;
    }

    protected ReplaceEdit createMethodCallEdit(ITextRegion expressionRegion) throws BadLocationException {
        String expressionExpanded;
        StringBuilder builder = new StringBuilder();
        if (this.isNeedsReturnExpression()) {
            JvmIdentifiableElement returnFeature = ((XFeatureCall)this.returnExpression).getFeature();
            if (this.isFinalFeature(returnFeature)) {
                builder.append("val ");
            } else {
                builder.append("var ");
            }
            builder.append(returnFeature.getSimpleName()).append(" = ");
        }
        boolean needsSurroundingParentheses = false;
        if (!(!(this.firstExpression.eContainer() instanceof XMemberFeatureCall) || ((XMemberFeatureCall)this.firstExpression.eContainer()).getMemberCallArguments().size() != 1 || (expressionExpanded = this.document.get(expressionRegion.getOffset() - 1, expressionRegion.getLength() + 2)).startsWith("(") && expressionExpanded.endsWith(")"))) {
            needsSurroundingParentheses = true;
            builder.append("(");
        }
        builder.append(this.methodName).append("(");
        boolean isFirst = true;
        for (ParameterInfo parameterInfo : this.getParameterInfos()) {
            if (!isFirst) {
                builder.append(", ");
            }
            isFirst = false;
            builder.append(parameterInfo.getOldName());
        }
        builder.append(")");
        if (needsSurroundingParentheses) {
            builder.append(")");
        }
        return new ReplaceEdit(expressionRegion.getOffset(), expressionRegion.getLength(), builder.toString());
    }

    protected boolean isEndOfOriginalMethod() {
        EObject eContainer = this.lastExpression.eContainer();
        if (eContainer instanceof XBlockExpression && eContainer.eContainer() == this.originalMethod) {
            EList siblings = ((XBlockExpression)eContainer).getExpressions();
            return siblings.indexOf((Object)this.lastExpression) == siblings.size() - 1;
        }
        return false;
    }

    protected boolean isNeedsReturnExpression() {
        return this.returnExpression != null && this.returnExpression != this.lastExpression;
    }

    protected boolean isFinalFeature(JvmIdentifiableElement returnFeature) {
        return returnFeature instanceof JvmFormalParameter || returnFeature instanceof XVariableDeclaration && !((XVariableDeclaration)returnFeature).isWriteable();
    }
}

