/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.refactoring;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.xtend.core.dispatch.DispatchingSupport;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.ui.refactoring.participant.JvmElementFinder;
import org.eclipse.xtext.common.types.util.jdt.JavaElementFinder;
import org.eclipse.xtext.ui.refactoring.impl.ProjectUtil;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispatchRenameSupport {
    private static final Logger LOG = Logger.getLogger(DispatchRenameSupport.class);
    @Inject
    private DispatchingSupport dispatchingSupport;
    @Inject
    private IXtendJvmAssociations associations;
    @Inject
    private JavaElementFinder javaElementFinder;
    @Inject
    private JvmElementFinder jvmElementFinder;
    @Inject
    private IResourceSetProvider resourceSetProvider;
    @Inject
    private ProjectUtil projectUtil;

    public Iterable<JvmOperation> getAllDispatchOperations(XtendFunction dispatchFunction) {
        Assert.isLegal((boolean)dispatchFunction.isDispatch());
        IProject project = this.projectUtil.getProject(dispatchFunction.eResource().getURI());
        ResourceSet tempResourceSet = this.resourceSetProvider.get(project);
        JvmOperation localDispatcher = this.associations.getDispatchOperation(dispatchFunction);
        XtendClass xtendClass = (XtendClass)dispatchFunction.eContainer();
        final LinkedHashSet dispatchCases = Sets.newLinkedHashSet();
        IAcceptor<JvmOperation> operationAcceptor = new IAcceptor<JvmOperation>(){

            public void accept(JvmOperation operation) {
                dispatchCases.add(operation);
            }
        };
        HashSet processedTypes = Sets.newHashSet();
        this.addDispatcher(this.associations.getInferredType(xtendClass), (Pair<String, Integer>)Tuples.create((Object)localDispatcher.getSimpleName(), (Object)localDispatcher.getParameters().size()), operationAcceptor, processedTypes, tempResourceSet);
        return dispatchCases;
    }

    protected boolean addDispatcher(JvmGenericType type, Pair<String, Integer> signature, IAcceptor<JvmOperation> acceptor, Set<JvmGenericType> processedTypes, ResourceSet tempResourceSet) {
        JvmOperation dispatcher;
        if (processedTypes.contains(type)) {
            return false;
        }
        processedTypes.add(type);
        boolean needProcessSubclasses = false;
        XtendClass xtendClass = this.associations.getXtendClass(type);
        if (xtendClass != null && (dispatcher = this.dispatchingSupport.findSyntheticDispatchMethod(xtendClass, signature)) != null) {
            needProcessSubclasses = true;
            acceptor.accept((Object)dispatcher);
        }
        for (JvmOperation dispatchCase : this.dispatchingSupport.getDispatchMethods(type).get(signature)) {
            if (dispatchCase.getDeclaringType() != type) continue;
            needProcessSubclasses = true;
            acceptor.accept((Object)dispatchCase);
        }
        for (JvmTypeReference superTypeRef : type.getSuperTypes()) {
            JvmType superType = superTypeRef.getType();
            if (!(superType instanceof JvmGenericType)) continue;
            needProcessSubclasses |= this.addDispatcher((JvmGenericType)superType, signature, acceptor, processedTypes, tempResourceSet);
        }
        if (needProcessSubclasses) {
            for (JvmGenericType subType : this.getSubTypes(type, tempResourceSet)) {
                needProcessSubclasses |= this.addDispatcher(subType, signature, acceptor, processedTypes, tempResourceSet);
            }
        }
        return needProcessSubclasses;
    }

    protected Iterable<JvmGenericType> getSubTypes(JvmGenericType type, ResourceSet tempResourceSet) {
        IType javaType = (IType)this.javaElementFinder.findExactElementFor((JvmIdentifiableElement)type);
        ArrayList allSubTypes = Lists.newArrayList();
        try {
            ITypeHierarchy typeHierarchy = javaType.newTypeHierarchy(javaType.getJavaProject(), (IProgressMonitor)new NullProgressMonitor());
            IType[] iTypeArray = typeHierarchy.getSubtypes(javaType);
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType subType = iTypeArray[n2];
                EObject jvmSubType = this.jvmElementFinder.getCorrespondingJvmElement((IJavaElement)subType, tempResourceSet);
                if (jvmSubType instanceof JvmGenericType) {
                    EObject indexJvmSubType = this.jvmElementFinder.findJvmElementDeclarationInIndex(jvmSubType, subType.getJavaProject().getProject(), type.eResource().getResourceSet());
                    if (indexJvmSubType instanceof JvmGenericType) {
                        allSubTypes.add((JvmGenericType)indexJvmSubType);
                    } else {
                        EObject jvmSubTypeInOtherResourceSet = type.eResource().getResourceSet().getEObject(EcoreUtil2.getNormalizedURI((EObject)jvmSubType), true);
                        if (jvmSubTypeInOtherResourceSet instanceof JvmGenericType) {
                            allSubTypes.add((JvmGenericType)jvmSubTypeInOtherResourceSet);
                        }
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            LOG.error((Object)"Error calculating subtypes", (Throwable)e);
        }
        return allSubTypes;
    }
}

