/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.impl;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.resource.impl.AbstractCompoundSelectable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceSetBasedResourceDescriptions
extends AbstractCompoundSelectable
implements IResourceDescriptions.IContextAware {
    private ResourceSet resourceSet;
    @Inject
    private IResourceServiceProvider.Registry registry;

    public void setRegistry(IResourceServiceProvider.Registry registry) {
        this.registry = registry;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    @Override
    public Iterable<IResourceDescription> getAllResourceDescriptions() {
        return Iterables.filter((Iterable)new Iterable<IResourceDescription>(){

            @Override
            public Iterator<IResourceDescription> iterator() {
                return new AbstractIterator<IResourceDescription>(){
                    int index = 0;
                    List<Resource> resources;
                    {
                        this.resources = ResourceSetBasedResourceDescriptions.this.resourceSet.getResources();
                    }

                    protected IResourceDescription computeNext() {
                        if (this.resources.size() <= this.index) {
                            return (IResourceDescription)this.endOfData();
                        }
                        Resource resource = this.resources.get(this.index);
                        ++this.index;
                        return ResourceSetBasedResourceDescriptions.this.getResourceDescription(resource.getURI());
                    }
                };
            }
        }, (Predicate)Predicates.notNull());
    }

    @Override
    protected Iterable<? extends ISelectable> getSelectables() {
        return this.getAllResourceDescriptions();
    }

    @Override
    public boolean isEmpty() {
        return this.resourceSet.getResources().isEmpty();
    }

    protected boolean hasDescription(URI uri) {
        Resource resource = this.resourceSet.getResource(uri, false);
        return resource != null;
    }

    @Override
    public IResourceDescription getResourceDescription(URI uri) {
        Resource resource = this.resourceSet.getResource(uri, false);
        if (resource == null) {
            return null;
        }
        IResourceServiceProvider resourceServiceProvider = this.registry.getResourceServiceProvider(uri);
        if (resourceServiceProvider == null) {
            return null;
        }
        IResourceDescription.Manager manager = resourceServiceProvider.getResourceDescriptionManager();
        if (manager == null) {
            return null;
        }
        return manager.getResourceDescription(resource);
    }

    @Override
    public void setContext(Notifier ctx) {
        this.resourceSet = EcoreUtil2.getResourceSet(ctx);
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + "\n  " + Joiner.on((String)"\n  ").join(this.getAllResourceDescriptions()) + "\n]";
    }
}

